<?php

namespace App\Http\Controllers\Student;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class ProfileController extends Controller
{
    /**
     * Show the edit profile form for the logged-in student.
     */
    public function edit()
    {
        $student = Auth::user();

        return view('student.profile.edit', [
            'student' => $student,
        ]);
    }

    /**
     * Update the logged-in student's profile.
     */
    public function update(Request $request)
    {
        $student = Auth::user();

        $validated = $request->validate([
            'first_name' => ['nullable', 'string', 'max:255'],
            'last_name' => ['nullable', 'string', 'max:255'],
            'phone' => ['nullable', 'string', 'max:50'],
            'national_id_number' => ['nullable', 'string', 'max:50'],
            'date_of_birth' => ['nullable', 'date'],
            'guardian_name' => ['nullable', 'string', 'max:255'],
            'guardian_phone' => ['nullable', 'string', 'max:50'],
            'address' => ['nullable', 'string', 'max:500'],
            'id_document' => ['nullable', 'file', 'mimes:pdf,jpg,jpeg,png', 'max:5120'],
            'kcpe_certificate' => ['nullable', 'file', 'mimes:pdf,jpg,jpeg,png', 'max:5120'],
            'kcse_certificate' => ['nullable', 'file', 'mimes:pdf,jpg,jpeg,png', 'max:5120'],
            'birth_certificate' => ['nullable', 'file', 'mimes:pdf,jpg,jpeg,png', 'max:5120'],
        ]);

        // Handle file uploads
        $data = $validated;

        if ($request->hasFile('id_document')) {
            if ($student->id_document_path) {
                Storage::disk('public')->delete($student->id_document_path);
            }
            $data['id_document_path'] = $request->file('id_document')->store('student_documents/id', 'public');
        }

        if ($request->hasFile('kcpe_certificate')) {
            if ($student->kcpe_certificate_path) {
                Storage::disk('public')->delete($student->kcpe_certificate_path);
            }
            $data['kcpe_certificate_path'] = $request->file('kcpe_certificate')->store('student_documents/kcpe', 'public');
        }

        if ($request->hasFile('kcse_certificate')) {
            if ($student->kcse_certificate_path) {
                Storage::disk('public')->delete($student->kcse_certificate_path);
            }
            $data['kcse_certificate_path'] = $request->file('kcse_certificate')->store('student_documents/kcse', 'public');
        }

        if ($request->hasFile('birth_certificate')) {
            if ($student->birth_certificate_path) {
                Storage::disk('public')->delete($student->birth_certificate_path);
            }
            $data['birth_certificate_path'] = $request->file('birth_certificate')->store('student_documents/birth', 'public');
        }

        $student->update($data);

        return redirect()
            ->route('student.profile.edit')
            ->with('success', 'Profile updated successfully.');
    }
}
