<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssessorToolStructure extends Model
{
    use HasFactory;

    protected $fillable = [
        'assignment_id',
        'structure',
        'original_file_path',
        'total_marks',
        'header_data',
    ];

    protected $casts = [
        'structure' => 'array',
        'header_data' => 'array',
        'total_marks' => 'decimal:2',
    ];

    // Relationships
    public function assignment()
    {
        return $this->belongsTo(Assignment::class);
    }

    public function marks()
    {
        return $this->hasMany(AssessorToolMark::class, 'structure_id');
    }
}
