<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Department extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'code',
        'description',
    ];

    // Relationships
    public function users()
    {
        return $this->hasMany(User::class);
    }

    public function classes()
    {
        return $this->hasMany(SchoolClass::class);
    }

    public function termDepartmentUnits()
    {
        return $this->hasMany(TermDepartmentUnit::class);
    }

    public function units()
    {
        return $this->belongsToMany(Unit::class, 'term_department_units', 'department_id', 'unit_id')
                    ->withPivot('term_id')
                    ->withTimestamps();
    }
}
