<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PracticalEvidenceComment extends Model
{
    use HasFactory;

    protected $table = 'practical_evidence_comments';

    protected $fillable = [
        'practical_evidence_id',
        'task_id',
        'user_id',
        'role',
        'comment',
    ];

    // Relationships
    public function practicalEvidence()
    {
        return $this->belongsTo(PracticalEvidence::class, 'practical_evidence_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function isTrainerComment()
    {
        return $this->role === 'trainer';
    }

    public function isVerifierComment()
    {
        return $this->role === 'verifier';
    }

    public function isHODComment()
    {
        return $this->role === 'hod';
    }
}
