<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SchoolClass extends Model
{
    use HasFactory;

    protected $table = 'classes';

    protected $fillable = [
        'term_id',
        'department_id',
        'level_id',
        'name',
        'code',
    ];

    // Relationships
    public function term()
    {
        return $this->belongsTo(Term::class);
    }

    public function department()
    {
        return $this->belongsTo(Department::class);
    }

    public function level()
    {
        return $this->belongsTo(Level::class);
    }

    public function enrollments()
    {
        return $this->hasMany(Enrollment::class, 'class_id');
    }

    public function students()
    {
        return $this->belongsToMany(User::class, 'enrollments', 'class_id', 'student_id')
                    ->withPivot('enrolled_at', 'status')
                    ->withTimestamps();
    }

    public function poeSubmissions()
    {
        return $this->hasMany(PoeSubmission::class, 'class_id');
    }

    public function units()
    {
        return $this->belongsToMany(Unit::class, 'class_unit', 'class_id', 'unit_id')
                    ->withTimestamps();
    }
}

