<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ValidationStatusChanged extends Notification
{
    use Queueable;

    public $validationRequest;
    public $status;
    public $unitName;
    public $className;
    public $validatorName;
    public $comment;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($validationRequest, $status, $unitName, $className, $validatorName, $comment = null)
    {
        $this->validationRequest = $validationRequest;
        $this->status = $status;
        $this->unitName = $unitName;
        $this->className = $className;
        $this->validatorName = $validatorName;
        $this->comment = $comment;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['database'];
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        $statusMessages = [
            'approved' => 'approved',
            'rejected' => 'rejected',
            'returned_to_trainer' => 'returned for corrections',
        ];

        $statusMessage = $statusMessages[$this->status] ?? $this->status;
        
        $title = "Unit Validation {$statusMessage}";
        
        $message = "Your unit \"{$this->unitName}\" for class \"{$this->className}\" has been {$statusMessage} by {$this->validatorName}.";
        
        if ($this->comment) {
            $message .= "\n\nComment: {$this->comment}";
        }

        return [
            'title' => $title,
            'message' => $message,
            'sender_id' => $this->validationRequest->validated_by,
            'validation_request_id' => $this->validationRequest->id,
            'unit_id' => $this->validationRequest->unit_id,
            'class_id' => $this->validationRequest->class_id,
            'status' => $this->status,
        ];
    }
}
