<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('term_department_units', function (Blueprint $table) {
            $table->foreignId('level_id')->nullable()->after('department_id')->constrained('levels')->onDelete('cascade');
            
            // Drop old unique constraint
            $table->dropUnique(['term_id', 'department_id', 'unit_id']);
            
            // Add new unique constraint with level_id
            $table->unique(['term_id', 'department_id', 'level_id', 'unit_id'], 'term_dept_level_unit_unique');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('term_department_units', function (Blueprint $table) {
            // Drop new unique constraint
            $table->dropUnique('term_dept_level_unit_unique');
            
            // Restore old unique constraint
            $table->unique(['term_id', 'department_id', 'unit_id']);
            
            // Drop level_id column
            $table->dropForeign(['level_id']);
            $table->dropColumn('level_id');
        });
    }
};
