<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Create table with correct structure
        if (!Schema::hasTable('trainer_unit_class')) {
            Schema::create('trainer_unit_class', function (Blueprint $table) {
                $table->id();
                $table->foreignId('trainer_id')->constrained('users')->onDelete('cascade');
                $table->foreignId('unit_id')->constrained('units')->onDelete('cascade');
                $table->foreignId('class_id')->constrained('classes')->onDelete('cascade');
                $table->timestamps();
                
                // Prevent duplicate assignments: same trainer can't be assigned same unit in same class
                $table->unique(['trainer_id', 'unit_id', 'class_id'], 'trainer_unit_class_unique');
                
                // Prevent duplicate unit assignments to same class (enforced at application level)
                // Index for performance
                $table->index(['class_id', 'unit_id']);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('trainer_unit_class');
    }
};
