<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('assignment_submissions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('assignment_id')->constrained('assignments')->onDelete('cascade');
            $table->foreignId('student_id')->constrained('users')->onDelete('cascade');
            $table->text('feedback')->nullable();
            $table->json('attachments')->nullable(); // Store file paths
            $table->enum('status', ['draft', 'submitted', 'graded'])->default('draft');
            $table->decimal('marks', 5, 2)->nullable();
            $table->text('trainer_feedback')->nullable();
            $table->timestamp('submitted_at')->nullable();
            $table->timestamps();
            
            $table->unique(['assignment_id', 'student_id']); // One submission per student per assignment
            $table->index(['student_id', 'status']);
            $table->index(['assignment_id', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::dropIfExists('assignment_submissions');
    }
};
