<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('assessor_tool_structures', function (Blueprint $table) {
            $table->id();
            $table->foreignId('assignment_id')->constrained('assignments')->onDelete('cascade');
            $table->json('structure'); // Stores sections, rows, max marks, etc.
            $table->string('original_file_path')->nullable(); // Path to original uploaded file
            $table->decimal('total_marks', 8, 2)->default(0); // Total marks available
            $table->text('header_data')->nullable(); // Store header info (candidate name, assessor name, venue, date)
            $table->timestamps();
            
            $table->unique('assignment_id'); // One structure per assignment
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('assessor_tool_structures');
    }
};
