<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Change marks column from decimal(5,2) to decimal(8,2) to support values up to 999999.99
        // Using raw SQL for PostgreSQL
        DB::statement('ALTER TABLE assignment_submissions ALTER COLUMN marks TYPE DECIMAL(8,2)');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Revert back to decimal(5,2)
        DB::statement('ALTER TABLE assignment_submissions ALTER COLUMN marks TYPE DECIMAL(5,2)');
    }
};
