<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Check if admin already exists
        $admin = User::where('email', 'admin@epoe.com')->first();
        
        if (!$admin) {
            User::create([
                'name' => 'System Administrator',
                'email' => 'admin@epoe.com',
                'password' => Hash::make('admin123'),
                'role' => 'admin',
                'status' => 'active',
                'email_verified_at' => now(),
            ]);
            
            $this->command->info('Admin user created successfully!');
            $this->command->info('Email: admin@epoe.com');
            $this->command->info('Password: admin123');
        } else {
            $this->command->warn('Admin user already exists!');
        }
    }
}
