<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Setting;

class InstitutionSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $settings = [
            [
                'key' => 'institution.name',
                'value' => 'Technical and Vocational Education Training Institution',
                'type' => 'string',
                'description' => 'Institution name for report headers',
            ],
            [
                'key' => 'institution.address',
                'value' => '123 Education Street, City, Country',
                'type' => 'string',
                'description' => 'Institution physical address',
            ],
            [
                'key' => 'institution.phone',
                'value' => '+254 700 000 000',
                'type' => 'string',
                'description' => 'Institution contact phone number',
            ],
            [
                'key' => 'institution.email',
                'value' => 'info@institution.ac.ke',
                'type' => 'string',
                'description' => 'Institution contact email',
            ],
            [
                'key' => 'institution.website',
                'value' => 'www.institution.ac.ke',
                'type' => 'string',
                'description' => 'Institution website URL',
            ],
            [
                'key' => 'institution.logo',
                'value' => '',
                'type' => 'string',
                'description' => 'Path to institution logo image',
            ],
            [
                'key' => 'institution.footer_text',
                'value' => 'This report is generated by the Electronic Portfolio of Evidence (EPOE) System',
                'type' => 'string',
                'description' => 'Footer text for reports',
            ],
        ];

        foreach ($settings as $setting) {
            Setting::updateOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }
    }
}
