# Assessor Tool Expected Upload Format

This document describes the **minimum required format** for the assessor tool auto-parse.

## 1) TASK Headers (Mandatory)
Each section must start with a TASK header that **explicitly declares** the assessment type:

- `TASK 1: PRACTICAL – Machine Operation`
- `TASK 2: ORAL – Machine Operation`

Rules:
- `TASK` must be followed by a number.
- The type must be **PRACTICAL** or **ORAL**.
- The title can appear after a dash (e.g., `–` or `-`).

## 2) Table Structure (Minimum Required)
Each TASK must be followed by a table with **at least two columns**:

1. **Item/Question description** (first column)
2. **Marks Available** (second column)

Example header row:

| Items of Evaluation | Marks Available |
| --- | --- |

## 3) Optional Columns
If your tool includes these columns, they will be ignored by the current legacy parser, but they are safe to include:

- `No`
- `Marks Obtained` / `Marks Awarded`
- `Comments`
- `Expected Response`

## 4) Example (PRACTICAL + ORAL)

```
TASK 1: PRACTICAL – MACHINE OPERATION

| No | Items of Evaluation                            | Marks Available | Marks Obtained | Comments |
|----|-------------------------------------------------|-----------------|----------------|----------|
| 1  | Mentioned at least five likely causes...         | 5               |                |          |
| 2  | Identified at least five inspections...          | 5               |                |          |

TASK 2: ORAL – MACHINE OPERATION

| No | Questions                                       | Max Marks | Marks Awarded | Comments |
|----|-------------------------------------------------|-----------|---------------|----------|
| 1  | List two possible hardware causes...            | 4         |               |          |
| 2  | Which tool would you use to check RAM usage?    | 2         |               |          |
```

## 5) Common Reasons Parsing Fails
- Missing `PRACTICAL` or `ORAL` in the TASK header.
- TASK headers not starting with `TASK <number>:` at the beginning of the line.
- No numeric value present in the marks column.

