@extends('layouts.admin')

@section('title', 'Class Details')
@section('page-title', 'Class Details')

@section('content')
    <div class="max-w-7xl mx-auto">
        <div class="bg-white shadow rounded-lg mb-6">
            <div class="px-6 py-4 border-b border-gray-200">
                <div class="flex items-center justify-between">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">{{ $class->name }}</h2>
                        <p class="mt-1 text-sm text-gray-600">Code: {{ $class->code }}</p>
                    </div>
                    <a href="{{ route('admin.classes.edit', $class) }}" class="px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50">
                        Edit Class
                    </a>
                </div>
            </div>

            <div class="px-6 py-4">
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
                    <div class="bg-gray-50 rounded-lg p-4">
                        <p class="text-sm font-medium text-gray-600">Term</p>
                        <p class="text-lg font-bold text-gray-900 mt-1">{{ $class->term->name ?? '-' }}</p>
                    </div>
                    <div class="bg-gray-50 rounded-lg p-4">
                        <p class="text-sm font-medium text-gray-600">Department</p>
                        <p class="text-lg font-bold text-gray-900 mt-1">{{ $class->department->name ?? '-' }}</p>
                    </div>
                    <div class="bg-gray-50 rounded-lg p-4">
                        <p class="text-sm font-medium text-gray-600">Level</p>
                        <p class="text-lg font-bold text-gray-900 mt-1">{{ $class->level->name ?? '-' }}</p>
                    </div>
                    <div class="bg-gray-50 rounded-lg p-4">
                        <p class="text-sm font-medium text-gray-600">Total Students</p>
                        <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_students'] }}</p>
                    </div>
                    <div class="bg-gray-50 rounded-lg p-4">
                        <p class="text-sm font-medium text-gray-600">Assigned Units</p>
                        <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_units'] }}</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Assign Units to Class -->
        <div class="bg-white shadow rounded-lg mb-6">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-semibold text-gray-900">Assign Units to Class</h3>
                <p class="text-sm text-gray-600 mt-1">Assign units from {{ $class->department->name ?? 'the same department' }} to this class</p>
            </div>
            <form action="{{ route('admin.classes.assign-unit', $class) }}" method="POST" class="p-6">
                @csrf
                <div class="flex items-end space-x-4">
                    <div class="flex-1">
                        <label for="unit_id" class="block text-sm font-medium text-gray-700 mb-1">Select Unit</label>
                        <select name="unit_id" id="unit_id" required
                                class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <option value="">Select a Unit</option>
                            @foreach($availableUnits as $unit)
                                <option value="{{ $unit->id }}">{{ $unit->name }} ({{ $unit->code }})</option>
                            @endforeach
                        </select>
                        @if($availableUnits->count() == 0)
                            <p class="mt-1 text-xs text-gray-500">All available units from this department are already assigned</p>
                        @endif
                    </div>
                    <button type="submit" 
                            class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 {{ $availableUnits->count() == 0 ? 'opacity-50 cursor-not-allowed' : '' }}"
                            {{ $availableUnits->count() == 0 ? 'disabled' : '' }}>
                        Assign Unit
                    </button>
                </div>
            </form>
        </div>

        <!-- Assigned Units -->
        @if($class->units->count() > 0)
            <div class="bg-white shadow rounded-lg mb-6">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">Assigned Units ({{ $stats['total_units'] }})</h3>
                </div>
                <div class="px-6 py-4">
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Unit Name</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Code</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Department</th>
                                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @foreach($class->units as $unit)
                                    <tr>
                                        <td class="px-4 py-3 text-sm text-gray-900">{{ $unit->name }}</td>
                                        <td class="px-4 py-3 text-sm text-gray-600">{{ $unit->code }}</td>
                                        <td class="px-4 py-3 text-sm text-gray-600">{{ $unit->department->name ?? '-' }}</td>
                                        <td class="px-4 py-3 text-right text-sm font-medium">
                                            <form action="{{ route('admin.classes.remove-unit', $class) }}" method="POST" class="inline" onsubmit="return confirm('Remove this unit from class?');">
                                                @csrf
                                                <input type="hidden" name="unit_id" value="{{ $unit->id }}">
                                                <button type="submit" class="text-red-600 hover:text-red-900">Remove</button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        @else
            <div class="bg-white shadow rounded-lg mb-6">
                <div class="px-6 py-4 text-center text-sm text-gray-500">
                    No units assigned to this class yet. Use the form above to assign units.
                </div>
            </div>
        @endif

        @if($class->enrollments->count() > 0)
            <div class="bg-white shadow rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">Enrolled Students</h3>
                </div>
                <div class="px-6 py-4">
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Student Name</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Email</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Enrolled Date</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @foreach($class->enrollments as $enrollment)
                                    <tr>
                                        <td class="px-4 py-3 text-sm text-gray-900">{{ $enrollment->student->name }}</td>
                                        <td class="px-4 py-3 text-sm text-gray-600">{{ $enrollment->student->email }}</td>
                                        <td class="px-4 py-3 text-sm text-gray-600">{{ $enrollment->enrolled_at ? $enrollment->enrolled_at->format('M d, Y') : 'N/A' }}</td>
                                        <td class="px-4 py-3">
                                            <span class="px-2 py-1 text-xs rounded-full 
                                                @if($enrollment->status == 'active') bg-green-100 text-green-800
                                                @elseif($enrollment->status == 'completed') bg-gray-100 text-gray-800
                                                @else bg-red-100 text-red-800
                                                @endif">
                                                {{ ucfirst($enrollment->status) }}
                                            </span>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        @endif
    </div>
@endsection

