@extends('layouts.admin')

@section('title', 'Term Units')
@section('page-title', 'Term Units - History')

@section('content')
    <div class="mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Units - {{ $term->name }}</h1>
                <p class="mt-1 text-sm text-gray-600">View all units from this historical term</p>
            </div>
            <a href="{{ route('admin.history.show', $term) }}" class="text-indigo-600 hover:text-indigo-900">Back to Term Details</a>
        </div>
    </div>

    @if($units->isEmpty())
        <div class="bg-white shadow rounded-lg p-8 text-center">
            <h3 class="text-sm font-medium text-gray-900">No Units</h3>
            <p class="mt-1 text-sm text-gray-500">No units found for this term.</p>
        </div>
    @else
        <div class="bg-white shadow rounded-lg overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Unit Name</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Code</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Department</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($units as $unit)
                            <tr>
                                <td class="px-6 py-4 text-sm text-gray-900">{{ $unit->name }}</td>
                                <td class="px-6 py-4 text-sm text-gray-600">{{ $unit->code }}</td>
                                <td class="px-6 py-4 text-sm text-gray-600">{{ $unit->department->name ?? '-' }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @endif
@endsection

