@extends('layouts.admin')

@section('title', 'Practical Marks Compilation')
@section('page-title', 'Practical Marks Compilation')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-900 mb-2">Practical Marks Compilation</h1>
                <p class="text-gray-600">Assignment: {{ $assignment->title }}</p>
                <p class="text-sm text-gray-500">Unit: {{ $unit->name }} ({{ $unit->code }})</p>
            </div>
            <div class="flex gap-3">
                @if($assignment->results_locked)
                    <span class="px-3 py-2 bg-red-100 text-red-800 rounded-md text-sm font-medium">Results Locked</span>
                @else
                    <span class="px-3 py-2 bg-green-100 text-green-800 rounded-md text-sm font-medium">Results Unlocked</span>
                @endif
                @if($assignment->results_released)
                    <span class="px-3 py-2 bg-blue-100 text-blue-800 rounded-md text-sm font-medium">Results Released</span>
                @endif
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
        <div class="bg-white rounded-xl shadow-md p-4">
            <p class="text-sm text-gray-600">Total Students</p>
            <p class="text-2xl font-bold text-gray-900">{{ $stats['total_students'] }}</p>
        </div>
        <div class="bg-green-50 rounded-xl shadow-md p-4 border-l-4 border-green-500">
            <p class="text-sm text-green-700">Marked</p>
            <p class="text-2xl font-bold text-green-900">{{ $stats['marked'] }}</p>
        </div>
        <div class="bg-yellow-50 rounded-xl shadow-md p-4 border-l-4 border-yellow-500">
            <p class="text-sm text-yellow-700">Not Marked</p>
            <p class="text-2xl font-bold text-yellow-900">{{ $stats['not_marked'] }}</p>
        </div>
        <div class="bg-red-50 rounded-xl shadow-md p-4 border-l-4 border-red-500">
            <p class="text-sm text-red-700">Absent</p>
            <p class="text-2xl font-bold text-red-900">{{ $stats['absent'] }}</p>
        </div>
    </div>

    <!-- Actions -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
            <div class="flex flex-wrap gap-3">
                <form method="GET" action="{{ route('admin.practical-marks.index', $assignment) }}" class="flex gap-2">
                    <select name="status" onchange="this.form.submit()" class="rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="all" {{ $statusFilter === 'all' ? 'selected' : '' }}>All Status</option>
                        <option value="marked" {{ $statusFilter === 'marked' ? 'selected' : '' }}>Marked</option>
                        <option value="not_marked" {{ $statusFilter === 'not_marked' ? 'selected' : '' }}>Not Marked</option>
                        <option value="absent" {{ $statusFilter === 'absent' ? 'selected' : '' }}>Absent</option>
                    </select>
                    <select name="sort" onchange="this.form.submit()" class="rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="name" {{ $sortBy === 'name' ? 'selected' : '' }}>Sort by Name</option>
                        <option value="marks" {{ $sortBy === 'marks' ? 'selected' : '' }}>Sort by Marks</option>
                    </select>
                </form>
            </div>
            <div class="flex gap-2">
                @if(!$assignment->results_locked)
                    <form action="{{ route('admin.practical-marks.lock', $assignment) }}" method="POST" class="inline">
                        @csrf
                        <button type="submit" onclick="return confirm('Lock results? This will prevent further changes.')" 
                                class="px-4 py-2 bg-red-600 text-white rounded-md hover:bg-red-700 text-sm font-medium">
                            Lock Results
                        </button>
                    </form>
                @else
                    <form action="{{ route('admin.practical-marks.unlock', $assignment) }}" method="POST" class="inline">
                        @csrf
                        <button type="submit" onclick="return confirm('Unlock results?')" 
                                class="px-4 py-2 bg-yellow-600 text-white rounded-md hover:bg-yellow-700 text-sm font-medium">
                            Unlock Results
                        </button>
                    </form>
                @endif
                @if(!$assignment->results_released)
                    <form action="{{ route('admin.practical-marks.release', $assignment) }}" method="POST" class="inline">
                        @csrf
                        <button type="submit" onclick="return confirm('Release results to students?')" 
                                class="px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700 text-sm font-medium">
                            Release Results
                        </button>
                    </form>
                @endif
                <button onclick="exportPDF()" class="px-4 py-2 bg-red-600 text-white rounded-md hover:bg-red-700 text-sm font-medium">
                    Export PDF
                </button>
                <button onclick="exportExcel()" class="px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700 text-sm font-medium">
                    Export Excel
                </button>
            </div>
        </div>
    </div>

    <!-- Marks Table -->
    <div class="bg-white rounded-xl shadow-md overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">#</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Student Name</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Admission Number</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Class</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Marks</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($compiledMarks as $index => $item)
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $index + 1 }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $item['student']->name }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600">{{ $item['student']->admission_number ?? 'N/A' }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600">{{ $item['class']->name ?? 'N/A' }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-center">
                                @if($item['marking_status'] === 'marked')
                                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">Marked</span>
                                @elseif($item['marking_status'] === 'absent')
                                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">Absent</span>
                                @else
                                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">Not Marked</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-center text-sm font-medium text-gray-900">
                                {{ $item['marks'] > 0 ? number_format($item['marks'], 2) : '0.00' }} / {{ number_format($assignment->total_marks, 2) }}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-8 text-center text-gray-500">No students found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
function exportPDF() {
    window.location.href = '{{ route("admin.practical-marks.export", ["assignment" => $assignment, "format" => "pdf"]) }}';
}

function exportExcel() {
    window.location.href = '{{ route("admin.practical-marks.export", ["assignment" => $assignment, "format" => "excel"]) }}';
}
</script>
@endsection

