@extends('layouts.admin')

@section('title', 'Class Report')
@section('page-title', 'Class Report')

@section('content')
    <div class="bg-white rounded-lg shadow-sm p-8">
        <x-report-header 
            :institution="$institution" 
            title="Class Portfolio Report"
            :subtitle="$class->name . ' - ' . $class->department->name . ' (' . $class->term->name . ')'"
        />

        <!-- Class Information -->
        <div class="mb-6 bg-gray-50 p-4 rounded-lg">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div>
                    <p class="text-sm font-medium text-gray-600">Class Name</p>
                    <p class="text-lg font-semibold text-gray-900">{{ $class->name }}</p>
                </div>
                <div>
                    <p class="text-sm font-medium text-gray-600">Department</p>
                    <p class="text-lg font-semibold text-gray-900">{{ $class->department->name }}</p>
                </div>
                <div>
                    <p class="text-sm font-medium text-gray-600">Level</p>
                    <p class="text-lg font-semibold text-gray-900">{{ $class->level->name }}</p>
                </div>
                <div>
                    <p class="text-sm font-medium text-gray-600">Term</p>
                    <p class="text-lg font-semibold text-gray-900">{{ $class->term->name }}</p>
                </div>
            </div>
        </div>

        <!-- Summary Statistics -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
            <div class="bg-blue-50 p-4 rounded-lg">
                <p class="text-sm font-medium text-blue-600">Total Students</p>
                <p class="text-2xl font-bold text-blue-900 mt-1">{{ $enrollments->count() }}</p>
            </div>
            <div class="bg-green-50 p-4 rounded-lg">
                <p class="text-sm font-medium text-green-600">Total Submissions</p>
                <p class="text-2xl font-bold text-green-900 mt-1">{{ $submissions->count() }}</p>
            </div>
            <div class="bg-purple-50 p-4 rounded-lg">
                <p class="text-sm font-medium text-purple-600">Approved</p>
                <p class="text-2xl font-bold text-purple-900 mt-1">{{ $submissions->where('status', 'validator_approved')->count() }}</p>
            </div>
            <div class="bg-yellow-50 p-4 rounded-lg">
                <p class="text-sm font-medium text-yellow-600">Pending Review</p>
                <p class="text-2xl font-bold text-yellow-900 mt-1">{{ $submissions->whereIn('status', ['submitted', 'under_review'])->count() }}</p>
            </div>
        </div>

        <!-- Submissions by Student -->
        @if($submissions->count() > 0)
            <div class="mb-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Submissions by Student</h3>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Student</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Unit</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Evidence</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Submitted</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($submissions as $submission)
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm font-medium text-gray-900">{{ $submission->student->name }}</div>
                                        <div class="text-sm text-gray-500">{{ $submission->student->email }}</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm font-medium text-gray-900">{{ $submission->unit->code }}</div>
                                        <div class="text-sm text-gray-500">{{ $submission->unit->name }}</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $submission->getStatusBadgeClasses() }}">
                                            {{ $submission->getStatusLabel() }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        {{ $submission->evidence->count() }} file(s)
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        @if($submission->submitted_at)
                                            {{ $submission->submitted_at->format('M d, Y') }}
                                        @else
                                            <span class="text-gray-400">Not submitted</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        @endif

        <!-- Enrolled Students -->
        @if($enrollments->count() > 0)
            <div class="mb-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Enrolled Students ({{ $enrollments->count() }})</h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    @foreach($enrollments as $enrollment)
                        <div class="bg-gray-50 p-3 rounded-lg">
                            <p class="font-medium text-gray-900">{{ $enrollment->student->name }}</p>
                            <p class="text-sm text-gray-500">{{ $enrollment->student->email }}</p>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif

        <x-report-footer :institution="$institution" />
    </div>

    @if(request('format') !== 'pdf')
        <div class="mt-6 flex gap-4">
            <a href="{{ route('admin.reports.class', array_merge(['class' => $class->id], request()->all(), ['format' => 'pdf'])) }}" 
               class="px-4 py-2 bg-red-600 text-white rounded-md hover:bg-red-700">
                Export as PDF
            </a>
            <a href="{{ route('admin.reports.class', array_merge(['class' => $class->id], request()->all(), ['format' => 'excel'])) }}" 
               class="px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700">
                Export as Excel
            </a>
            <a href="{{ route('admin.reports.index') }}" 
               class="px-4 py-2 bg-gray-200 text-gray-700 rounded-md hover:bg-gray-300">
                Back to Reports
            </a>
        </div>
    @endif
@endsection

