@extends('layouts.admin')

@section('title', 'Student Report')
@section('page-title', 'Student Report')

@section('content')
    <div class="bg-white rounded-lg shadow-sm p-8">
        <x-report-header 
            :institution="$institution" 
            title="Student Portfolio Report"
            :subtitle="$student->name . ' - ' . ($term ? $term->name : 'All Terms')"
        />

        <!-- Student Information -->
        <div class="mb-6 bg-gray-50 p-4 rounded-lg">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <p class="text-sm font-medium text-gray-600">Student Name</p>
                    <p class="text-lg font-semibold text-gray-900">{{ $student->name }}</p>
                </div>
                <div>
                    <p class="text-sm font-medium text-gray-600">Email</p>
                    <p class="text-lg font-semibold text-gray-900">{{ $student->email }}</p>
                </div>
                <div>
                    <p class="text-sm font-medium text-gray-600">Phone</p>
                    <p class="text-lg font-semibold text-gray-900">{{ $student->phone ?? 'N/A' }}</p>
                </div>
                @if($student->department)
                    <div>
                        <p class="text-sm font-medium text-gray-600">Department</p>
                        <p class="text-lg font-semibold text-gray-900">{{ $student->department->name }}</p>
                    </div>
                @endif
            </div>
        </div>

        <!-- Summary Statistics -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
            <div class="bg-blue-50 p-4 rounded-lg">
                <p class="text-sm font-medium text-blue-600">Total Submissions</p>
                <p class="text-2xl font-bold text-blue-900 mt-1">{{ $submissions->count() }}</p>
            </div>
            <div class="bg-green-50 p-4 rounded-lg">
                <p class="text-sm font-medium text-green-600">Approved</p>
                <p class="text-2xl font-bold text-green-900 mt-1">{{ $submissions->where('status', 'validator_approved')->count() }}</p>
            </div>
            <div class="bg-yellow-50 p-4 rounded-lg">
                <p class="text-sm font-medium text-yellow-600">Under Review</p>
                <p class="text-2xl font-bold text-yellow-900 mt-1">{{ $submissions->whereIn('status', ['submitted', 'under_review', 'trainer_reviewed', 'hod_approved', 'exams_verified'])->count() }}</p>
            </div>
            <div class="bg-gray-50 p-4 rounded-lg">
                <p class="text-sm font-medium text-gray-600">Draft</p>
                <p class="text-2xl font-bold text-gray-900 mt-1">{{ $submissions->where('status', 'draft')->count() }}</p>
            </div>
        </div>

        <!-- Submissions List -->
        @if($submissions->count() > 0)
            <div class="mb-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Portfolio Submissions</h3>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Unit</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Class</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Evidence</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Submitted</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Marks</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($submissions as $submission)
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm font-medium text-gray-900">{{ $submission->unit->code }}</div>
                                        <div class="text-sm text-gray-500">{{ $submission->unit->name }}</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm font-medium text-gray-900">{{ $submission->schoolClass->name }}</div>
                                        <div class="text-sm text-gray-500">{{ $submission->schoolClass->department->name }}</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $submission->getStatusBadgeClasses() }}">
                                            {{ $submission->getStatusLabel() }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        {{ $submission->evidence->count() }} file(s)
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        @if($submission->submitted_at)
                                            {{ $submission->submitted_at->format('M d, Y') }}
                                        @else
                                            <span class="text-gray-400">Not submitted</span>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        @if($submission->reviews->count() > 0)
                                            @php
                                                $latestReview = $submission->reviews->sortByDesc('created_at')->first();
                                            @endphp
                                            @if($latestReview && $latestReview->marks)
                                                <span class="font-semibold text-gray-900">{{ $latestReview->marks }}</span>
                                            @else
                                                <span class="text-gray-400">Pending</span>
                                            @endif
                                        @else
                                            <span class="text-gray-400">Not reviewed</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        @else
            <div class="text-center py-12">
                <p class="text-gray-500">No submissions found for this student.</p>
            </div>
        @endif

        <x-report-footer :institution="$institution" />
    </div>

    @if(request('format') !== 'pdf')
        <div class="mt-6 flex gap-4">
            <a href="{{ route('admin.reports.student', array_merge(['student' => $student->id], request()->all(), ['format' => 'pdf'])) }}" 
               class="px-4 py-2 bg-red-600 text-white rounded-md hover:bg-red-700">
                Export as PDF
            </a>
            <a href="{{ route('admin.reports.student', array_merge(['student' => $student->id], request()->all(), ['format' => 'excel'])) }}" 
               class="px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700">
                Export as Excel
            </a>
            <a href="{{ route('admin.reports.index') }}" 
               class="px-4 py-2 bg-gray-200 text-gray-700 rounded-md hover:bg-gray-300">
                Back to Reports
            </a>
        </div>
    @endif
@endsection

