@extends('layouts.admin')

@section('title', 'Submissions Report')
@section('page-title', 'Submissions Report')

@section('content')
    <div class="bg-white rounded-lg shadow-sm p-8">
        <x-report-header 
            :institution="$institution" 
            title="Portfolio of Evidence Submissions Report"
            :subtitle="($term ? $term->name . ' - ' : '') . ($department ? $department->name : 'All Departments')"
        />

        <!-- Report Filters Applied -->
        <div class="mb-6 bg-gray-50 p-4 rounded-lg">
            <h3 class="text-sm font-semibold text-gray-700 mb-2">Report Filters</h3>
            <div class="grid grid-cols-2 md:grid-cols-4 gap-2 text-sm">
                <div>
                    <span class="font-medium">Term:</span> 
                    <span class="text-gray-600">{{ $term ? $term->name : 'All Terms' }}</span>
                </div>
                <div>
                    <span class="font-medium">Department:</span> 
                    <span class="text-gray-600">{{ $department ? $department->name : 'All Departments' }}</span>
                </div>
                <div>
                    <span class="font-medium">Level:</span> 
                    <span class="text-gray-600">{{ $level ? $level->name : 'All Levels' }}</span>
                </div>
                <div>
                    <span class="font-medium">Status:</span> 
                    <span class="text-gray-600">{{ $filters['status'] ? ucfirst(str_replace('_', ' ', $filters['status'])) : 'All Statuses' }}</span>
                </div>
            </div>
        </div>

        <!-- Summary Statistics -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
            <div class="bg-blue-50 p-4 rounded-lg">
                <p class="text-sm font-medium text-blue-600">Total Submissions</p>
                <p class="text-2xl font-bold text-blue-900 mt-1">{{ $submissions->count() }}</p>
            </div>
            <div class="bg-green-50 p-4 rounded-lg">
                <p class="text-sm font-medium text-green-600">Approved</p>
                <p class="text-2xl font-bold text-green-900 mt-1">{{ $submissions->where('status', 'validator_approved')->count() }}</p>
            </div>
            <div class="bg-yellow-50 p-4 rounded-lg">
                <p class="text-sm font-medium text-yellow-600">Under Review</p>
                <p class="text-2xl font-bold text-yellow-900 mt-1">{{ $submissions->whereIn('status', ['submitted', 'under_review'])->count() }}</p>
            </div>
            <div class="bg-red-50 p-4 rounded-lg">
                <p class="text-sm font-medium text-red-600">Rejected</p>
                <p class="text-2xl font-bold text-red-900 mt-1">{{ $submissions->where('status', 'rejected')->count() }}</p>
            </div>
        </div>

        <!-- Submissions Table -->
        @if($submissions->count() > 0)
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Student</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Unit</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Class</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Evidence</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Submitted</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($submissions as $submission)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900">{{ $submission->student->name }}</div>
                                    <div class="text-sm text-gray-500">{{ $submission->student->email }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900">{{ $submission->unit->code }}</div>
                                    <div class="text-sm text-gray-500">{{ $submission->unit->name }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900">{{ $submission->schoolClass->name }}</div>
                                    <div class="text-sm text-gray-500">{{ $submission->schoolClass->department->name }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $submission->getStatusBadgeClasses() }}">
                                        {{ $submission->getStatusLabel() }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $submission->evidence_count }} file(s)
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    @if($submission->submitted_at)
                                        {{ $submission->submitted_at->format('M d, Y') }}
                                    @else
                                        <span class="text-gray-400">Not submitted</span>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="text-center py-12">
                <p class="text-gray-500">No submissions found matching the selected filters.</p>
            </div>
        @endif

        <x-report-footer :institution="$institution" />
    </div>

    @if(request('format') !== 'pdf')
        <div class="mt-6 flex gap-4">
            <a href="{{ route('admin.reports.submissions', array_merge(request()->all(), ['format' => 'pdf'])) }}" 
               class="px-4 py-2 bg-red-600 text-white rounded-md hover:bg-red-700">
                Export as PDF
            </a>
            <a href="{{ route('admin.reports.submissions', array_merge(request()->all(), ['format' => 'excel'])) }}" 
               class="px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700">
                Export as Excel
            </a>
            <a href="{{ route('admin.reports.index') }}" 
               class="px-4 py-2 bg-gray-200 text-gray-700 rounded-md hover:bg-gray-300">
                Back to Reports
            </a>
        </div>
    @endif
@endsection

