@extends('layouts.admin')

@section('title', 'PoE Submissions')
@section('page-title', 'Portfolio of Evidence Submissions')

@section('content')
    <div class="mb-6 flex flex-col sm:flex-row sm:items-center sm:justify-between">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">PoE Submissions</h1>
            <p class="mt-1 text-sm text-gray-600">Manage and track all portfolio submissions</p>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-9 gap-4 mb-6">
        <a href="{{ route('admin.submissions.index', ['status' => '']) }}" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">Total</p>
                <p class="text-2xl font-bold text-gray-900">{{ $stats['total'] }}</p>
            </div>
        </a>
        <a href="{{ route('admin.submissions.index', ['status' => 'draft']) }}" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">Draft</p>
                <p class="text-2xl font-bold text-gray-500">{{ $stats['draft'] }}</p>
            </div>
        </a>
        <a href="{{ route('admin.submissions.index', ['status' => 'submitted']) }}" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">Submitted</p>
                <p class="text-2xl font-bold text-blue-600">{{ $stats['submitted'] }}</p>
            </div>
        </a>
        <a href="{{ route('admin.submissions.index', ['status' => 'under_review']) }}" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">Under Review</p>
                <p class="text-2xl font-bold text-yellow-600">{{ $stats['under_review'] }}</p>
            </div>
        </a>
        <a href="{{ route('admin.submissions.index', ['status' => 'trainer_reviewed']) }}" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">Trainer Reviewed</p>
                <p class="text-2xl font-bold text-purple-600">{{ $stats['trainer_reviewed'] }}</p>
            </div>
        </a>
        <a href="{{ route('admin.submissions.index', ['status' => 'hod_approved']) }}" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">HOD Approved</p>
                <p class="text-2xl font-bold text-indigo-600">{{ $stats['hod_approved'] }}</p>
            </div>
        </a>
        <a href="{{ route('admin.submissions.index', ['status' => 'exams_verified']) }}" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">Exams Verified</p>
                <p class="text-2xl font-bold text-cyan-600">{{ $stats['exams_verified'] }}</p>
            </div>
        </a>
        <a href="{{ route('admin.submissions.index', ['status' => 'validator_approved']) }}" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">Validated</p>
                <p class="text-2xl font-bold text-green-600">{{ $stats['validator_approved'] }}</p>
            </div>
        </a>
        <a href="{{ route('admin.submissions.index', ['status' => 'rejected']) }}" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">Rejected</p>
                <p class="text-2xl font-bold text-red-600">{{ $stats['rejected'] }}</p>
            </div>
        </a>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-lg shadow-sm p-6 mb-6">
        <form method="GET" action="{{ route('admin.submissions.index') }}" class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-4 gap-4">
            <div>
                <label for="term" class="block text-sm font-medium text-gray-700 mb-1">Term</label>
                <select name="term" id="term" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="">All Terms</option>
                    @foreach($filterOptions['terms'] as $term)
                        <option value="{{ $term->id }}" {{ request('term') == $term->id ? 'selected' : '' }}>
                            {{ $term->name }} @if($term->status === 'active')(Active)@endif
                        </option>
                    @endforeach
                </select>
            </div>
            <div>
                <label for="department" class="block text-sm font-medium text-gray-700 mb-1">Department</label>
                <select name="department" id="department" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="">All Departments</option>
                    @foreach($filterOptions['departments'] as $department)
                        <option value="{{ $department->id }}" {{ request('department') == $department->id ? 'selected' : '' }}>
                            {{ $department->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div>
                <label for="level" class="block text-sm font-medium text-gray-700 mb-1">Level</label>
                <select name="level" id="level" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="">All Levels</option>
                    @foreach($filterOptions['levels'] as $level)
                        <option value="{{ $level->id }}" {{ request('level') == $level->id ? 'selected' : '' }}>
                            {{ $level->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div>
                <label for="class" class="block text-sm font-medium text-gray-700 mb-1">Class</label>
                <select name="class" id="class" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="">All Classes</option>
                    @foreach($filterOptions['classes'] as $class)
                        <option value="{{ $class->id }}" {{ request('class') == $class->id ? 'selected' : '' }}>
                            {{ $class->name }} @if(isset($class->department)) ({{ $class->department->name }}) @endif
                        </option>
                    @endforeach
                </select>
            </div>
            <div>
                <label for="unit" class="block text-sm font-medium text-gray-700 mb-1">Unit</label>
                <select name="unit" id="unit" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="">All Units</option>
                    @foreach($filterOptions['units'] as $unit)
                        <option value="{{ $unit->id }}" {{ request('unit') == $unit->id ? 'selected' : '' }}>
                            {{ $unit->code }} - {{ $unit->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div>
                <label for="status" class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                <select name="status" id="status" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="">All Statuses</option>
                    <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>Draft</option>
                    <option value="submitted" {{ request('status') == 'submitted' ? 'selected' : '' }}>Submitted</option>
                    <option value="under_review" {{ request('status') == 'under_review' ? 'selected' : '' }}>Under Review</option>
                    <option value="trainer_reviewed" {{ request('status') == 'trainer_reviewed' ? 'selected' : '' }}>Trainer Reviewed</option>
                    <option value="hod_approved" {{ request('status') == 'hod_approved' ? 'selected' : '' }}>HOD Approved</option>
                    <option value="exams_verified" {{ request('status') == 'exams_verified' ? 'selected' : '' }}>Exams Verified</option>
                    <option value="validator_approved" {{ request('status') == 'validator_approved' ? 'selected' : '' }}>Validator Approved</option>
                    <option value="rejected" {{ request('status') == 'rejected' ? 'selected' : '' }}>Rejected</option>
                </select>
            </div>
            <div>
                <label for="student" class="block text-sm font-medium text-gray-700 mb-1">Student</label>
                <select name="student" id="student" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="">All Students</option>
                    @foreach($filterOptions['students'] as $student)
                        <option value="{{ $student->id }}" {{ request('student') == $student->id ? 'selected' : '' }}>
                            {{ $student->name }} ({{ $student->email }})
                        </option>
                    @endforeach
                </select>
            </div>
            <div>
                <label for="search" class="block text-sm font-medium text-gray-700 mb-1">Search</label>
                <input type="text" name="search" id="search" value="{{ request('search') }}" placeholder="Student, Unit..." class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            </div>
            <div class="md:col-span-3 lg:col-span-4 flex gap-2">
                <button type="submit" class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700">Filter</button>
                <a href="{{ route('admin.submissions.index') }}" class="px-4 py-2 bg-gray-200 text-gray-700 rounded-md hover:bg-gray-300">Clear</a>
            </div>
        </form>
    </div>

    <!-- Active Term Banner -->
    @if($activeTerm)
        <div class="bg-indigo-50 border-l-4 border-indigo-500 p-4 mb-6 rounded">
            <div class="flex">
                <div class="flex-shrink-0">
                    <svg class="h-5 w-5 text-indigo-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                    </svg>
                </div>
                <div class="ml-3">
                    <p class="text-sm text-indigo-700">
                        <strong>Active Term:</strong> {{ $activeTerm->name }} 
                        ({{ $activeTerm->start_date->format('M d, Y') }} - {{ $activeTerm->end_date->format('M d, Y') }})
                    </p>
                </div>
            </div>
        </div>
    @endif

    <!-- Submissions Table -->
    <div class="bg-white shadow-sm rounded-lg overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Student</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Unit</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Class</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Version</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Evidence</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Submitted</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($submissions as $submission)
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <div class="h-10 w-10 rounded-full bg-indigo-600 flex items-center justify-center">
                                        <span class="text-white font-semibold text-sm">{{ substr($submission->student->name, 0, 1) }}</span>
                                    </div>
                                    <div class="ml-4">
                                        <div class="text-sm font-medium text-gray-900">{{ $submission->student->name }}</div>
                                        <div class="text-sm text-gray-500">{{ $submission->student->email }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-sm font-medium text-gray-900">{{ $submission->unit->code }}</div>
                                <div class="text-sm text-gray-500">{{ Str::limit($submission->unit->name, 40) }}</div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-sm font-medium text-gray-900">{{ $submission->schoolClass->name }}</div>
                                <div class="text-sm text-gray-500">{{ $submission->schoolClass->department->name }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-2 py-1 text-xs font-semibold rounded-full
                                    @if($submission->status === 'draft') bg-gray-100 text-gray-800
                                    @elseif($submission->status === 'submitted') bg-blue-100 text-blue-800
                                    @elseif($submission->status === 'under_review') bg-yellow-100 text-yellow-800
                                    @elseif($submission->status === 'trainer_reviewed') bg-purple-100 text-purple-800
                                    @elseif($submission->status === 'hod_approved') bg-indigo-100 text-indigo-800
                                    @elseif($submission->status === 'exams_verified') bg-cyan-100 text-cyan-800
                                    @elseif($submission->status === 'validator_approved') bg-green-100 text-green-800
                                    @else bg-red-100 text-red-800
                                    @endif">
                                    {{ str_replace('_', ' ', ucfirst($submission->status)) }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                v{{ $submission->version }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                <span class="inline-flex items-center">
                                    <svg class="h-4 w-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                    </svg>
                                    {{ $submission->evidence_count }} file(s)
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                @if($submission->submitted_at)
                                    {{ $submission->submitted_at->format('M d, Y') }}
                                    <div class="text-xs text-gray-400">{{ $submission->submitted_at->format('h:i A') }}</div>
                                @else
                                    <span class="text-gray-400">Not submitted</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <a href="{{ route('admin.submissions.show', $submission) }}" class="text-indigo-600 hover:text-indigo-900">View</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="px-6 py-12 text-center text-gray-500">
                                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                                <p class="mt-2">No submissions found</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="bg-white px-4 py-3 border-t border-gray-200 sm:px-6">
            {{ $submissions->links() }}
        </div>
    </div>
@endsection

