@extends('layouts.admin')

@section('title', 'Submission Details')
@section('page-title', 'Portfolio Submission Details')

@section('content')
    <div class="mb-6">
        <a href="{{ route('admin.submissions.index') }}" class="text-indigo-600 hover:text-indigo-900 flex items-center">
            <svg class="h-5 w-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
            </svg>
            Back to Submissions
        </a>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Content -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Submission Info -->
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">Submission Information</h3>
                </div>
                <div class="px-6 py-4">
                    <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Student</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                <div class="flex items-center">
                                    <div class="h-8 w-8 rounded-full bg-indigo-600 flex items-center justify-center mr-2">
                                        <span class="text-white font-semibold text-xs">{{ substr($submission->student->name, 0, 1) }}</span>
                                    </div>
                                    <div>
                                        <div class="font-medium">{{ $submission->student->name }}</div>
                                        <div class="text-xs text-gray-500">{{ $submission->student->email }}</div>
                                    </div>
                                </div>
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Unit</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                <div class="font-medium">{{ $submission->unit->code }}</div>
                                <div class="text-xs text-gray-500">{{ $submission->unit->name }}</div>
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Class</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                <div class="font-medium">{{ $submission->schoolClass->name }}</div>
                                <div class="text-xs text-gray-500">
                                    {{ $submission->schoolClass->department->name }} - {{ $submission->schoolClass->level->name }}
                                </div>
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Term</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                {{ $submission->schoolClass->term->name }}
                                @if($submission->schoolClass->term->status === 'active')
                                    <span class="ml-2 px-2 py-0.5 text-xs rounded-full bg-green-100 text-green-800">Active</span>
                                @endif
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Status</dt>
                            <dd class="mt-1">
                                <span class="px-3 py-1 text-sm font-semibold rounded-full
                                    @if($submission->status === 'draft') bg-gray-100 text-gray-800
                                    @elseif($submission->status === 'submitted') bg-blue-100 text-blue-800
                                    @elseif($submission->status === 'under_review') bg-yellow-100 text-yellow-800
                                    @elseif($submission->status === 'trainer_reviewed') bg-purple-100 text-purple-800
                                    @elseif($submission->status === 'hod_approved') bg-indigo-100 text-indigo-800
                                    @elseif($submission->status === 'exams_verified') bg-cyan-100 text-cyan-800
                                    @elseif($submission->status === 'validator_approved') bg-green-100 text-green-800
                                    @else bg-red-100 text-red-800
                                    @endif">
                                    {{ str_replace('_', ' ', ucfirst($submission->status)) }}
                                </span>
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Version</dt>
                            <dd class="mt-1 text-sm text-gray-900">v{{ $submission->version }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Submitted At</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                @if($submission->submitted_at)
                                    {{ $submission->submitted_at->format('M d, Y h:i A') }}
                                @else
                                    <span class="text-gray-400">Not submitted</span>
                                @endif
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Created At</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $submission->created_at->format('M d, Y h:i A') }}</dd>
                        </div>
                    </dl>
                    @if($submission->notes)
                        <div class="mt-4 pt-4 border-t border-gray-200">
                            <dt class="text-sm font-medium text-gray-500 mb-1">Notes</dt>
                            <dd class="text-sm text-gray-900 bg-gray-50 p-3 rounded">{{ $submission->notes }}</dd>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Evidence Files -->
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50 flex justify-between items-center">
                    <h3 class="text-lg font-semibold text-gray-900">Evidence Files ({{ $submission->evidence->count() }})</h3>
                </div>
                <div class="px-6 py-4">
                    @forelse($submission->evidence as $evidence)
                        <div class="flex items-center justify-between p-4 border border-gray-200 rounded-lg mb-3 hover:bg-gray-50">
                            <div class="flex items-center space-x-4">
                                <div class="flex-shrink-0">
                                    @if($evidence->file_type === 'image')
                                        <svg class="h-10 w-10 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                        </svg>
                                    @elseif($evidence->file_type === 'video')
                                        <svg class="h-10 w-10 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z"></path>
                                        </svg>
                                    @else
                                        <svg class="h-10 w-10 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                        </svg>
                                    @endif
                                </div>
                                <div class="flex-1 min-w-0">
                                    <p class="text-sm font-medium text-gray-900 truncate">{{ $evidence->file_name }}</p>
                                    <p class="text-xs text-gray-500">
                                        {{ $evidence->file_type }} • {{ number_format($evidence->file_size / 1024, 2) }} KB
                                        @if($evidence->mime_type)
                                            • {{ $evidence->mime_type }}
                                        @endif
                                    </p>
                                    @if($evidence->description)
                                        <p class="text-xs text-gray-600 mt-1">{{ $evidence->description }}</p>
                                    @endif
                                    @if($evidence->tags && count($evidence->tags) > 0)
                                        <div class="mt-1 flex flex-wrap gap-1">
                                            @foreach($evidence->tags as $tag)
                                                <span class="px-2 py-0.5 text-xs bg-indigo-100 text-indigo-800 rounded">{{ $tag }}</span>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                            </div>
                            <div class="flex items-center space-x-2">
                                <a href="{{ route('admin.submissions.evidence.download', $evidence) }}" 
                                   class="px-3 py-1.5 text-sm bg-indigo-600 text-white rounded hover:bg-indigo-700">
                                    Download
                                </a>
                                @if($submission->status === 'draft')
                                    <form action="{{ route('admin.submissions.evidence.destroy', $evidence) }}" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this evidence file?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="px-3 py-1.5 text-sm bg-red-600 text-white rounded hover:bg-red-700">
                                            Delete
                                        </button>
                                    </form>
                                @endif
                            </div>
                        </div>
                    @empty
                        <p class="text-gray-500 text-center py-8">No evidence files uploaded yet</p>
                    @endforelse
                </div>
            </div>

            <!-- Reviews -->
            @if($submission->reviews->count() > 0)
                <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <h3 class="text-lg font-semibold text-gray-900">Reviews ({{ $submission->reviews->count() }})</h3>
                    </div>
                    <div class="px-6 py-4 space-y-4">
                        @foreach($submission->reviews as $review)
                            <div class="border-l-4 border-indigo-500 pl-4 py-2">
                                <div class="flex justify-between items-start mb-2">
                                    <div>
                                        <p class="font-medium text-gray-900">{{ $review->reviewer->name ?? 'Unknown' }}</p>
                                        <p class="text-xs text-gray-500">{{ $review->reviewed_at ? $review->reviewed_at->format('M d, Y h:i A') : 'Not reviewed' }}</p>
                                    </div>
                                    @if($review->marks)
                                        <span class="px-2 py-1 text-xs font-semibold bg-green-100 text-green-800 rounded">
                                            {{ $review->marks }} marks
                                        </span>
                                    @endif
                                </div>
                                @if($review->feedback)
                                    <p class="text-sm text-gray-700">{{ $review->feedback }}</p>
                                @endif
                                <span class="inline-block mt-2 px-2 py-1 text-xs rounded-full
                                    @if($review->status === 'approved') bg-green-100 text-green-800
                                    @elseif($review->status === 'rejected') bg-red-100 text-red-800
                                    @else bg-yellow-100 text-yellow-800
                                    @endif">
                                    {{ ucfirst($review->status) }}
                                </span>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif

            <!-- Validation -->
            @if($submission->validation)
                <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <h3 class="text-lg font-semibold text-gray-900">Validation</h3>
                    </div>
                    <div class="px-6 py-4">
                        <div class="flex justify-between items-start mb-2">
                            <div>
                                <p class="font-medium text-gray-900">{{ $submission->validation->validator->name ?? 'Unknown' }}</p>
                                <p class="text-xs text-gray-500">{{ $submission->validation->validated_at ? $submission->validation->validated_at->format('M d, Y h:i A') : 'Not validated' }}</p>
                            </div>
                            <span class="px-3 py-1 text-sm font-semibold rounded-full
                                @if($submission->validation->status === 'approved') bg-green-100 text-green-800
                                @elseif($submission->validation->status === 'rejected') bg-red-100 text-red-800
                                @else bg-yellow-100 text-yellow-800
                                @endif">
                                {{ ucfirst($submission->validation->status) }}
                            </span>
                        </div>
                        @if($submission->validation->comments)
                            <p class="text-sm text-gray-700 mt-2">{{ $submission->validation->comments }}</p>
                        @endif
                    </div>
                </div>
            @endif
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Status Update -->
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">Update Status</h3>
                </div>
                <div class="px-6 py-4">
                    <form action="{{ route('admin.submissions.update-status', $submission) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="mb-4">
                            <label for="status" class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                            <select name="status" id="status" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" required>
                                <option value="draft" {{ $submission->status === 'draft' ? 'selected' : '' }}>Draft</option>
                                <option value="submitted" {{ $submission->status === 'submitted' ? 'selected' : '' }}>Submitted</option>
                                <option value="under_review" {{ $submission->status === 'under_review' ? 'selected' : '' }}>Under Review</option>
                                <option value="trainer_reviewed" {{ $submission->status === 'trainer_reviewed' ? 'selected' : '' }}>Trainer Reviewed</option>
                                <option value="hod_approved" {{ $submission->status === 'hod_approved' ? 'selected' : '' }}>HOD Approved</option>
                                <option value="exams_verified" {{ $submission->status === 'exams_verified' ? 'selected' : '' }}>Exams Verified</option>
                                <option value="validator_approved" {{ $submission->status === 'validator_approved' ? 'selected' : '' }}>Validator Approved</option>
                                <option value="rejected" {{ $submission->status === 'rejected' ? 'selected' : '' }}>Rejected</option>
                            </select>
                        </div>
                        <div class="mb-4">
                            <label for="notes" class="block text-sm font-medium text-gray-700 mb-1">Notes (Optional)</label>
                            <textarea name="notes" id="notes" rows="3" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ $submission->notes }}</textarea>
                        </div>
                        <button type="submit" class="w-full px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700">
                            Update Status
                        </button>
                    </form>
                </div>
            </div>

            <!-- Actions -->
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">Actions</h3>
                </div>
                <div class="px-6 py-4 space-y-2">
                    @if($submission->status === 'draft')
                        <form action="{{ route('admin.submissions.destroy', $submission) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this submission? This action cannot be undone.');">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="w-full px-4 py-2 bg-red-600 text-white rounded-md hover:bg-red-700">
                                Delete Submission
                            </button>
                        </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

