@extends('layouts.admin')

@section('title', 'Term Details')
@section('page-title', 'Term Details')

@section('content')
    <div class="max-w-7xl mx-auto">
        <!-- Term Header -->
        <div class="bg-white shadow rounded-lg mb-6">
            <div class="px-6 py-4 border-b border-gray-200">
                <div class="flex items-center justify-between">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">{{ $term->name }}</h2>
                        <p class="mt-1 text-sm text-gray-600">
                            {{ $term->start_date->format('F d, Y') }} - {{ $term->end_date->format('F d, Y') }}
                            ({{ $term->getDurationInDays() }} days)
                        </p>
                    </div>
                    <div class="flex items-center space-x-3">
                        <span class="px-3 py-1 text-sm font-semibold rounded-full 
                            @if($term->status == 'active') bg-green-100 text-green-800
                            @elseif($term->status == 'draft') bg-gray-100 text-gray-800
                            @elseif($term->status == 'completed') bg-blue-100 text-blue-800
                            @else bg-gray-100 text-gray-800
                            @endif">
                            {{ ucfirst($term->status) }}
                        </span>
                        @if(!$term->isClosed())
                            <a href="{{ route('admin.terms.edit', $term) }}" 
                               class="px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50">
                                Edit Term
                            </a>
                        @endif
                        <a href="{{ route('admin.terms.index') }}" 
                           class="px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50">
                            Back to List
                        </a>
                    </div>
                </div>
            </div>

            <!-- Statistics -->
            <div class="px-6 py-4">
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <div class="bg-gray-50 rounded-lg p-4">
                        <p class="text-sm font-medium text-gray-600">Total Classes</p>
                        <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_classes'] }}</p>
                    </div>
                    <div class="bg-gray-50 rounded-lg p-4">
                        <p class="text-sm font-medium text-gray-600">Total Units</p>
                        <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_units'] }}</p>
                    </div>
                    <div class="bg-gray-50 rounded-lg p-4">
                        <p class="text-sm font-medium text-gray-600">Total Students</p>
                        <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_students'] }}</p>
                    </div>
                    <div class="bg-gray-50 rounded-lg p-4">
                        <p class="text-sm font-medium text-gray-600">Total Submissions</p>
                        <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_submissions'] }}</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Actions -->
        @if(!$term->isActive() && !$term->isClosed())
            <div class="bg-white shadow rounded-lg mb-6 p-4">
                <form action="{{ route('admin.terms.activate', $term) }}" method="POST" class="inline">
                    @csrf
                    <button type="submit" 
                            onclick="return confirm('Activate this term? The current active term will be closed.')"
                            class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700">
                        Activate This Term
                    </button>
                </form>
            </div>
        @endif

        @if($term->isActive())
            <div class="bg-white shadow rounded-lg mb-6 p-4">
                <form action="{{ route('admin.terms.close', $term) }}" method="POST" class="inline">
                    @csrf
                    <button type="submit" 
                            onclick="return confirm('Close this term? It will become read-only.')"
                            class="px-4 py-2 bg-yellow-600 text-white rounded-md hover:bg-yellow-700">
                        Close This Term
                    </button>
                </form>
            </div>
        @endif

        <!-- Classes -->
        @if($term->classes->count() > 0)
            <div class="bg-white shadow rounded-lg mb-6">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">Classes in This Term</h3>
                </div>
                <div class="px-6 py-4">
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Class Name</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Department</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Level</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @foreach($term->classes as $class)
                                    <tr>
                                        <td class="px-4 py-3 text-sm text-gray-900">{{ $class->name }}</td>
                                        <td class="px-4 py-3 text-sm text-gray-600">{{ $class->department->name ?? '-' }}</td>
                                        <td class="px-4 py-3 text-sm text-gray-600">{{ $class->level->name ?? '-' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        @endif

        <!-- Units -->
        @if($term->termDepartmentUnits->count() > 0)
            <div class="bg-white shadow rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">Units in This Term</h3>
                </div>
                <div class="px-6 py-4">
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Unit Name</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Department</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @foreach($term->termDepartmentUnits as $tdu)
                                    <tr>
                                        <td class="px-4 py-3 text-sm text-gray-900">{{ $tdu->unit->name ?? '-' }}</td>
                                        <td class="px-4 py-3 text-sm text-gray-600">{{ $tdu->department->name ?? '-' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        @endif
    </div>
@endsection

