@extends('layouts.admin')

@section('title', 'Create User')
@section('page-title', 'Create New User')

@section('content')
    <div class="max-w-4xl mx-auto">
        <div class="bg-white shadow rounded-lg">
            <div class="px-6 py-4 border-b border-gray-200">
                <h2 class="text-lg font-semibold text-gray-900">Create New User</h2>
                <p class="mt-1 text-sm text-gray-600">Add a new user to the system</p>
            </div>

            <form action="{{ route('admin.users.store') }}" method="POST" class="p-6">
                @csrf

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Name -->
                    <div>
                        <label for="name" class="block text-sm font-medium text-gray-700 mb-1">Full Name <span class="text-red-500">*</span></label>
                        <input type="text" name="name" id="name" value="{{ old('name') }}" required
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('name') border-red-300 @enderror">
                        @error('name')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Email -->
                    <div>
                        <label for="email" class="block text-sm font-medium text-gray-700 mb-1">Email Address <span class="text-red-500">*</span></label>
                        <input type="email" name="email" id="email" value="{{ old('email') }}" required
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('email') border-red-300 @enderror">
                        @error('email')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Role -->
                    <div>
                        <label for="role" class="block text-sm font-medium text-gray-700 mb-1">Role <span class="text-red-500">*</span></label>
                        <select name="role" id="role" required
                                x-model="selectedRole"
                                class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('role') border-red-300 @enderror">
                            <option value="">Select Role</option>
                            <option value="admin" {{ old('role') == 'admin' ? 'selected' : '' }}>Administrator</option>
                            <option value="exams_office" {{ old('role') == 'exams_office' ? 'selected' : '' }}>Exams Office</option>
                            <option value="hod" {{ old('role') == 'hod' ? 'selected' : '' }}>Head of Department (HOD)</option>
                            <option value="trainer" {{ old('role') == 'trainer' ? 'selected' : '' }}>Trainer</option>
                            <option value="validator" {{ old('role') == 'validator' ? 'selected' : '' }}>Validator</option>
                            <option value="student" {{ old('role') == 'student' ? 'selected' : '' }}>Student</option>
                        </select>
                        @error('role')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Department -->
                    <div>
                        <label for="department_id" class="block text-sm font-medium text-gray-700 mb-1">Department</label>
                        <select name="department_id" id="department_id"
                                x-model="selectedDepartment"
                                class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('department_id') border-red-300 @enderror">
                            <option value="">Select Department (Optional)</option>
                            @foreach($departments as $department)
                                <option value="{{ $department->id }}" {{ old('department_id') == $department->id ? 'selected' : '' }}>
                                    {{ $department->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('department_id')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Phone -->
                    <div>
                        <label for="phone" class="block text-sm font-medium text-gray-700 mb-1">Phone Number</label>
                        <input type="text" name="phone" id="phone" value="{{ old('phone') }}"
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('phone') border-red-300 @enderror">
                        @error('phone')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Status -->
                    <div>
                        <label for="status" class="block text-sm font-medium text-gray-700 mb-1">Status <span class="text-red-500">*</span></label>
                        <select name="status" id="status" required
                                class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('status') border-red-300 @enderror">
                            <option value="active" {{ old('status', 'active') == 'active' ? 'selected' : '' }}>Active</option>
                            <option value="inactive" {{ old('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                            <option value="suspended" {{ old('status') == 'suspended' ? 'selected' : '' }}>Suspended</option>
                        </select>
                        @error('status')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Password -->
                    <div>
                        <label for="password" class="block text-sm font-medium text-gray-700 mb-1">Password <span class="text-red-500">*</span></label>
                        <input type="password" name="password" id="password" required
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 @error('password') border-red-300 @enderror">
                        @error('password')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Confirm Password -->
                    <div>
                        <label for="password_confirmation" class="block text-sm font-medium text-gray-700 mb-1">Confirm Password <span class="text-red-500">*</span></label>
                        <input type="password" name="password_confirmation" id="password_confirmation" required
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                </div>

                <!-- Unit Selection (for Trainers) -->
                <div x-data="{ 
                    selectedRole: '{{ old('role', '') }}',
                    selectedDepartment: '{{ old('department_id', '') }}',
                    selectedUnits: @js(old('unit_ids', [])),
                    units: @js($units->map(function($unit) {
                        return [
                            'id' => $unit->id,
                            'name' => $unit->name,
                            'code' => $unit->code,
                            'department_id' => $unit->department_id,
                        ];
                    })->toArray()),
                    get filteredUnits() {
                        if (!this.selectedDepartment) return [];
                        return this.units.filter(u => u.department_id == this.selectedDepartment);
                    },
                    toggleUnit(unitId) {
                        const index = this.selectedUnits.indexOf(unitId);
                        if (index > -1) {
                            this.selectedUnits.splice(index, 1);
                        } else {
                            this.selectedUnits.push(unitId);
                        }
                    },
                    isUnitSelected(unitId) {
                        return this.selectedUnits.includes(unitId);
                    },
                    init() {
                        // Watch for department changes and clear units from other departments
                        this.$watch('selectedDepartment', (newDept, oldDept) => {
                            if (newDept !== oldDept && newDept) {
                                // Remove units that don't belong to the new department
                                this.selectedUnits = this.selectedUnits.filter(unitId => {
                                    const unit = this.units.find(u => u.id == unitId);
                                    return unit && unit.department_id == newDept;
                                });
                            }
                        });
                    }
                }" 
                x-show="selectedRole === 'trainer'"
                x-cloak
                class="mt-6 p-6 bg-gray-50 rounded-lg border border-gray-200">
                    <div class="mb-4">
                        <h3 class="text-sm font-semibold text-gray-900 mb-2">Assign Units to Trainer (Optional)</h3>
                        <p class="text-xs text-gray-600 mb-4">
                            Select specific units to assign to this trainer. Units are optional - a trainer can exist without any assigned units.
                        </p>
                        <p x-show="!selectedDepartment" class="text-xs text-amber-600 mb-2">
                            Please select a department first to see available units.
                        </p>
                        <p x-show="selectedDepartment && filteredUnits.length === 0" class="text-xs text-gray-500 mb-2">
                            No units available in the selected department.
                        </p>
                    </div>
                    
                    <div x-show="selectedDepartment && filteredUnits.length > 0" class="max-h-60 overflow-y-auto border border-gray-200 rounded-md bg-white p-4">
                        <div class="space-y-2">
                            <template x-for="unit in filteredUnits" :key="unit.id">
                                <label class="flex items-center space-x-3 p-2 hover:bg-gray-50 rounded cursor-pointer">
                                    <input type="checkbox" 
                                           :value="unit.id"
                                           :checked="isUnitSelected(unit.id)"
                                           @change="toggleUnit(unit.id)"
                                           name="unit_ids[]"
                                           class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                    <span class="text-sm text-gray-700">
                                        <span x-text="unit.name"></span>
                                        <span x-show="unit.code" class="text-gray-500"> (<span x-text="unit.code"></span>)</span>
                                    </span>
                                </label>
                            </template>
                        </div>
                    </div>
                    
                    <div class="mt-4 flex items-center justify-between">
                        <button type="button" 
                                @click="selectedUnits = filteredUnits.map(u => u.id)"
                                x-show="selectedDepartment && filteredUnits.length > 0"
                                class="text-xs text-indigo-600 hover:text-indigo-800">
                            Select All
                        </button>
                        <button type="button" 
                                @click="selectedUnits = []"
                                x-show="selectedDepartment && filteredUnits.length > 0"
                                class="text-xs text-gray-600 hover:text-gray-800">
                            Clear Selection
                        </button>
                    </div>
                </div>

                <!-- Form Actions -->
                <div class="mt-6 flex items-center justify-end space-x-3">
                    <a href="{{ route('admin.users.index') }}" 
                       class="px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                        Cancel
                    </a>
                    <button type="submit"
                            class="px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                        Create User
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection

