<x-guest-layout>
    <div class="min-h-screen flex items-center justify-center bg-gradient-to-br from-indigo-50 via-white to-purple-50 py-12 px-4 sm:px-6 lg:px-8">
        <div class="max-w-md w-full">
            <!-- Header -->
            <div class="text-center mb-8">
                @php
                    $logoPath = \App\Models\Setting::get('institution.logo');
                @endphp
                @if($logoPath)
                    <div class="flex justify-center mb-4">
                        <img src="{{ asset('storage/' . $logoPath) }}" 
                             alt="{{ \App\Models\Setting::get('institution.name') ?? 'Institution' }}" 
                             class="h-20 w-auto object-contain">
                    </div>
                @endif
                <h1 class="text-4xl font-bold text-gray-900 mb-2">
                    Electronic Portfolio of Evidence
                </h1>
            </div>

            <!-- Login Form -->
            <div class="bg-white rounded-xl shadow-lg p-8">
                <!-- Session Status -->
                <x-auth-session-status class="mb-4" :status="session('status')" />

                <form method="POST" action="{{ route('login') }}">
                    @csrf

                    <!-- Email Address -->
                    <div>
                        <x-input-label for="email" :value="__('Email Address')" />
                        <x-text-input id="email" 
                                     class="block mt-1 w-full" 
                                     type="email" 
                                     name="email" 
                                     :value="old('email')" 
                                     required 
                                     autofocus 
                                     autocomplete="username" 
                                     placeholder="Enter your email address" />
                        <x-input-error :messages="$errors->get('email')" class="mt-2" />
                    </div>

                    <!-- Password -->
                    <div class="mt-4">
                        <x-input-label for="password" :value="__('Password')" />
                        <x-text-input id="password" 
                                     class="block mt-1 w-full"
                                     type="password"
                                     name="password"
                                     required 
                                     autocomplete="current-password" 
                                     placeholder="Enter your password" />
                        <x-input-error :messages="$errors->get('password')" class="mt-2" />
                    </div>

                    <!-- Remember Me -->
                    <div class="block mt-4">
                        <label for="remember_me" class="inline-flex items-center">
                            <input id="remember_me" 
                                   type="checkbox" 
                                   class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500" 
                                   name="remember">
                            <span class="ml-2 text-sm text-gray-600">{{ __('Remember me') }}</span>
                        </label>
                    </div>

                    <!-- Submit Button -->
                    <div class="flex items-center justify-between mt-6">
                        @if (Route::has('password.request'))
                            <a class="underline text-sm text-gray-600 hover:text-gray-900 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500" 
                               href="{{ route('password.request') }}">
                                {{ __('Forgot password?') }}
                            </a>
                        @endif

                        <x-primary-button class="ml-auto">
                            {{ __('Log in') }}
                        </x-primary-button>
                    </div>
                </form>

                <!-- Register Link -->
                <div class="mt-6 text-center">
                    <p class="text-sm text-gray-600">
                        Don't have an account? 
                        <a href="{{ route('register') }}" class="font-medium text-indigo-600 hover:text-indigo-500">
                            Register as Student
                        </a>
                    </p>
                    <p class="text-xs text-gray-500 mt-2">
                        Other roles? Contact your administrator for account creation
                    </p>
                </div>
            </div>

            <!-- Role Information -->
            <div class="mt-6 bg-white rounded-lg shadow-md p-6">
                <h3 class="text-sm font-semibold text-gray-900 mb-3 text-center">System Roles</h3>
                <div class="grid grid-cols-2 md:grid-cols-3 gap-3 text-xs">
                    <div class="flex items-center">
                        <span class="font-medium text-gray-700">👨‍💼 Admin</span>
                    </div>
                    <div class="flex items-center">
                        <span class="font-medium text-gray-700">👔 HOD</span>
                    </div>
                    <div class="flex items-center">
                        <span class="font-medium text-gray-700">👨‍🏫 Trainer</span>
                    </div>
                    <div class="flex items-center">
                        <span class="font-medium text-gray-700">📋 Exams Office</span>
                    </div>
                    <div class="flex items-center">
                        <span class="font-medium text-gray-700">✅ Validator</span>
                    </div>
                    <div class="flex items-center">
                        <span class="font-medium text-gray-700">👨‍🎓 Student</span>
                    </div>
                </div>
                <p class="text-xs text-gray-500 mt-3 text-center">
                    All users log in with the same form. Your role determines your dashboard access.
                </p>
            </div>
        </div>
    </div>
</x-guest-layout>
