<x-guest-layout>
    <div class="min-h-screen flex items-center justify-center bg-gradient-to-br from-indigo-50 via-white to-purple-50 py-12 px-4 sm:px-6 lg:px-8">
        <div class="max-w-2xl w-full">
            <!-- Header -->
            <div class="text-center mb-8">
                <h1 class="text-4xl font-bold text-gray-900 mb-2">
                    Student Registration
                </h1>
                <p class="text-lg text-gray-600">
                    Create your account to access the EPOE System
                </p>
            </div>

            <!-- Registration Form -->
            <div class="bg-white rounded-xl shadow-lg p-8">
                <!-- Student Registration Notice -->
                <div class="mb-6 p-4 bg-green-50 border border-green-200 rounded-lg">
                    <div class="flex items-center mb-2">
                        <svg class="w-5 h-5 text-green-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <h3 class="text-sm font-semibold text-green-900">Student Registration Only</h3>
                    </div>
                    <p class="text-xs text-green-700">
                        This registration form is for <strong>Students only</strong>. If you are an Admin, HOD, Trainer, Exams Office staff, or Validator, please contact your administrator to create your account.
                    </p>
                </div>

                <form method="POST" action="{{ route('register') }}">
                    @csrf

                    <!-- First Name and Last Name in a row -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- First Name -->
                        <div>
                            <x-input-label for="first_name" :value="__('First Name')" />
                            <x-text-input id="first_name" 
                                         class="block mt-1 w-full" 
                                         type="text" 
                                         name="first_name" 
                                         :value="old('first_name')" 
                                         required 
                                         autofocus 
                                         autocomplete="given-name" 
                                         placeholder="Enter your first name" />
                            <x-input-error :messages="$errors->get('first_name')" class="mt-2" />
                        </div>

                        <!-- Last Name -->
                        <div>
                            <x-input-label for="last_name" :value="__('Last Name')" />
                            <x-text-input id="last_name" 
                                         class="block mt-1 w-full" 
                                         type="text" 
                                         name="last_name" 
                                         :value="old('last_name')" 
                                         required 
                                         autocomplete="family-name" 
                                         placeholder="Enter your last name" />
                            <x-input-error :messages="$errors->get('last_name')" class="mt-2" />
                        </div>
                    </div>

                    <!-- Admission Number -->
                    <div class="mt-4">
                        <x-input-label for="admission_number" :value="__('Admission Number')" />
                        <x-text-input id="admission_number" 
                                     class="block mt-1 w-full" 
                                     type="text" 
                                     name="admission_number" 
                                     :value="old('admission_number')" 
                                     required 
                                     autocomplete="off" 
                                     placeholder="Enter your admission number" />
                        <x-input-error :messages="$errors->get('admission_number')" class="mt-2" />
                        <p class="mt-1 text-xs text-gray-500">Your unique admission/registration number</p>
                    </div>

                    <!-- Department Selection -->
                    <div class="mt-4">
                        <x-input-label for="department_id" :value="__('Department')" />
                        <select id="department_id" 
                                name="department_id" 
                                class="block mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                                required>
                            <option value="">Select your department</option>
                            @foreach($departments as $department)
                                <option value="{{ $department->id }}" {{ old('department_id') == $department->id ? 'selected' : '' }}>
                                    {{ $department->name }}
                                    @if($department->code)
                                        ({{ $department->code }})
                                    @endif
                                </option>
                            @endforeach
                        </select>
                        <x-input-error :messages="$errors->get('department_id')" class="mt-2" />
                    </div>

                    <!-- Class Selection (filtered by department) -->
                    <div class="mt-4">
                        <x-input-label for="class_id" :value="__('Class')" />
                        <select id="class_id" 
                                name="class_id" 
                                class="block mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 disabled:bg-gray-100 disabled:cursor-not-allowed"
                                disabled
                                required>
                            <option value="">Select your class</option>
                            @foreach($classes as $class)
                                <option value="{{ $class->id }}" 
                                        data-department-id="{{ $class->department_id }}"
                                        {{ old('class_id') == $class->id ? 'selected' : '' }}>
                                    {{ $class->name }}
                                    @if($class->level)
                                        ({{ $class->level->name }})
                                    @endif
                                </option>
                            @endforeach
                        </select>
                        <x-input-error :messages="$errors->get('class_id')" class="mt-2" />
                        <p class="mt-1 text-xs text-gray-500" id="class-help-text">
                            Please select a department first to see available classes
                        </p>
                        <p class="mt-1 text-xs text-green-600 hidden" id="class-count-text"></p>
                        <p class="mt-1 text-xs text-red-600 hidden" id="class-empty-text">
                            No classes available for this department. Please contact your administrator.
                        </p>
                    </div>

                    <!-- Email Address -->
                    <div class="mt-4">
                        <x-input-label for="email" :value="__('Email Address')" />
                        <x-text-input id="email" 
                                     class="block mt-1 w-full" 
                                     type="email" 
                                     name="email" 
                                     :value="old('email')" 
                                     required 
                                     autocomplete="username" 
                                     placeholder="Enter your email address" />
                        <x-input-error :messages="$errors->get('email')" class="mt-2" />
                    </div>

                    <!-- Password -->
                    <div class="mt-4">
                        <x-input-label for="password" :value="__('Password')" />
                        <x-text-input id="password" 
                                     class="block mt-1 w-full"
                                     type="password"
                                     name="password"
                                     required 
                                     autocomplete="new-password" 
                                     placeholder="Enter your password" />
                        <x-input-error :messages="$errors->get('password')" class="mt-2" />
                    </div>

                    <!-- Confirm Password -->
                    <div class="mt-4">
                        <x-input-label for="password_confirmation" :value="__('Confirm Password')" />
                        <x-text-input id="password_confirmation" 
                                     class="block mt-1 w-full"
                                     type="password"
                                     name="password_confirmation" 
                                     required 
                                     autocomplete="new-password" 
                                     placeholder="Confirm your password" />
                        <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2" />
                    </div>

                    <!-- Hidden Role Field -->
                    <input type="hidden" name="role" value="student">

                    <!-- Submit Button -->
                    <div class="flex items-center justify-between mt-6">
                        <a class="underline text-sm text-gray-600 hover:text-gray-900 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500" 
                           href="{{ route('login') }}">
                            {{ __('Already registered?') }}
                        </a>

                        <x-primary-button>
                            {{ __('Register') }}
                        </x-primary-button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const departmentSelect = document.getElementById('department_id');
            const classSelect = document.getElementById('class_id');
            const classHelpText = document.getElementById('class-help-text');
            const classCountText = document.getElementById('class-count-text');
            const classEmptyText = document.getElementById('class-empty-text');
            const allClassOptions = Array.from(classSelect.querySelectorAll('option[data-department-id]'));
            const oldClassId = '{{ old('class_id', '') }}';

            // Set initial state if department is pre-selected
            if (departmentSelect.value) {
                filterClasses();
            }

            departmentSelect.addEventListener('change', function() {
                filterClasses();
            });

            function filterClasses() {
                const selectedDepartmentId = departmentSelect.value;
                
                // Clear current selection
                classSelect.value = '';
                
                // Hide all help texts
                classHelpText.classList.add('hidden');
                classCountText.classList.add('hidden');
                classEmptyText.classList.add('hidden');

                if (!selectedDepartmentId) {
                    // No department selected
                    classSelect.disabled = true;
                    classHelpText.classList.remove('hidden');
                    return;
                }

                // Filter classes by department
                let visibleCount = 0;
                allClassOptions.forEach(option => {
                    const optionDepartmentId = option.getAttribute('data-department-id');
                    if (optionDepartmentId === selectedDepartmentId) {
                        option.style.display = '';
                        visibleCount++;
                    } else {
                        option.style.display = 'none';
                    }
                });

                // Enable select and show appropriate message
                classSelect.disabled = false;

                if (visibleCount === 0) {
                    classEmptyText.classList.remove('hidden');
                } else {
                    classCountText.textContent = visibleCount + ' class(es) available';
                    classCountText.classList.remove('hidden');
                    
                    // Restore old selection if it matches the department
                    if (oldClassId) {
                        const oldOption = allClassOptions.find(opt => opt.value === oldClassId && opt.getAttribute('data-department-id') === selectedDepartmentId);
                        if (oldOption) {
                            classSelect.value = oldClassId;
                        }
                    }
                }
            }
        });
    </script>
</x-guest-layout>
