@extends('layouts.hod')

@section('title', 'Class Details')
@section('page-title', 'Class Details')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-900 mb-2">{{ $class->name }}</h1>
                <p class="text-gray-600">Code: {{ $class->code }}</p>
            </div>
            <div class="flex items-center gap-3">
                <a href="{{ route('hod.marks.print-class', $class) }}" target="_blank" class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 transition-colors font-medium inline-flex items-center">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
                    </svg>
                    Print Consolidated Marks
                </a>
                <a href="{{ route('hod.classes.edit', $class) }}" class="bg-purple-600 text-white px-4 py-2 rounded-lg hover:bg-purple-700 transition-colors font-medium">
                    Edit Class
                </a>
                <a href="{{ route('hod.classes.index') }}" class="text-purple-600 hover:text-purple-800 font-medium">
                    ← Back to Classes
                </a>
            </div>
        </div>
    </div>

    <!-- Stats -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
        <div class="bg-white rounded-xl shadow-md p-6">
            <p class="text-sm font-medium text-gray-600">Term</p>
            <p class="text-lg font-bold text-gray-900 mt-1">{{ $class->term->name ?? 'N/A' }}</p>
        </div>
        <div class="bg-white rounded-xl shadow-md p-6">
            <p class="text-sm font-medium text-gray-600">Level</p>
            <p class="text-lg font-bold text-gray-900 mt-1">{{ $class->level->name ?? 'N/A' }}</p>
        </div>
        <div class="bg-white rounded-xl shadow-md p-6">
            <p class="text-sm font-medium text-gray-600">Total Students</p>
            <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_students'] }}</p>
        </div>
        <div class="bg-white rounded-xl shadow-md p-6">
            <p class="text-sm font-medium text-gray-600">Assigned Units</p>
            <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_units'] }}</p>
        </div>
    </div>

    <!-- Assign Units to Class -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <h3 class="text-lg font-semibold text-gray-900 mb-4">Assign Units to Class</h3>
        <form action="{{ route('hod.classes.assign-unit', $class) }}" method="POST" class="flex items-end gap-4">
            @csrf
            <div class="flex-1">
                <label for="unit_id" class="block text-sm font-medium text-gray-700 mb-1">Select Unit</label>
                <select name="unit_id" id="unit_id" required
                        class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                    <option value="">Select a Unit</option>
                    @foreach($availableUnits as $unit)
                        <option value="{{ $unit->id }}">{{ $unit->name }} ({{ $unit->code }})</option>
                    @endforeach
                </select>
                @if($availableUnits->count() == 0)
                    <p class="mt-1 text-xs text-gray-500">All available units are already assigned</p>
                @endif
            </div>
            <button type="submit" 
                    class="px-4 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700 transition-colors font-medium {{ $availableUnits->count() == 0 ? 'opacity-50 cursor-not-allowed' : '' }}"
                    {{ $availableUnits->count() == 0 ? 'disabled' : '' }}>
                Assign Unit
            </button>
        </form>
    </div>

    <!-- Assigned Units -->
    @if($class->units->count() > 0)
        <div class="bg-white rounded-xl shadow-md p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Assigned Units ({{ $stats['total_units'] }})</h3>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Unit Name</th>
                            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Code</th>
                            <th class="px-4 py-3 text-right text-xs font-semibold text-gray-600 uppercase">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($class->units as $unit)
                            <tr>
                                <td class="px-4 py-3 text-sm text-gray-900">{{ $unit->name }}</td>
                                <td class="px-4 py-3 text-sm text-gray-600">{{ $unit->code }}</td>
                                <td class="px-4 py-3 text-right text-sm font-medium">
                                    <form action="{{ route('hod.classes.remove-unit', $class) }}" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to remove this unit from the class?');">
                                        @csrf
                                        @method('DELETE')
                                        <input type="hidden" name="unit_id" value="{{ $unit->id }}">
                                        <button type="submit" class="text-red-600 hover:text-red-900">Remove</button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @endif
</div>
@endsection

