@extends('layouts.hod')

@section('title', 'Marks Management')
@section('page-title', 'Marks Management')

@section('content')
@php
    $validationErrorMessage = session('validation_push_error');
    $validationErrorsList = session('validation_errors', []);
    $showValidationErrorDialog = !empty($validationErrorMessage) || !empty($validationErrorsList);
@endphp

{{-- Error dialog when push to validation fails (unit config / readiness) --}}
@if($showValidationErrorDialog)
<div class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true"
     x-data="{ open: true }"
     x-show="open"
     x-cloak
     x-transition:enter="ease-out duration-300"
     x-transition:enter-start="opacity-0"
     x-transition:enter-end="opacity-100"
     x-transition:leave="ease-in duration-200"
     x-transition:leave-start="opacity-100"
     x-transition:leave-end="opacity-0">
    <div class="flex min-h-screen items-center justify-center p-4 pointer-events-none">
        <div class="relative bg-white rounded-lg shadow-xl max-w-md w-full p-6 pointer-events-auto"
             x-show="open"
             x-transition:enter="ease-out duration-300"
             x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
             x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
             @click.away="open = false">
            <div class="flex items-start gap-3">
                <div class="shrink-0 w-10 h-10 rounded-full bg-red-100 flex items-center justify-center">
                    <svg class="w-5 h-5 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                    </svg>
                </div>
                <div class="flex-1 min-w-0">
                    <h3 class="text-lg font-semibold text-gray-900" id="modal-title">Cannot push to validation</h3>
                    <p class="mt-2 text-sm text-gray-600">{{ $validationErrorMessage ?? 'The unit does not meet the requirements for validation.' }}</p>
                    @if(!empty($validationErrorsList))
                        <ul class="mt-3 list-disc list-inside text-sm text-red-700 space-y-1">
                            @foreach($validationErrorsList as $err)
                                <li>{{ is_string($err) ? $err : json_encode($err) }}</li>
                            @endforeach
                        </ul>
                    @endif
                    <p class="mt-3 text-xs text-gray-500">Ensure the unit is configured and all required assessments are completed with marks for all students.</p>
                </div>
            </div>
            <div class="mt-6 flex justify-end">
                <button type="button" @click="open = false" class="inline-flex justify-center rounded-md border border-gray-300 bg-white px-4 py-2 text-sm font-medium text-gray-700 shadow-sm hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:ring-offset-2">
                    Close
                </button>
            </div>
        </div>
    </div>
</div>
@endif

<div class="space-y-6">
    <!-- Header + Active Term -->
    <div class="bg-white rounded-xl shadow-md px-6 py-4 flex flex-col md:flex-row md:items-center md:justify-between gap-2">
        <div>
            <div class="flex items-center gap-3">
                <h1 class="text-xl md:text-2xl font-bold text-gray-900">Marks Management</h1>
                @if($activeTerm)
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-blue-50 text-blue-700 border border-blue-100">
                        <span class="w-1.5 h-1.5 rounded-full bg-blue-500 mr-2"></span>
                        Active Term: {{ $activeTerm->name }}
                    </span>
                @endif
            </div>
            <p class="mt-1 text-sm text-gray-600">View and monitor marks for department units</p>
        </div>
    </div>

    <!-- Statistics -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-3">
        <div class="bg-white rounded-lg shadow p-4 flex items-center gap-3 h-full">
            <div class="shrink-0 w-9 h-9 rounded-full bg-blue-50 flex items-center justify-center text-blue-500">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 19.5A2.5 2.5 0 016.5 17H20" />
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4.5h16V15H4z" />
                </svg>
            </div>
            <div>
                <p class="text-xs font-medium text-gray-500 uppercase tracking-wide">Total Units</p>
                <p class="text-2xl md:text-3xl font-bold text-gray-900">{{ $stats['total_units'] ?? 0 }}</p>
            </div>
        </div>
        <div class="bg-white rounded-lg shadow p-4 flex items-center gap-3 h-full">
            <div class="shrink-0 w-9 h-9 rounded-full bg-purple-50 flex items-center justify-center text-purple-500">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h8m-8 6h4" />
                </svg>
            </div>
            <div>
                <p class="text-xs font-medium text-gray-500 uppercase tracking-wide">Average Marks</p>
                <p class="text-2xl md:text-3xl font-bold text-purple-600">{{ number_format($stats['average_marks'] ?? 0, 2) }}</p>
            </div>
        </div>
        <div class="bg-white rounded-lg shadow p-4 flex items-center gap-3 h-full">
            <div class="shrink-0 w-9 h-9 rounded-full bg-green-50 flex items-center justify-center text-green-500">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l4-4 4 4m0 8V6" />
                </svg>
            </div>
            <div>
                <p class="text-xs font-medium text-gray-500 uppercase tracking-wide">Highest Marks</p>
                <p class="text-2xl md:text-3xl font-bold text-green-600">{{ $stats['highest_marks'] ?? 0 }}</p>
            </div>
        </div>
        <div class="bg-white rounded-lg shadow p-4 flex items-center gap-3 h-full">
            <div class="shrink-0 w-9 h-9 rounded-full bg-red-50 flex items-center justify-center text-red-500">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 14l-4 4-4-4m0-8v12" />
                </svg>
            </div>
            <div>
                <p class="text-xs font-medium text-gray-500 uppercase tracking-wide">Lowest Marks</p>
                <p class="text-2xl md:text-3xl font-bold text-red-600">{{ $stats['lowest_marks'] ?? 0 }}</p>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-xl shadow-md px-6 py-4">
        <form method="GET" class="flex flex-col md:flex-row md:items-end gap-4">
            <div class="flex-1">
                <label class="block text-sm font-medium text-gray-700 mb-1">Search</label>
                <input type="text" name="search" value="{{ request('search') }}" placeholder="Unit name or code" 
                       class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500 h-10">
            </div>
            <div class="w-full md:w-64">
                <label class="block text-sm font-medium text-gray-700 mb-1">Unit</label>
                <select name="unit" class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500 h-10">
                    <option value="">All Units</option>
                    @foreach($filterOptions['units'] as $unit)
                        <option value="{{ $unit->id }}" {{ request('unit') == $unit->id ? 'selected' : '' }}>{{ $unit->name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="flex w-full md:w-auto gap-2">
                <button type="submit" class="flex-1 md:flex-none bg-purple-600 text-white px-5 h-10 rounded-lg hover:bg-purple-700 transition-colors font-medium">
                    Filter
                </button>
                @if(request('search') || request('unit'))
                    <a href="{{ route('hod.marks.index') }}" class="flex-1 md:flex-none bg-gray-100 text-gray-700 px-4 h-10 rounded-lg hover:bg-gray-200 transition-colors font-medium flex items-center justify-center">
                        Clear
                    </a>
                @endif
            </div>
        </form>
    </div>

    <!-- Consolidated Class Marks Section -->
    @if(isset($filterOptions['classes']) && $filterOptions['classes']->count() > 0)
    <div class="bg-white rounded-xl shadow-md overflow-hidden">
        <div class="px-6 py-3 bg-gray-50 border-b border-gray-200 flex items-center justify-between">
            <div>
                <h2 class="text-lg font-semibold text-gray-900">Consolidated Class Marks</h2>
                <p class="text-xs text-gray-500">Print consolidated marks for all units in a class</p>
            </div>
        </div>

        <div class="px-6 py-4">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">
                @foreach($filterOptions['classes'] as $class)
                    <div class="bg-white border border-gray-200 rounded-lg px-4 py-3 flex items-center justify-between hover:border-blue-400 hover:shadow-sm transition-all">
                        <div>
                            <h3 class="text-sm font-semibold text-gray-900">{{ $class->name }}</h3>
                            <p class="text-xs text-gray-500">Code: {{ $class->code ?? 'N/A' }}</p>
                        </div>
                        <a href="{{ route('hod.marks.print-class', $class) }}" target="_blank" class="inline-flex items-center border border-blue-500 text-blue-600 px-3 py-1.5 rounded-md text-xs font-medium hover:bg-blue-50 transition-colors">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
                            </svg>
                            Print Marks
                        </a>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    @endif

    <!-- Units List -->
    <div class="bg-white rounded-xl shadow-md overflow-hidden">
        <div class="px-6 py-4 bg-gray-50 border-b border-gray-200">
            <h2 class="text-lg font-semibold text-gray-900">Department Units</h2>
            <p class="text-sm text-gray-600">{{ $units->count() }} unit(s) found</p>
        </div>

        @if($units->count() > 0)
            <div class="p-6">
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    @foreach($units as $unit)
                        <div class="bg-white border border-gray-200 rounded-lg p-5 hover:border-purple-500 hover:shadow-md transition-all flex flex-col h-full">
                            <div class="flex items-start justify-between mb-2">
                                <div class="flex-1">
                                    <h3 class="text-base font-semibold text-gray-900 mb-0.5">{{ $unit->name }}</h3>
                                    <p class="text-xs text-gray-500">{{ $unit->code }}</p>
                                </div>
                                @if($unit->classification)
                                    <span class="ml-2 px-2 py-0.5 text-[10px] font-medium rounded-full border 
                                        @if($unit->classification === 'core_unit') bg-purple-50 text-purple-700 border-purple-100
                                        @elseif($unit->classification === 'basic_unit') bg-blue-50 text-blue-700 border-blue-100
                                        @else bg-gray-50 text-gray-700 border-gray-200
                                        @endif">
                                        {{ ucfirst(str_replace('_', ' ', $unit->classification)) }}
                                    </span>
                                @endif
                            </div>

                            @if($unit->department)
                                <p class="text-[11px] text-gray-400 mb-2">{{ $unit->department->name }}</p>
                            @endif

                            <div class="mb-3">
                                <div class="grid grid-cols-2 gap-x-4 gap-y-1 text-xs">
                                    <div class="flex items-center justify-between">
                                        <span class="text-gray-500">Assignments</span>
                                        <span class="font-semibold text-gray-900">{{ $unit->assignments_count ?? 0 }}</span>
                                    </div>
                                    <div class="flex items-center justify-between">
                                        <span class="text-gray-500">Students</span>
                                        <span class="font-semibold text-gray-900">{{ $unit->students_count ?? 0 }}</span>
                                    </div>
                                    @if($unit->total_marks_count > 0)
                                        <div class="flex items-center justify-between">
                                            <span class="text-gray-500">Average</span>
                                            <span class="font-semibold text-purple-600">{{ number_format($unit->average_marks, 2) }}</span>
                                        </div>
                                        <div class="flex items-center justify-between">
                                            <span class="text-gray-500">Highest</span>
                                            <span class="font-semibold text-green-600">{{ number_format($unit->highest_marks, 2) }}</span>
                                        </div>
                                        <div class="flex items-center justify-between">
                                            <span class="text-gray-500">Lowest</span>
                                            <span class="font-semibold text-red-600">{{ number_format($unit->lowest_marks, 2) }}</span>
                                        </div>
                                    @else
                                        <div class="col-span-2 text-[11px] text-gray-400 italic mt-1">No marks recorded yet</div>
                                    @endif
                                </div>
                            </div>

                            @if($unit->isConfigured())
                                <div class="mt-auto pt-3 border-t border-gray-100">
                                    <p class="text-[11px] font-medium text-gray-700 mb-1">Assessment Structure</p>
                                    @php
                                        $structure = $unit->getAssessmentStructure();
                                    @endphp
                                    <div class="flex flex-wrap gap-2">
                                        @if($structure['theory'] > 0)
                                            <span class="text-xs px-2 py-1 bg-blue-100 text-blue-800 rounded">Theory: {{ $structure['theory'] }}</span>
                                        @endif
                                        @if($structure['practical'] > 0)
                                            <span class="text-xs px-2 py-1 bg-purple-100 text-purple-800 rounded">Practical: {{ $structure['practical'] }}</span>
                                        @endif
                                        @if($structure['oral'] > 0)
                                            <span class="text-xs px-2 py-1 bg-green-100 text-green-800 rounded">Oral: {{ $structure['oral'] }}</span>
                                        @endif
                                        @if($structure['project'] > 0)
                                            <span class="text-xs px-2 py-1 bg-yellow-100 text-yellow-800 rounded">Project: {{ $structure['project'] }}</span>
                                        @endif
                                    </div>
                                </div>
                            @else
                                <div class="mt-3 pt-3 border-t border-gray-200">
                                    <p class="text-xs text-yellow-600">⚠ Not configured</p>
                                </div>
                            @endif

                            {{-- Push to validation / Cancel request (per class) --}}
                            @if(isset($unit->validation_contexts) && $unit->validation_contexts->isNotEmpty())
                                <div class="mt-3 pt-3 border-t border-gray-100">
                                    <p class="text-[11px] font-medium text-gray-700 mb-2">Validation portal</p>
                                    <ul class="space-y-2">
                                        @foreach($unit->validation_contexts as $ctx)
                                            @php
                                                $schoolClass = $ctx['class'];
                                                $vr = $ctx['validation_request'];
                                            @endphp
                                            <li class="flex items-center justify-between gap-2 text-xs">
                                                <span class="text-gray-600 truncate" title="{{ $schoolClass->name }}">{{ $schoolClass->name }} ({{ $schoolClass->code ?? '—' }})</span>
                                                @if($vr)
                                                    <span class="shrink-0 inline-flex items-center gap-1">
                                                        <span class="px-1.5 py-0.5 rounded bg-amber-100 text-amber-800 text-[10px] font-medium">Pending</span>
                                                        <form method="POST" action="{{ route('hod.marks.validation-requests.cancel', $vr) }}" class="inline" onsubmit="return confirm('Cancel this validation request? The unit will be removed from the validation portal.');">
                                                            @csrf
                                                            <button type="submit" class="text-red-600 hover:text-red-800 font-medium">Cancel</button>
                                                        </form>
                                                    </span>
                                                @else
                                                    <form method="POST" action="{{ route('hod.marks.push-to-validation', ['class' => $schoolClass, 'unit' => $unit]) }}" class="inline">
                                                        @csrf
                                                        <button type="submit" class="text-purple-600 hover:text-purple-800 font-medium whitespace-nowrap">Push to validation</button>
                                                    </form>
                                                @endif
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif

                            <div class="mt-4 flex items-center justify-between">
                                <a href="{{ route('hod.units.show', $unit) }}" class="text-purple-600 hover:text-purple-900 text-sm font-medium">
                                    View Unit
                                </a>
                                <a href="{{ route('hod.marks.print-unit', $unit) }}" target="_blank" class="text-green-600 hover:text-green-900 text-sm font-medium flex items-center">
                                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
                                    </svg>
                                    Print Marks
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @else
            <div class="p-12 text-center">
                <p class="text-gray-600">No units found in your department.</p>
            </div>
        @endif
    </div>
</div>
@endsection

