<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Unit Marks Summary Report - {{ $unit->name }}</title>
    <style>
        @media print {
            .no-print { display: none; }
            button { display: none; }
            body { margin: 10mm; padding: 0; }
            .page-break { page-break-after: always; }
            @page {
                size: A4;
                margin: 15mm;
            }
        }
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Times New Roman', serif;
            font-size: 11pt;
            line-height: 1.4;
            color: #000;
            background: #fff;
            padding: 20px;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        .letterhead {
           
        }
        .letterhead-content {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 4px;
        }
        .logo-section {
            flex-shrink: 0;
        }
        .logo-section img {
            max-height: 80px;
            max-width: 120px;
            object-fit: contain;
        }
        .institution-info {
            width: 100%;
            text-align: center;
        }
        .institution-name {
            font-size: 18pt;
            font-weight: bold;
            text-transform: uppercase;
            margin-bottom: 2px;
            letter-spacing: 1px;
            text-align: center;
        }
        .department-name {
            font-size: 12pt;
            font-weight: bold;
            margin: 0 0 4px 0;
            text-transform: uppercase;
            text-align: center;
        }
        .institution-details {
            font-size: 8pt;
            color: #333;
            line-height: 1.4;
            text-align: center;
        }
        .report-title {
            text-align: center;
            font-size: 16pt;
            font-weight: bold;
            text-transform: uppercase;
            margin: 10px 0 8px;
            letter-spacing: 1px;
        }
        .metadata-section {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px 24px;
            margin-bottom: 12px;
            font-size: 9pt;
        }
        .metadata-column {
            padding: 0;
        }
        .metadata-item {
            display: flex;
            margin-bottom: 2px;
            line-height: 1.3;
        }
        .metadata-label {
            font-weight: bold;
            min-width: 120px;
            flex-shrink: 0;
            text-transform: uppercase;
            font-size: 8pt;
        }
        .metadata-value {
            flex: 1;
            font-size: 9pt;
        }
        .section-title {
            font-weight: bold;
            text-transform: uppercase;
            margin: 0 0 3px 0;
            padding: 0;
            font-size: 9pt;
        }
        table {
            width: 70%;
            border-collapse: collapse;
            margin: 10px auto;
            font-size: 9pt;
            page-break-inside: auto;
            border: 2px solid #000;
        }
        th, td {
            padding: 8px 6px;
            text-align: center;
            vertical-align: middle;
            border: 1px solid #000;
        }
        td.number {
            text-align: center;
        }
        th {
            background-color: #f5f5f5;
            font-weight: bold;
            font-size: 8pt;
            text-transform: uppercase;
            border: 1px solid #000;
        }
        tbody td {
            border: 1px solid #000;
        }
        .group-header {
            background-color: #c0c0c0 !important;
            font-weight: bold;
            font-size: 9pt;
        }
        .student-name-col {
            text-align: left;
            padding-left: 8px;
            min-width: 150px;
        }
        .admission-col {
            text-align: center;
            min-width: 100px;
        }
        .marks-col {
            text-align: center;
            min-width: 60px;
        }
        .category-average {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        .total-col {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        tbody tr {
            page-break-inside: avoid;
        }
        tbody tr:nth-child(even) {
            background-color: #f7f7f7;
        }
        tbody tr {
            min-height: 35px;
        }
        .signature-row {
            display: flex;
            justify-content: space-between;
            gap: 40px;
            margin-top: auto;
            padding-top: 40px;
        }
        .content-wrapper {
            flex: 1;
            display: flex;
            flex-direction: column;
        }
        .signature-row div {
            width: 45%;
            font-size: 10pt;
        }
        .signature-row b {
            text-transform: uppercase;
        }
        .signature-row .signature-meta {
            margin-top: 8px;
        }
        .signature-row .signature-line-text {
            margin-top: 16px;
            font-size: 9pt;
        }
        .footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #000;
            text-align: center;
            font-size: 9px;
            color: #666;
        }
        .footer-warning {
            font-weight: bold;
            color: #000;
            margin-bottom: 5px;
            font-size: 9px;
        }
    </style>
</head>
<body>
    <div class="no-print" style="margin-bottom: 20px; text-align: right;">
        <button onclick="window.print()" style="padding: 10px 20px; background: #3b82f6; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 14px;">
            Print
        </button>
        <button onclick="window.close()" style="padding: 10px 20px; background: #6b7280; color: white; border: none; border-radius: 5px; cursor: pointer; margin-left: 10px; font-size: 14px;">
            Close
        </button>
    </div>

    <div class="content-wrapper">
        <!-- Letterhead -->
        <div class="letterhead">
            <div class="letterhead-content">
                @if(isset($institutionSettings['institution.logo']) && $institutionSettings['institution.logo'])
                    <div class="logo-section">
                        <img src="{{ asset('storage/' . $institutionSettings['institution.logo']) }}" alt="Institution Logo">
                    </div>
                @endif
                <div class="institution-info">
                    <div class="institution-name">
                        {{ $institutionSettings['institution.name'] ?? config('app.name', 'Technical and Vocational Education Training Institution') }}
                    </div>
                    <div class="department-name">
                        Department of {{ $unit->department->name ?? 'Computing' }}
                    </div>
                    @if(isset($institutionSettings['institution.address']) && $institutionSettings['institution.address'])
                        <div class="institution-details">
                            {{ $institutionSettings['institution.address'] }}
                            @if(isset($institutionSettings['institution.phone']) && $institutionSettings['institution.phone'])
                                | Tel: {{ $institutionSettings['institution.phone'] }}
                            @endif
                            @if(isset($institutionSettings['institution.email']) && $institutionSettings['institution.email'])
                                | Email: {{ $institutionSettings['institution.email'] }}
                            @endif
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">
            UNIT MARKS SUMMARY REPORT
        </div>

        <!-- Metadata: compact, no extra borders -->
        <div class="metadata-section">
            <div class="metadata-column">
                <div class="section-title">Unit Information</div>
                <div class="metadata-item"><span class="metadata-label">Department:</span><span class="metadata-value">{{ $unit->department->name ?? 'N/A' }}</span></div>
                <div class="metadata-item"><span class="metadata-label">Unit Name:</span><span class="metadata-value">{{ $unit->name }}</span></div>
                <div class="metadata-item"><span class="metadata-label">Unit Code:</span><span class="metadata-value">{{ $unit->code ?? 'N/A' }}</span></div>
            </div>
            <div class="metadata-column">
                <div class="section-title">Report Information</div>
                <div class="metadata-item"><span class="metadata-label">Academic Term:</span><span class="metadata-value">{{ $activeTerm->name ?? 'N/A' }}</span></div>
                <div class="metadata-item"><span class="metadata-label">Total Students:</span><span class="metadata-value">{{ $students->count() }}</span></div>
                <div class="metadata-item"><span class="metadata-label">Total Assessments:</span><span class="metadata-value">{{ count($assignments) }}</span></div>
                <div class="metadata-item"><span class="metadata-label">Report Date:</span><span class="metadata-value">{{ now()->format('d M Y, h:i A') }}</span></div>
            </div>
        </div>

        @if(count($assignments) > 0 && $students->count() > 0)
        @php
            $practicals = $groupedAssignments['practical'] ?? [];
            $orals = $groupedAssignments['oral'] ?? [];
            $testCount = max(count($practicals), count($orals));
        @endphp

        @if($testCount > 0)
        <table class="marks-table">
            <thead>
                <tr>
                    <th rowspan="2" style="width: 30px;">#</th>
                    <th rowspan="2" class="student-name-col">NAME</th>
                    <th rowspan="2" class="admission-col">ADMIN</th>
                    @for($i = 1; $i <= $testCount; $i++)
                        <th colspan="2" class="group-header">PRACTICAL {{ $i }}</th>
                    @endfor
                    <th colspan="2" class="group-header">AVERAGE</th>
                </tr>
                <tr>
                    @for($i = 1; $i <= $testCount; $i++)
                        <th class="marks-col">P{{ $i }}</th>
                        <th class="marks-col">O{{ $i }}</th>
                    @endfor
                    <th class="marks-col">Pav</th>
                    <th class="marks-col">Oav</th>
                </tr>
            </thead>
            <tbody>
                @foreach($students as $index => $student)
                    @php
                        $pValues = [];
                        $oValues = [];
                    @endphp
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td class="student-name-col">{{ $student->name }}</td>
                        <td class="admission-col">{{ $student->admission_number ?? '' }}</td>

                        @for($i = 1; $i <= $testCount; $i++)
                            @php
                                $pMark = null;
                                $pDisplay = '—';
                                if(isset($practicals[$i-1])) {
                                    $a = $practicals[$i-1];
                                    $data = $marksData[$student->id][$a->id] ?? null;
                                    $status = $data['status'] ?? 'not_marked';
                                    $percent = $data['percentage'] ?? null;
                                    if ($status === 'absent') {
                                        $pDisplay = 'AB';
                                        $pMark = 0;
                                    } elseif ($percent !== null) {
                                        $pDisplay = number_format($percent, 0);
                                        $pMark = $percent;
                                    }
                                }
                                $pValues[] = $pMark;
                            @endphp
                            <td class="marks-col">{{ $pDisplay }}</td>

                            @php
                                $oMark = null;
                                $oDisplay = '—';
                                if(isset($orals[$i-1])) {
                                    $a = $orals[$i-1];
                                    $data = $marksData[$student->id][$a->id] ?? null;
                                    $status = $data['status'] ?? 'not_marked';
                                    $percent = $data['percentage'] ?? null;
                                    if ($status === 'absent') {
                                        $oDisplay = 'AB';
                                        $oMark = 0;
                                    } elseif ($percent !== null) {
                                        $oDisplay = number_format($percent, 0);
                                        $oMark = $percent;
                                    }
                                }
                                $oValues[] = $oMark;
                            @endphp
                            <td class="marks-col">{{ $oDisplay }}</td>
                        @endfor

                        @php
                            $pAvg = $categoryAverages[$student->id]['practical']['average_percentage'] ?? null;
                            $oAvg = $categoryAverages[$student->id]['oral']['average_percentage'] ?? null;
                        @endphp
                        <td class="marks-col">
                            @if($pAvg !== null)
                                {{ number_format($pAvg, 0) }}
                            @else
                                —
                            @endif
                        </td>
                        <td class="marks-col">
                            @if($oAvg !== null)
                                {{ number_format($oAvg, 0) }}
                            @else
                                —
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
        @else
            <div style="text-align: center; padding: 40px; color: #666;">
                <p>No practical/oral assessments found for this unit.</p>
            </div>
        @endif
        @else
            <div style="text-align: center; padding: 40px; color: #666;">
                <p>No data available for this unit.</p>
            </div>
        @endif
    </div>

    <!-- Signatures -->
    <div class="signature-row">
        <div>
            <b>Trainer / Assessor</b>
            <div class="signature-meta">
                Name: _____________________
            </div>
            <div class="signature-line-text">
                Signature: _____________ &nbsp;&nbsp;&nbsp; Date: _______
            </div>
        </div>
        <div>
            <b>Head of Department / Verifier</b>
            <div class="signature-meta">
                Name: {{ $hod->name ?? '_____________________' }}
            </div>
            <div class="signature-line-text">
                Signature: _____________ &nbsp;&nbsp;&nbsp; Date: _______
            </div>
        </div>
    </div>

    <!-- Footer -->
    <div class="footer">
        <div class="footer-warning">
            SYSTEM GENERATED REPORT – NO ALTERATIONS ALLOWED
        </div>
        <div>
            Generated on {{ now()->format('d M Y, h:i A') }} | {{ $institutionSettings['institution.footer_text'] ?? config('app.name', 'e-PoE System') }}
        </div>
    </div>
</body>
</html>

