@extends('layouts.hod')

@section('title', 'My Units')
@section('page-title', 'My Units')

@section('content')
<div class="mb-6 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
    <div>
        <h1 class="text-2xl font-bold text-gray-900">My Units</h1>
        <p class="mt-1 text-sm text-gray-600">View units allocated to you</p>
    </div>
</div>

@if($activeTerm)
    <div class="mb-6 p-4 bg-purple-50 border border-purple-200 rounded-lg">
        <p class="text-sm text-purple-800"><strong>Active Term:</strong> {{ $activeTerm->name }}</p>
    </div>
@endif

@if($units->count() > 0)
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        @foreach($units as $unit)
            <div class="bg-white rounded-xl shadow-md hover:shadow-xl transition-shadow border-l-4 border-purple-500">
                <div class="p-6">
                    <div class="flex items-start justify-between mb-4">
                        <div class="flex-1">
                            <a href="{{ route('hod.units.show', $unit) }}" class="block">
                                <h3 class="text-lg font-semibold text-gray-900 hover:text-purple-600 transition-colors">{{ $unit->name }}</h3>
                            </a>
                            @if($unit->code)
                                <p class="text-sm text-gray-500 mt-1">{{ $unit->code }}</p>
                            @endif
                            @if($unit->department)
                                <p class="text-xs text-gray-400 mt-1">{{ $unit->department->name }}</p>
                            @endif
                        </div>
                        <a href="{{ route('hod.units.show', $unit) }}" class="text-purple-600 hover:text-purple-800">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                            </svg>
                        </a>
                    </div>
                    
                    <div class="space-y-2 text-sm">
                        <div class="flex items-center text-gray-600">
                            <svg class="w-4 h-4 mr-2 text-purple-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                            </svg>
                            {{ $unit->classes_count ?? 0 }} Classes
                        </div>
                        <div class="flex items-center text-gray-600">
                            <svg class="w-4 h-4 mr-2 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                            </svg>
                            {{ $unit->assignments_count ?? 0 }} Assignments
                        </div>
                        <div class="flex items-center text-gray-600">
                            <svg class="w-4 h-4 mr-2 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                            {{ $unit->submissions_count ?? 0 }} Submissions
                        </div>
                        <div class="flex items-center text-gray-600">
                            <svg class="w-4 h-4 mr-2 text-amber-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                            </svg>
                            {{ $unit->trainers_count ?? 0 }} Trainers
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
@else
    <div class="bg-white rounded-xl shadow-md p-12 text-center">
        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
        </svg>
        <h3 class="mt-2 text-sm font-medium text-gray-900">No units allocated</h3>
        <p class="mt-1 text-sm text-gray-500">You don't have any units allocated to you yet. View <a href="{{ route('hod.units.departmental') }}" class="text-purple-600 hover:text-purple-700 font-medium">Departmental Units</a> to see all units in your department.</p>
    </div>
@endif
@endsection

