@extends('layouts.student')

@section('title', 'My Classes')
@section('page-title', 'My Classes')

@section('content')
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl font-bold text-gray-900">My Classes</h1>
        <p class="mt-1 text-sm text-gray-600">View your enrolled classes and assigned units</p>
    </div>

    @if($activeTerm)
        <div class="mb-4 sm:mb-6 p-4 bg-blue-50 border border-blue-200 rounded-lg">
            <div class="flex items-center">
                <svg class="w-5 h-5 text-blue-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <p class="text-sm text-blue-800">
                    <strong>Active Term:</strong> {{ $activeTerm->name }}
                </p>
            </div>
        </div>
    @else
        <div class="mb-6 p-4 bg-yellow-50 border border-yellow-200 rounded-lg">
            <div class="flex items-center">
                <svg class="w-5 h-5 text-yellow-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                </svg>
                <p class="text-sm text-yellow-800">
                    <strong>No Active Term:</strong> Please contact your administrator.
                </p>
            </div>
        </div>
    @endif

    <!-- Statistics Cards -->
    <div class="grid grid-cols-2 md:grid-cols-4 gap-3 sm:gap-4 mb-4 sm:mb-6">
        <div class="bg-white rounded-lg shadow p-4">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">Total Classes</p>
                <p class="text-2xl font-bold text-gray-900">{{ $stats['total_classes'] }}</p>
            </div>
        </div>
        <div class="bg-white rounded-lg shadow p-4">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">Total Units</p>
                <p class="text-2xl font-bold text-gray-900">{{ $stats['total_units'] }}</p>
            </div>
        </div>
        <div class="bg-white rounded-lg shadow p-4">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">Submitted</p>
                <p class="text-2xl font-bold text-green-600">{{ $stats['submitted_units'] }}</p>
            </div>
        </div>
        <div class="bg-white rounded-lg shadow p-4">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">Pending</p>
                <p class="text-2xl font-bold text-yellow-600">{{ $stats['pending_units'] }}</p>
            </div>
        </div>
    </div>

    <!-- Classes List -->
    @if($enrollments->count() > 0)
        <div class="space-y-6">
            @foreach($enrollments as $enrollment)
                <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                    <!-- Class Header -->
                    <div class="px-4 sm:px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-2">
                            <div class="min-w-0">
                                <h3 class="text-base sm:text-lg font-semibold text-gray-900 break-words">{{ $enrollment->schoolClass->name }}</h3>
                                @if($enrollment->schoolClass->code)
                                    <p class="text-sm text-gray-500">Code: {{ $enrollment->schoolClass->code }}</p>
                                @endif
                            </div>
                            <div class="text-right">
                                <span class="px-3 py-1 text-xs font-semibold rounded-full
                                    @if($enrollment->status == 'active') bg-green-100 text-green-800
                                    @elseif($enrollment->status == 'completed') bg-gray-100 text-gray-800
                                    @else bg-red-100 text-red-800
                                    @endif">
                                    {{ ucfirst($enrollment->status) }}
                                </span>
                                <p class="text-xs text-gray-500 mt-1">
                                    Enrolled: {{ $enrollment->enrolled_at->format('M d, Y') }}
                                </p>
                            </div>
                        </div>
                        <div class="mt-2 flex flex-wrap gap-2">
                            <span class="px-2 py-1 text-xs bg-indigo-100 text-indigo-800 rounded">
                                {{ $enrollment->schoolClass->department->name }}
                            </span>
                            @if($enrollment->schoolClass->level)
                                <span class="px-2 py-1 text-xs bg-purple-100 text-purple-800 rounded">
                                    {{ $enrollment->schoolClass->level->name }}
                                </span>
                            @endif
                            <span class="px-2 py-1 text-xs bg-blue-100 text-blue-800 rounded">
                                {{ $enrollment->schoolClass->term->name }}
                            </span>
                        </div>
                    </div>

                    <!-- Assigned Units -->
                    <div class="px-6 py-4">
                        <h4 class="text-sm font-medium text-gray-700 mb-4">Assigned Units ({{ $enrollment->schoolClass->units->count() }})</h4>
                        
                        @if($enrollment->schoolClass->units->count() > 0)
                            <div class="space-y-3">
                                @foreach($enrollment->schoolClass->units as $unit)
                                    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between p-4 border border-gray-200 rounded-lg hover:bg-gray-50 gap-3">
                                        <div class="flex-1 min-w-0">
                                            <div class="flex items-center gap-3">
                                                <div class="flex-shrink-0">
                                                    <svg class="h-8 w-8 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                                    </svg>
                                                </div>
                                                <div class="flex-1 min-w-0">
                                                    <p class="text-sm font-medium text-gray-900">{{ $unit->name }}</p>
                                                    @if($unit->code)
                                                        <p class="text-xs text-gray-500">Code: {{ $unit->code }}</p>
                                                    @endif
                                                    @if($unit->description)
                                                        <p class="text-xs text-gray-600 mt-1">{{ Str::limit($unit->description, 100) }}</p>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="flex flex-wrap items-center gap-2 sm:ml-4">
                                            @if($unit->submission)
                                                <span class="px-3 py-1 text-xs font-semibold rounded-full {{ $unit->submission->getStatusBadgeClasses() }}">
                                                    {{ $unit->submission->getStatusLabel() }}
                                                </span>
                                                <a href="{{ route('student.submissions.show', $unit->submission) }}" class="inline-flex items-center min-h-[44px] sm:min-h-0 px-3 py-2 text-indigo-600 hover:text-indigo-900 text-sm font-medium touch-manipulation">
                                                    View Submission
                                                </a>
                                            @else
                                                <span class="px-3 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">
                                                    Not Submitted
                                                </span>
                                                <a href="{{ route('student.submissions.create', ['unit' => $unit->id, 'class' => $enrollment->class_id]) }}" class="inline-flex items-center justify-center min-h-[44px] px-3 py-2 text-xs font-medium text-white bg-indigo-600 rounded hover:bg-indigo-700 touch-manipulation">
                                                    Create Submission
                                                </a>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <div class="text-center py-8">
                                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                                <h3 class="mt-2 text-sm font-medium text-gray-900">No units assigned</h3>
                                <p class="mt-1 text-sm text-gray-500">No units have been assigned to this class yet.</p>
                            </div>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>
    @else
        <div class="bg-white rounded-lg shadow-sm p-12 text-center">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path>
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900">No classes enrolled</h3>
            <p class="mt-1 text-sm text-gray-500">You are not enrolled in any classes for the active term.</p>
            <div class="mt-6">
                <p class="text-xs text-gray-500">Please contact your administrator if you believe this is an error.</p>
            </div>
        </div>
    @endif
@endsection

