@extends('layouts.student')

@section('title', 'Student Dashboard')

@section('page-title', 'Dashboard')

@section('content')
<div class="space-y-4 sm:space-y-6">
    <!-- Welcome Section -->
    <div class="bg-gradient-to-r from-green-500 to-green-600 rounded-lg shadow-lg p-4 sm:p-6 text-white">
        <div class="flex items-center justify-between">
            <div class="flex-1 min-w-0">
                <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold mb-2 truncate">Welcome back, {{ auth()->user()->first_name ?? auth()->user()->name }}!</h1>
                <p class="text-sm sm:text-base text-green-100">
                    @if($activeTerm)
                        Current Term: <strong>{{ $activeTerm->name }}</strong>
                    @else
                        No active term is currently set.
                    @endif
                </p>
                @if(auth()->user()->admission_number)
                    <p class="text-sm sm:text-base text-green-100 mt-1">Admission Number: <strong>{{ auth()->user()->admission_number }}</strong></p>
                @endif
                
                <!-- Assessment Mode Badges -->
                @if($assessmentMode['has_written'] || $assessmentMode['has_practical'])
                    <div class="mt-3 flex flex-wrap gap-2">
                        <span class="inline-flex items-center px-2.5 py-1 rounded-full text-xs font-medium bg-white bg-opacity-20 text-white">
                            Assessment Mode:
                        </span>
                        @if($assessmentMode['has_written'])
                            <span class="inline-flex items-center px-2.5 py-1 rounded-full text-xs font-medium bg-white bg-opacity-20 text-white">
                                📝 Written ({{ $assessmentMode['written_count'] }})
                            </span>
                        @endif
                        @if($assessmentMode['has_practical'])
                            <span class="inline-flex items-center px-2.5 py-1 rounded-full text-xs font-medium bg-white bg-opacity-20 text-white">
                                🧪 Practical ({{ $assessmentMode['practical_count'] }})
                            </span>
                        @endif
                    </div>
                @endif
            </div>
            <div class="hidden lg:block flex-shrink-0 ml-4">
                <svg class="h-20 w-20 lg:h-24 lg:w-24 text-green-300 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 14l9-5-9-5-9 5 9 5z"></path>
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 14l6.16-3.422a12.083 12.083 0 01.665 6.479A11.952 11.952 0 0012 20.055a11.952 11.952 0 00-6.824-2.998 12.078 12.078 0 01.665-6.479L12 14z"></path>
                </svg>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-5 gap-4 sm:gap-6">
        <!-- Total Submissions - Clickable -->
        <a href="{{ route('student.submissions.index') }}" 
           class="bg-white rounded-lg shadow-md p-4 sm:p-6 hover:shadow-lg transition-all cursor-pointer group touch-manipulation active:bg-gray-50 block"
           title="View all submissions">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 group-hover:text-green-600">Total Submissions</p>
                    <p class="text-3xl font-bold text-gray-900 mt-2">{{ $stats['total_submissions'] }}</p>
                </div>
                <div class="h-12 w-12 bg-blue-100 rounded-full flex items-center justify-center group-hover:bg-blue-200">
                    <svg class="h-6 w-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
            </div>
        </a>

        <!-- Approved - Clickable -->
        <a href="{{ route('student.submissions.index', ['status' => 'validator_approved']) }}" 
           class="bg-white rounded-lg shadow-md p-4 sm:p-6 hover:shadow-lg transition-all cursor-pointer group"
           title="View approved submissions">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 group-hover:text-green-600">Approved</p>
                    <p class="text-3xl font-bold text-green-600 mt-2">{{ $stats['validator_approved'] }}</p>
                </div>
                <div class="h-12 w-12 bg-green-100 rounded-full flex items-center justify-center group-hover:bg-green-200">
                    <svg class="h-6 w-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
            </div>
        </a>

        <!-- Under Review - Clickable -->
        <a href="{{ route('student.submissions.index', ['status' => 'under_review']) }}" 
           class="bg-white rounded-lg shadow-md p-4 sm:p-6 hover:shadow-lg transition-all cursor-pointer group"
           title="View submissions under review">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 group-hover:text-green-600">Under Review</p>
                    <p class="text-3xl font-bold text-yellow-600 mt-2">{{ $stats['under_review'] + $stats['trainer_reviewed'] + $stats['hod_approved'] + $stats['exams_verified'] }}</p>
                </div>
                <div class="h-12 w-12 bg-yellow-100 rounded-full flex items-center justify-center group-hover:bg-yellow-200">
                    <svg class="h-6 w-6 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
            </div>
        </a>

        <!-- Draft/Pending - Clickable -->
        <a href="{{ route('student.submissions.index', ['status' => 'draft']) }}" 
           class="bg-white rounded-lg shadow-md p-4 sm:p-6 hover:shadow-lg transition-all cursor-pointer group"
           title="View drafts and pending submissions">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600 group-hover:text-green-600">Draft/Pending</p>
                    <p class="text-3xl font-bold text-gray-600 mt-2">{{ $stats['draft'] + $stats['submitted'] }}</p>
                </div>
                <div class="h-12 w-12 bg-gray-100 rounded-full flex items-center justify-center group-hover:bg-gray-200">
                    <svg class="h-6 w-6 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
            </div>
        </a>

        <!-- Practical Assessments Status - New Card -->
        <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Practical Assessments</p>
                    <div class="mt-2 space-y-1">
                        <p class="text-lg font-bold text-purple-600">{{ $practicalStats['marked'] }} <span class="text-xs font-normal text-gray-500">Marked</span></p>
                        <p class="text-sm text-yellow-600">{{ $practicalStats['pending'] }} <span class="text-xs font-normal text-gray-500">Pending</span></p>
                        <p class="text-sm text-gray-600">{{ $practicalStats['absent'] }} <span class="text-xs font-normal text-gray-500">Absent</span></p>
                    </div>
                </div>
                <div class="h-12 w-12 bg-purple-100 rounded-full flex items-center justify-center">
                    <svg class="h-6 w-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                    </svg>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content Grid -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 sm:gap-6">
        <!-- Left Column - 2/3 width -->
        <div class="lg:col-span-2 space-y-4 sm:space-y-6">
            <!-- My Units -->
            <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
                <div class="flex items-center justify-between mb-4">
                    <h2 class="text-xl font-semibold text-gray-900">My Units</h2>
                    <a href="{{ route('student.units.index') }}" class="text-sm text-green-600 hover:text-green-700 font-medium">View All</a>
                </div>
                @if($units && $units->count() > 0)
                    <div class="space-y-4">
                        @foreach($units->take(5) as $unit)
                            <div class="border border-gray-200 rounded-lg p-4 hover:bg-gray-50 transition-colors">
                                <div class="flex items-center justify-between">
                                    <div class="flex-1">
                                        <a href="{{ route('student.units.show', $unit) }}" class="block">
                                            <h3 class="font-semibold text-gray-900 hover:text-green-600">{{ $unit->name }}</h3>
                                        </a>
                                        @if($unit->code)
                                            <p class="text-sm text-gray-500 mt-1">{{ $unit->code }}</p>
                                        @endif
                                        @if(isset($unit->class_name))
                                            <p class="text-sm text-gray-600 mt-1">{{ $unit->class_name }}</p>
                                        @endif
                                        <div class="mt-2 flex flex-wrap gap-2">
                                            @if($unit->written_count > 0)
                                                <span class="inline-flex items-center px-2 py-1 text-xs font-medium rounded-full bg-blue-100 text-blue-800">
                                                    📝 Written: {{ $unit->written_count }}
                                                </span>
                                            @endif
                                            @if($unit->practical_count > 0)
                                                <span class="inline-flex items-center px-2 py-1 text-xs font-medium rounded-full bg-purple-100 text-purple-800">
                                                    🧪 Practical: {{ $unit->practical_count }}
                                                </span>
                                            @endif
                                            @if($unit->assignments_count == 0)
                                                <span class="text-sm text-gray-500">No assignments available</span>
                                            @endif
                                        </div>
                                    </div>
                                    <a href="{{ route('student.units.show', $unit) }}" class="p-2 -m-2 text-green-600 hover:text-green-800 ml-3 touch-manipulation rounded-lg">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                        </svg>
                                    </a>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8">
                        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        <p class="mt-2 text-sm text-gray-500">No units found for the active term.</p>
                    </div>
                @endif
            </div>

            <!-- Recent Activity (Expanded from Recent Submissions) -->
            <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
                <div class="flex items-center justify-between mb-4">
                    <h2 class="text-xl font-semibold text-gray-900">Recent Activity</h2>
                    <a href="{{ route('student.submissions.index') }}" class="text-sm text-green-600 hover:text-green-700 font-medium">View All</a>
                </div>
                @if($recentActivity->count() > 0)
                    <div class="space-y-3">
                        @foreach($recentActivity as $activity)
                            <div class="flex items-start gap-3 p-3 bg-gray-50 rounded-lg border border-gray-200">
                                <div class="flex-shrink-0 mt-0.5">
                                    @if($activity['type'] === 'submission')
                                        <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                        </svg>
                                    @elseif($activity['type'] === 'practical_marked')
                                        <svg class="w-5 h-5 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                        </svg>
                                    @endif
                                </div>
                                <div class="flex-1 min-w-0">
                                    <p class="text-sm font-medium text-gray-900">{{ $activity['title'] }}</p>
                                    <p class="text-xs text-gray-600 mt-0.5">{{ $activity['unit'] }}</p>
                                    @if(isset($activity['marks']))
                                        <p class="text-xs text-purple-600 mt-1 font-semibold">Marks: {{ $activity['marks'] }}</p>
                                    @endif
                                    <p class="text-xs text-gray-500 mt-1">{{ $activity['date']->diffForHumans() }}</p>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8">
                        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        <p class="mt-2 text-sm text-gray-500">No recent activity.</p>
                    </div>
                @endif
            </div>
        </div>

        <!-- Right Column - 1/3 width -->
        <div class="space-y-4 sm:space-y-6">
            <!-- Quick Actions - Smart/Conditional -->
            <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">Quick Actions</h2>
                <div class="space-y-3">
                    @if($pendingAssignments->count() > 0)
                        <a href="{{ route('student.submissions.create') }}" class="block w-full px-4 py-3 min-h-[44px] bg-green-600 text-white text-center rounded-md hover:bg-green-700 font-medium transition-colors touch-manipulation flex items-center justify-center">
                            <svg class="inline-block h-5 w-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                            </svg>
                            New Submission
                        </a>
                    @endif
                    
                    @if($practicalStats['pending'] > 0)
                        <a href="{{ route('student.units.index') }}" class="block w-full px-4 py-3 bg-purple-600 text-white text-center rounded-md hover:bg-purple-700 font-medium transition-colors">
                            <svg class="inline-block h-5 w-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                            </svg>
                            View Practical Status
                        </a>
                    @endif
                    
                    <a href="{{ route('student.submissions.index') }}" class="block w-full px-4 py-3 min-h-[44px] bg-white border-2 border-green-600 text-green-600 text-center rounded-md hover:bg-green-50 font-medium transition-colors touch-manipulation flex items-center justify-center">
                    View My Submissions
                    </a>
                    
                    <a href="{{ route('student.progress.index') }}" class="block w-full px-4 py-3 min-h-[44px] bg-white border-2 border-gray-300 text-gray-700 text-center rounded-md hover:bg-gray-50 font-medium transition-colors touch-manipulation flex items-center justify-center">
                    View Progress
                    </a>
                </div>
            </div>

            <!-- Progress Breakdown -->
            <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">Progress Overview</h2>
                <div class="space-y-4">
                    <div>
                        <div class="flex items-center justify-between mb-2">
                            <span class="text-sm font-medium text-gray-700">Written</span>
                            <span class="text-sm font-bold text-blue-600">{{ $progressBreakdown['written'] }}%</span>
                        </div>
                        <div class="w-full bg-gray-200 rounded-full h-2">
                            <div class="bg-blue-600 h-2 rounded-full" style="width: {{ $progressBreakdown['written'] }}%"></div>
                        </div>
                    </div>
                    <div>
                        <div class="flex items-center justify-between mb-2">
                            <span class="text-sm font-medium text-gray-700">Practical</span>
                            <span class="text-sm font-bold text-purple-600">{{ $progressBreakdown['practical'] }}%</span>
                        </div>
                        <div class="w-full bg-gray-200 rounded-full h-2">
                            <div class="bg-purple-600 h-2 rounded-full" style="width: {{ $progressBreakdown['practical'] }}%"></div>
                        </div>
                    </div>
                    <div class="pt-3 border-t border-gray-200">
                        <div class="flex items-center justify-between mb-2">
                            <span class="text-sm font-semibold text-gray-900">Overall</span>
                            <span class="text-lg font-bold text-green-600">{{ $progressBreakdown['overall'] }}%</span>
                        </div>
                        <div class="w-full bg-gray-200 rounded-full h-3">
                            <div class="bg-green-600 h-3 rounded-full" style="width: {{ $progressBreakdown['overall'] }}%"></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Pending Assignments with Urgency -->
            @if($pendingAssignments->count() > 0)
                <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
                    <h2 class="text-xl font-semibold text-gray-900 mb-4">Assignments Due</h2>
                    <div class="space-y-3">
                        @foreach($pendingAssignments as $assignment)
                            <div class="border rounded-lg p-3 {{ $assignment->is_overdue ? 'border-red-300 bg-red-50' : ($assignment->days_until_due !== null && $assignment->days_until_due <= 3 ? 'border-yellow-300 bg-yellow-50' : 'border-gray-200 bg-gray-50') }}">
                                <h3 class="font-medium text-gray-900 text-sm">{{ $assignment->title }}</h3>
                                <p class="text-xs text-gray-600 mt-1">{{ $assignment->unit->name }}</p>
                                <div class="mt-2 flex items-center justify-between">
                                    @if($assignment->is_overdue)
                                        <span class="text-xs font-semibold text-red-600">
                                            Overdue by {{ abs($assignment->days_until_due) }} {{ Str::plural('day', abs($assignment->days_until_due)) }}
                                        </span>
                                    @elseif($assignment->days_until_due !== null)
                                        <span class="text-xs font-semibold {{ $assignment->days_until_due <= 3 ? 'text-yellow-600' : 'text-green-600' }}">
                                            Due in {{ $assignment->days_until_due }} {{ Str::plural('day', $assignment->days_until_due) }}
                                        </span>
                                    @else
                                        <span class="text-xs text-gray-500">No due date</span>
                                    @endif
                                    <a href="{{ route('student.assignments.show', $assignment) }}" class="text-xs text-green-600 hover:text-green-700 font-medium">
                                        View →
                                    </a>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif

            <!-- Status Breakdown -->
            <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
                <h2 class="text-xl font-semibold text-gray-900 mb-4">Submission Status</h2>
                <div class="space-y-3">
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-600">Draft</span>
                        <span class="text-sm font-semibold text-gray-900">{{ $stats['draft'] }}</span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-600">Submitted</span>
                        <span class="text-sm font-semibold text-gray-900">{{ $stats['submitted'] }}</span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-600">Under Review</span>
                        <span class="text-sm font-semibold text-yellow-600">{{ $stats['under_review'] }}</span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-600">Trainer Reviewed</span>
                        <span class="text-sm font-semibold text-purple-600">{{ $stats['trainer_reviewed'] }}</span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-600">HOD Approved</span>
                        <span class="text-sm font-semibold text-indigo-600">{{ $stats['hod_approved'] }}</span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-600">Exams Verified</span>
                        <span class="text-sm font-semibold text-cyan-600">{{ $stats['exams_verified'] }}</span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-600">Approved</span>
                        <span class="text-sm font-semibold text-green-600">{{ $stats['validator_approved'] }}</span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm text-gray-600">Rejected</span>
                        <span class="text-sm font-semibold text-red-600">{{ $stats['rejected'] }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
