@extends('layouts.student')

@section('title', 'My Profile')

@section('page-title', 'My Profile')

@section('content')
<div class="max-w-4xl mx-auto space-y-6">
    <div class="bg-white shadow-md rounded-lg p-4 sm:p-6">
        <h2 class="text-xl font-semibold text-gray-900 mb-4">Personal Details</h2>
        <form action="{{ route('student.profile.update') }}" method="POST" enctype="multipart/form-data" class="space-y-6">
            @csrf
            @method('PUT')

            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 sm:gap-6">
                <div>
                    <label class="block text-sm font-medium text-gray-700">First Name</label>
                    <input type="text" name="first_name" value="{{ old('first_name', $student->first_name) }}"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring-green-500 text-sm">
                    @error('first_name')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">Last Name</label>
                    <input type="text" name="last_name" value="{{ old('last_name', $student->last_name) }}"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring-green-500 text-sm">
                    @error('last_name')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">Admission Number</label>
                    <input type="text" value="{{ $student->admission_number }}" disabled
                           class="mt-1 block w-full rounded-md border-gray-200 bg-gray-100 text-gray-600 text-sm">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">Email</label>
                    <input type="email" value="{{ $student->email }}" disabled
                           class="mt-1 block w-full rounded-md border-gray-200 bg-gray-100 text-gray-600 text-sm">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">Phone</label>
                    <input type="text" name="phone" value="{{ old('phone', $student->phone) }}"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring-green-500 text-sm">
                    @error('phone')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">National ID Number</label>
                    <input type="text" name="national_id_number" value="{{ old('national_id_number', $student->national_id_number) }}"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring-green-500 text-sm">
                    @error('national_id_number')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">Date of Birth</label>
                    <input type="date" name="date_of_birth" value="{{ old('date_of_birth', optional($student->date_of_birth)->format('Y-m-d')) }}"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring-green-500 text-sm">
                    @error('date_of_birth')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">Guardian Name</label>
                    <input type="text" name="guardian_name" value="{{ old('guardian_name', $student->guardian_name) }}"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring-green-500 text-sm">
                    @error('guardian_name')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700">Guardian Phone</label>
                    <input type="text" name="guardian_phone" value="{{ old('guardian_phone', $student->guardian_phone) }}"
                           class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring-green-500 text-sm">
                    @error('guardian_phone')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700">Address</label>
                <textarea name="address" rows="3"
                          class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-green-500 focus:ring-green-500 text-sm">{{ old('address', $student->address) }}</textarea>
                @error('address')
                    <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <div class="border-t border-gray-200 pt-4">
                <h3 class="text-lg font-semibold text-gray-900 mb-3">Documents</h3>
                <p class="text-xs text-gray-500 mb-4">Accepted formats: PDF, JPG, JPEG, PNG. Max size: 5MB each.</p>

                <div class="space-y-4">
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 sm:gap-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-700">ID Document</label>
                            <input type="file" name="id_document" accept=".pdf,.jpg,.jpeg,.png"
                                   class="mt-1 block w-full text-sm text-gray-700">
                            @if($student->id_document_path)
                                <a href="{{ Storage::disk('public')->url($student->id_document_path) }}" target="_blank"
                                   class="mt-1 inline-flex items-center text-xs text-green-600 hover:text-green-700">
                                    View current file
                                </a>
                            @endif
                            @error('id_document')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700">KCPE Certificate</label>
                            <input type="file" name="kcpe_certificate" accept=".pdf,.jpg,.jpeg,.png"
                                   class="mt-1 block w-full text-sm text-gray-700">
                            @if($student->kcpe_certificate_path)
                                <a href="{{ Storage::disk('public')->url($student->kcpe_certificate_path) }}" target="_blank"
                                   class="mt-1 inline-flex items-center text-xs text-green-600 hover:text-green-700">
                                    View current file
                                </a>
                            @endif
                            @error('kcpe_certificate')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700">KCSE Certificate</label>
                            <input type="file" name="kcse_certificate" accept=".pdf,.jpg,.jpeg,.png"
                                   class="mt-1 block w-full text-sm text-gray-700">
                            @if($student->kcse_certificate_path)
                                <a href="{{ Storage::disk('public')->url($student->kcse_certificate_path) }}" target="_blank"
                                   class="mt-1 inline-flex items-center text-xs text-green-600 hover:text-green-700">
                                    View current file
                                </a>
                            @endif
                            @error('kcse_certificate')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700">Birth Certificate</label>
                            <input type="file" name="birth_certificate" accept=".pdf,.jpg,.jpeg,.png"
                                   class="mt-1 block w-full text-sm text-gray-700">
                            @if($student->birth_certificate_path)
                                <a href="{{ Storage::disk('public')->url($student->birth_certificate_path) }}" target="_blank"
                                   class="mt-1 inline-flex items-center text-xs text-green-600 hover:text-green-700">
                                    View current file
                                </a>
                            @endif
                            @error('birth_certificate')
                                <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>

            <div class="flex flex-col-reverse sm:flex-row items-stretch sm:items-center justify-end gap-3 pt-4 sm:pt-6 border-t border-gray-200">
                <a href="{{ route('student.dashboard') }}" class="inline-flex items-center justify-center py-2.5 min-h-[44px] text-sm text-gray-600 hover:text-gray-800 touch-manipulation">Cancel</a>
                <button type="submit"
                        class="inline-flex items-center justify-center px-4 py-2.5 min-h-[44px] border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 touch-manipulation">
                    Save Changes
                </button>
            </div>
        </form>
    </div>
</div>
@endsection


