<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Portfolio – {{ $unit->name }}</title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; padding: 24px; }
        .header { margin-bottom: 20px; padding-bottom: 12px; border-bottom: 1px solid #333; }
        .unit-name { font-size: 16px; font-weight: bold; margin-bottom: 4px; }
        .unit-code { font-size: 11px; color: #555; }
        .meta { font-size: 11px; color: #444; margin-top: 8px; }
        table { width: 100%; border-collapse: collapse; margin-top: 16px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background: #f5f5f5; font-weight: bold; }
        .no-items { font-style: italic; color: #888; margin-top: 16px; }
    </style>
</head>
<body>
    <div class="header">
        <div class="unit-name">{{ $unit->name }}</div>
        @if($unit->code)
            <div class="unit-code">Code: {{ $unit->code }}</div>
        @endif
        <div class="meta">
            {{ $user->name }}@if($user->admission_number ?? null) ({{ $user->admission_number }})@endif
            &nbsp;|&nbsp; {{ $activeTerm->name }}
            &nbsp;|&nbsp; Portfolio
            &nbsp;|&nbsp; {{ now()->format('d M Y') }}
        </div>
    </div>

    <h2 style="font-size: 14px; margin-bottom: 8px;">Portfolio submissions (POE)</h2>

    @if($submissions->count() > 0)
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Class</th>
                    <th>Status</th>
                    <th>Submitted</th>
                </tr>
            </thead>
            <tbody>
                @foreach($submissions as $i => $sub)
                    <tr>
                        <td>{{ $i + 1 }}</td>
                        <td>{{ $sub->schoolClass->name ?? '—' }}</td>
                        <td>{{ $sub->status ?? '—' }}</td>
                        <td>{{ $sub->submitted_at ? $sub->submitted_at->format('d M Y') : '—' }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @else
        <p class="no-items">No portfolio submissions for this unit.</p>
    @endif
</body>
</html>
