@extends('layouts.student')

@section('title', isset($evidence) ? 'Practical Evidence Details' : 'Submission Details')
@section('page-title', isset($evidence) ? 'Practical Evidence Details' : 'Submission Details')

@section('content')
    <div class="mb-4 sm:mb-6">
        <a href="{{ route('student.submissions.index') }}" class="text-indigo-600 hover:text-indigo-900 flex items-center touch-manipulation">
            <svg class="h-5 w-5 mr-1 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
            </svg>
            Back to Portfolio Evidence
        </a>
    </div>

    @if(isset($evidence))
        <!-- Practical Evidence View -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 sm:gap-6">
            <!-- Main Content -->
            <div class="lg:col-span-2 space-y-4 sm:space-y-6">
                <!-- Evidence Info -->
                <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                    <div class="px-4 sm:px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <h3 class="text-base sm:text-lg font-semibold text-gray-900">Practical Evidence Information</h3>
                    </div>
                    <div class="px-4 sm:px-6 py-4">
                        <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Unit</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    <div class="font-medium">{{ $evidence->unit->name }}</div>
                                    @if($evidence->unit->code)
                                        <div class="text-xs text-gray-500">{{ $evidence->unit->code }}</div>
                                    @endif
                                </dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Class</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    <div class="font-medium">{{ $evidence->schoolClass->name }}</div>
                                    @if($evidence->schoolClass->code)
                                        <div class="text-xs text-gray-500">{{ $evidence->schoolClass->code }}</div>
                                    @endif
                                </dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Task Name</dt>
                                <dd class="mt-1 text-sm text-gray-900 font-medium">{{ $evidence->task_name }}</dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Evidence Type</dt>
                                <dd class="mt-1">
                                    <span class="px-2 py-1 text-xs font-semibold rounded-full 
                                        @if($evidence->isVideo()) bg-red-100 text-red-800
                                        @elseif($evidence->isImage()) bg-green-100 text-green-800
                                        @elseif($evidence->isAudio()) bg-purple-100 text-purple-800
                                        @else bg-blue-100 text-blue-800
                                        @endif">
                                        {{ ucfirst($evidence->evidence_type) }}
                                    </span>
                                </dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Status</dt>
                                <dd class="mt-1">
                                    @php
                                        $statusValues = $allTaskEvidence->pluck('status')->unique()->values();
                                        $statusLabel = $statusValues->count() === 1 ? $evidence->getStatusLabel() : 'Mixed';
                                        $statusClasses = $statusValues->count() === 1 
                                            ? $evidence->getStatusBadgeClasses() 
                                            : 'bg-yellow-100 text-yellow-800';
                                    @endphp
                                    <span class="px-3 py-1 text-sm font-semibold rounded-full {{ $statusClasses }}">
                                        {{ $statusLabel }}
                                    </span>
                                    @if($allTaskEvidence->count() > 1)
                                        <p class="text-xs text-gray-500 mt-1">
                                            {{ $allTaskEvidence->count() }} files
                                        </p>
                                    @endif
                                </dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Uploaded At</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $evidence->uploaded_at->format('M d, Y h:i A') }}</dd>
                            </div>
                        </dl>
                        @if($evidence->notes)
                            <div class="mt-4 pt-4 border-t border-gray-200">
                                <dt class="text-sm font-medium text-gray-500 mb-1">Notes</dt>
                                <dd class="text-sm text-gray-900 bg-gray-50 p-3 rounded">{{ $evidence->notes }}</dd>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Media Preview - All files for this task -->
                <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <h3 class="text-lg font-semibold text-gray-900">
                            Media Evidence 
                            @if($allTaskEvidence->count() > 1)
                                <span class="ml-2 text-sm font-normal text-gray-600">({{ $allTaskEvidence->count() }} files)</span>
                            @endif
                        </h3>
                    </div>
                    <div class="px-6 py-4 space-y-6">
                        @foreach($allTaskEvidence as $taskEvidence)
                            <div class="border border-gray-200 rounded-lg p-4 {{ $loop->first ? 'bg-indigo-50 border-indigo-300' : '' }}">
                                <div class="flex items-center justify-between mb-3">
                                    <div class="flex items-center gap-2">
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full 
                                            @if($taskEvidence->isVideo()) bg-red-100 text-red-800
                                            @elseif($taskEvidence->isImage()) bg-green-100 text-green-800
                                            @elseif($taskEvidence->isAudio()) bg-purple-100 text-purple-800
                                            @else bg-blue-100 text-blue-800
                                            @endif">
                                            {{ ucfirst($taskEvidence->evidence_type) }}
                                        </span>
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $taskEvidence->getStatusBadgeClasses() }}">
                                            {{ $taskEvidence->getStatusLabel() }}
                                        </span>
                                        @if($loop->first)
                                            <span class="px-2 py-1 text-xs font-semibold rounded-full bg-indigo-100 text-indigo-800">
                                                Current
                                            </span>
                                        @endif
                                    </div>
                                    <div class="text-xs text-gray-500">
                                        {{ $taskEvidence->uploaded_at->format('M d, Y h:i A') }}
                                    </div>
                                </div>
                                
                                @if($taskEvidence->isVideo())
                                    <video controls class="w-full rounded-lg" style="max-height: 400px;">
                                        <source src="{{ Storage::url($taskEvidence->file_path) }}" type="{{ $taskEvidence->mime_type }}">
                                        Your browser does not support the video tag.
                                    </video>
                                @elseif($taskEvidence->isImage())
                                    <img src="{{ Storage::url($taskEvidence->file_path) }}" alt="{{ $taskEvidence->task_name }}" class="w-full rounded-lg" style="max-height: 400px; object-fit: contain;">
                                @elseif($taskEvidence->isAudio())
                                    <audio controls class="w-full">
                                        <source src="{{ Storage::url($taskEvidence->file_path) }}" type="{{ $taskEvidence->mime_type }}">
                                        Your browser does not support the audio tag.
                                    </audio>
                                @else
                                    @php
                                        $fileUrl = Storage::url($taskEvidence->file_path);
                                        $isPdf = strtolower(pathinfo($taskEvidence->file_path, PATHINFO_EXTENSION)) === 'pdf';
                                    @endphp
                                    @if($isPdf)
                                        <iframe src="{{ $fileUrl }}#toolbar=1" class="w-full rounded border border-gray-200 bg-white" style="height: 400px;" title="PDF preview"></iframe>
                                    @endif
                                @endif
                                
                                <div class="mt-4 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3">
                                    <div>
                                        <p class="text-sm font-medium text-gray-900">{{ $taskEvidence->original_name }}</p>
                                        <p class="text-xs text-gray-500">{{ $taskEvidence->file_size_human ?? number_format($taskEvidence->file_size / 1024, 2) . ' KB' }}</p>
                                    </div>
                                    <div class="flex flex-wrap gap-2">
                                        <a href="{{ Storage::url($taskEvidence->file_path) }}" target="_blank" rel="noopener noreferrer" class="inline-flex items-center justify-center px-4 py-2.5 min-h-[44px] bg-indigo-600 text-white rounded-md hover:bg-indigo-700 text-sm font-medium touch-manipulation">
                                            <svg class="w-4 h-4 mr-1.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path></svg>
                                            Preview
                                        </a>
                                        <a href="{{ Storage::url($taskEvidence->file_path) }}" download class="inline-flex items-center justify-center px-4 py-2.5 min-h-[44px] border border-gray-300 bg-white text-gray-700 rounded-md hover:bg-gray-50 text-sm font-medium touch-manipulation">
                                            <svg class="w-4 h-4 mr-1.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path></svg>
                                            Download
                                        </a>
                                    </div>
                                </div>
                                
                                @if($taskEvidence->notes && $taskEvidence->notes !== $evidence->notes)
                                    <div class="mt-3 pt-3 border-t border-gray-200">
                                        <p class="text-xs font-medium text-gray-500 mb-1">Notes for this file:</p>
                                        <p class="text-sm text-gray-700 bg-gray-50 p-2 rounded">{{ $taskEvidence->notes }}</p>
                                    </div>
                                @endif
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Comments - Show comments from all files in this task -->
                @php
                    $allComments = $allTaskEvidence->flatMap->comments->sortBy('created_at');
                @endphp
                @if($allComments->count() > 0)
                    <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                        <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                            <h3 class="text-lg font-semibold text-gray-900">Comments ({{ $allComments->count() }})</h3>
                        </div>
                        <div class="px-6 py-4 space-y-4">
                            @foreach($allComments as $comment)
                                <div class="border-l-4 border-indigo-500 pl-4 py-2">
                                    <div class="flex justify-between items-start mb-2">
                                        <div>
                                            <p class="font-medium text-gray-900">{{ $comment->user->name ?? 'Unknown' }}</p>
                                            <p class="text-xs text-gray-500">{{ $comment->created_at->format('M d, Y h:i A') }}</p>
                                        </div>
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full bg-indigo-100 text-indigo-800">
                                            {{ ucfirst($comment->role) }}
                                        </span>
                                    </div>
                                    <p class="text-sm text-gray-700">{{ $comment->comment }}</p>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>

            <!-- Sidebar -->
            <div class="space-y-4 sm:space-y-6">
                <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                    <div class="px-4 sm:px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <h3 class="text-base sm:text-lg font-semibold text-gray-900">File Information</h3>
                    </div>
                    <div class="px-4 sm:px-6 py-4 space-y-3">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">File Name</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $evidence->original_name }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">File Size</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $evidence->file_size_human }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">MIME Type</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $evidence->mime_type }}</dd>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @else
        <!-- POE Submission View (Backward Compatibility) -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Main Content -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Submission Info -->
                <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <h3 class="text-lg font-semibold text-gray-900">Submission Information</h3>
                    </div>
                    <div class="px-6 py-4">
                        <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Unit</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    <div class="font-medium">{{ $submission->unit->name }}</div>
                                    @if($submission->unit->code)
                                        <div class="text-xs text-gray-500">{{ $submission->unit->code }}</div>
                                    @endif
                                </dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Class</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    <div class="font-medium">{{ $submission->schoolClass->name }}</div>
                                    @if($submission->schoolClass->code)
                                        <div class="text-xs text-gray-500">{{ $submission->schoolClass->code }}</div>
                                    @endif
                                </dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Term</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    {{ $submission->schoolClass->term->name }}
                                    @if($submission->schoolClass->term->status === 'active')
                                        <span class="ml-2 px-2 py-0.5 text-xs rounded-full bg-green-100 text-green-800">Active</span>
                                    @endif
                                </dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Status</dt>
                                <dd class="mt-1">
                                    <span class="px-3 py-1 text-sm font-semibold rounded-full {{ $submission->getStatusBadgeClasses() }}">
                                        {{ $submission->getStatusLabel() }}
                                    </span>
                                </dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Version</dt>
                                <dd class="mt-1 text-sm text-gray-900">v{{ $submission->version }}</dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Submitted At</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    @if($submission->submitted_at)
                                        {{ $submission->submitted_at->format('M d, Y h:i A') }}
                                    @else
                                        <span class="text-gray-400">Not submitted</span>
                                    @endif
                                </dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Created At</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $submission->created_at->format('M d, Y h:i A') }}</dd>
                            </div>
                        </dl>
                        @if($submission->notes)
                            <div class="mt-4 pt-4 border-t border-gray-200">
                                <dt class="text-sm font-medium text-gray-500 mb-1">Notes</dt>
                                <dd class="text-sm text-gray-900 bg-gray-50 p-3 rounded">{{ $submission->notes }}</dd>
                            </div>
                        @endif
                    </div>
                </div>

            <!-- Evidence Files -->
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-4 sm:px-6 py-4 border-b border-gray-200 bg-gray-50 flex flex-col sm:flex-row sm:justify-between sm:items-center gap-2">
                    <h3 class="text-base sm:text-lg font-semibold text-gray-900">Evidence Files ({{ $submission->evidence->count() }})</h3>
                </div>
                <div class="px-4 sm:px-6 py-4">
                    @forelse($submission->evidence as $evidence)
                        <div class="flex items-center justify-between p-4 border border-gray-200 rounded-lg mb-3 hover:bg-gray-50">
                            <div class="flex items-center space-x-4">
                                <div class="flex-shrink-0">
                                    @if($evidence->file_type === 'image')
                                        <svg class="h-10 w-10 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                        </svg>
                                    @elseif($evidence->file_type === 'video')
                                        <svg class="h-10 w-10 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z"></path>
                                        </svg>
                                    @else
                                        <svg class="h-10 w-10 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                        </svg>
                                    @endif
                                </div>
                                <div class="flex-1 min-w-0">
                                    <p class="text-sm font-medium text-gray-900 truncate">{{ $evidence->file_name }}</p>
                                    <p class="text-xs text-gray-500">
                                        {{ ucfirst($evidence->file_type) }} • {{ number_format($evidence->file_size / 1024, 2) }} KB
                                    </p>
                                </div>
                            </div>
                            <div class="flex items-center space-x-2">
                                <a href="{{ route('student.submissions.evidence.download', $evidence) }}" 
                                   class="inline-flex items-center justify-center px-3 py-2 min-h-[44px] sm:min-h-0 sm:py-1.5 text-sm bg-indigo-600 text-white rounded hover:bg-indigo-700 touch-manipulation">
                                    Download
                                </a>
                            </div>
                        </div>
                    @empty
                        <p class="text-gray-500 text-center py-8">No evidence files uploaded yet</p>
                    @endforelse
                </div>
            </div>

            <!-- Reviews -->
            @if($submission->reviews->count() > 0)
                <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <h3 class="text-lg font-semibold text-gray-900">Reviews ({{ $submission->reviews->count() }})</h3>
                    </div>
                    <div class="px-6 py-4 space-y-4">
                        @foreach($submission->reviews as $review)
                            <div class="border-l-4 border-indigo-500 pl-4 py-2">
                                <div class="flex justify-between items-start mb-2">
                                    <div>
                                        <p class="font-medium text-gray-900">{{ $review->reviewer->name ?? 'Unknown' }}</p>
                                        <p class="text-xs text-gray-500">{{ $review->reviewed_at ? $review->reviewed_at->format('M d, Y h:i A') : 'Not reviewed' }}</p>
                                    </div>
                                    @if($review->marks)
                                        <span class="px-2 py-1 text-xs font-semibold bg-green-100 text-green-800 rounded">
                                            {{ $review->marks }} marks
                                        </span>
                                    @endif
                                </div>
                                @if($review->feedback)
                                    <p class="text-sm text-gray-700">{{ $review->feedback }}</p>
                                @endif
                                <span class="inline-block mt-2 px-2 py-1 text-xs rounded-full
                                    @if($review->status === 'approved') bg-green-100 text-green-800
                                    @elseif($review->status === 'rejected') bg-red-100 text-red-800
                                    @else bg-yellow-100 text-yellow-800
                                    @endif">
                                    {{ ucfirst($review->status) }}
                                </span>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif

            <!-- Validation -->
            @if($submission->validation)
                <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <h3 class="text-lg font-semibold text-gray-900">Validation</h3>
                    </div>
                    <div class="px-6 py-4">
                        <div class="flex justify-between items-start mb-2">
                            <div>
                                <p class="font-medium text-gray-900">{{ $submission->validation->validator->name ?? 'Unknown' }}</p>
                                <p class="text-xs text-gray-500">{{ $submission->validation->validated_at ? $submission->validation->validated_at->format('M d, Y h:i A') : 'Not validated' }}</p>
                            </div>
                            <span class="px-3 py-1 text-sm font-semibold rounded-full
                                @if($submission->validation->status === 'approved') bg-green-100 text-green-800
                                @elseif($submission->validation->status === 'rejected') bg-red-100 text-red-800
                                @else bg-yellow-100 text-yellow-800
                                @endif">
                                {{ ucfirst($submission->validation->status) }}
                            </span>
                        </div>
                        @if($submission->validation->comments)
                            <p class="text-sm text-gray-700 mt-2">{{ $submission->validation->comments }}</p>
                        @endif
                    </div>
                </div>
            @endif
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Actions -->
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">Actions</h3>
                </div>
                <div class="px-6 py-4 space-y-2">
                    @if($submission->status === 'draft')
                        <a href="{{ route('student.submissions.edit', $submission) }}" class="block w-full px-4 py-2.5 min-h-[44px] bg-yellow-600 text-white rounded-md hover:bg-yellow-700 text-center touch-manipulation flex items-center justify-center">
                            Edit Submission
                        </a>
                        <form action="{{ route('student.submissions.submit', $submission) }}" method="POST" onsubmit="return confirm('Are you sure you want to submit this for review? You will not be able to edit it after submission.');">
                            @csrf
                            <button type="submit" class="w-full px-4 py-2.5 min-h-[44px] bg-indigo-600 text-white rounded-md hover:bg-indigo-700 touch-manipulation">
                                Submit for Review
                            </button>
                        </form>
                        <form action="{{ route('student.submissions.destroy', $submission) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this submission? This action cannot be undone.');">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="w-full px-4 py-2.5 min-h-[44px] bg-red-600 text-white rounded-md hover:bg-red-700 touch-manipulation">
                                Delete Submission
                            </button>
                        </form>
                    @else
                        <p class="text-sm text-gray-500 text-center py-2">
                            This submission has been submitted and cannot be edited.
                        </p>
                    @endif
                </div>
            </div>
        </div>
    </div>
    @endif
@endsection

