@extends('layouts.student')

@section('title', 'My Units')
@section('page-title', 'My Units')

@section('content')
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl font-bold text-gray-900">My Units</h1>
        <p class="mt-1 text-sm text-gray-600">View your assigned units and assignments</p>
    </div>

    @if($activeTerm)
        <div class="mb-4 sm:mb-6 p-4 bg-green-50 border border-green-200 rounded-lg">
            <p class="text-sm text-green-800"><strong>Active Term:</strong> {{ $activeTerm->name }}</p>
        </div>
    @endif

    @if(isset($warning))
        <div class="mb-6 p-4 bg-yellow-50 border border-yellow-200 rounded-lg">
            <p class="text-sm text-yellow-800">{{ $warning }}</p>
        </div>
    @endif

    @if(session('warning'))
        <div class="mb-6 p-4 bg-yellow-50 border border-yellow-200 rounded-lg">
            <p class="text-sm text-yellow-800">{{ session('warning') }}</p>
        </div>
    @endif

    @if(session('error'))
        <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-lg">
            <div class="flex">
                <svg class="w-5 h-5 text-red-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <p class="text-sm font-medium text-red-800">{{ session('error') }}</p>
            </div>
        </div>
    @endif

    @if($units->count() > 0)
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-6">
            @foreach($units as $unit)
                <div class="bg-white rounded-lg shadow hover:shadow-lg transition-shadow">
                    <div class="p-4 sm:p-6">
                        <div class="flex items-start justify-between mb-4 gap-3">
                            <div class="flex-1 min-w-0">
                                <a href="{{ route('student.units.show', $unit) }}" class="block touch-manipulation">
                                    <h3 class="text-base sm:text-lg font-semibold text-gray-900 hover:text-green-600 break-words">{{ $unit->name }}</h3>
                                </a>
                                @if($unit->code)
                                    <p class="text-sm text-gray-500 mt-1">{{ $unit->code }}</p>
                                @endif
                                @if($unit->department)
                                    <p class="text-sm text-gray-500">{{ $unit->department->name }}</p>
                                @endif
                            </div>
                            <a href="{{ route('student.units.show', $unit) }}" class="p-2 -m-2 text-green-600 hover:text-green-800 touch-manipulation rounded-lg flex-shrink-0">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                </svg>
                            </a>
                        </div>
                        
                        <div class="space-y-2 text-sm mb-4">
                            <div class="flex items-center text-gray-600">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                                </svg>
                                {{ $unit->assignments_count }} Assignments
                            </div>
                            @if($unit->has_submission)
                                <div class="flex items-center text-green-600">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                    Submission Available
                                </div>
                            @endif
                        </div>

                        @if($unit->assigned_classes->count() > 0)
                            <div class="pt-4 border-t">
                                <p class="text-xs font-medium text-gray-700 mb-2">Classes:</p>
                                <div class="flex flex-wrap gap-1">
                                    @foreach($unit->assigned_classes->take(2) as $class)
                                        <span class="px-2 py-1 text-xs bg-purple-100 text-purple-800 rounded">
                                            {{ $class->name }}
                                        </span>
                                    @endforeach
                                    @if($unit->assigned_classes->count() > 2)
                                        <span class="px-2 py-1 text-xs bg-gray-100 text-gray-600 rounded">
                                            +{{ $unit->assigned_classes->count() - 2 }} more
                                        </span>
                                    @endif
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>
    @else
        <div class="bg-white rounded-lg shadow p-8 text-center">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900">No units assigned</h3>
            <p class="mt-1 text-sm text-gray-500">You don't have any units assigned yet.</p>
        </div>
    @endif
@endsection

