<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Assessor Tool - {{ $submission->student->name ?? 'Student' }}</title>
    <style>
        body {
            font-family: 'Times New Roman', serif;
            font-size: 11pt;
            line-height: 1.4;
            margin: 0;
            padding: 20px;
        }
        /* Letterhead and title */
        .letterhead {
            text-align: center;
            margin-bottom: 10px;
        }
        .logo-section img {
            max-height: 80px;
            max-width: 120px;
            object-fit: contain;
        }
        .institution-name {
            font-size: 16pt;
            font-weight: bold;
            text-transform: uppercase;
            margin-top: 4px;
        }
        .department-name {
            font-size: 14pt;
            font-weight: bold;
            text-transform: uppercase;
            margin-top: 2px;
        }
        .report-title {
            text-align: center;
            font-size: 13pt;
            font-weight: bold;
            text-transform: uppercase;
            margin: 10px 0 12px;
          
        }
        .top-meta {
            text-align: left;
            margin-bottom: 16px;
            font-size: 13pt;
            font-weight: bold;
            text-transform: uppercase;
            line-height: 1.6;
        }
        .top-meta-line {
            margin-bottom: 2px;
        }
        .candidate-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
            font-size: 10pt;
        }
        .candidate-table td {
            border: 1px solid #000;
            padding: 6px 8px;
            font-weight: bold;
            text-transform: uppercase;
        }
        .candidate-table .candidate-label {
            width: 35%;
            background-color: #f5f5f5;
        }
        .candidate-table .candidate-value {
            border-bottom: 1px solid #000;
        }
        .sub-title {
            text-align: center;
            font-size: 12pt;
            font-weight: bold;
            margin: 10px 0 14px;
            text-transform: uppercase;
            text-decoration:underline;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th {
            background-color: #f0f0f0;
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
            font-weight: bold;
        }
        td {
            border: 1px solid #000;
            padding: 8px;
            vertical-align: top;
        }
        .item-description {
            width: 50%;
        }
        .marks-available {
            width: 12%;
            text-align: center;
        }
        .marks-obtained {
            width: 12%;
            text-align: center;
        }
        .comments {
            width: 26%;
        }
        .section-header {
            background-color: #e0e0e0;
            font-weight: bold;
        }
        .total-row {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 9pt;
        }
    </style>
</head>
<body>
    <!-- Class / Unit / Codes / Series – top left, caps, not in a table, before logo -->
    <div class="top-meta">
        <div class="top-meta-line"> {{ strtoupper($reportMeta['course_name'] ?? '') }}</div>
        <div class="top-meta-line">{{ strtoupper($reportMeta['unit_name'] ?? '') }}</div>
        <div class="top-meta-line">{{ strtoupper($reportMeta['class_code'] ?? '') }}</div>
        <div class="top-meta-line">{{ strtoupper($reportMeta['unit_code'] ?? '') }}</div>
        <div class="top-meta-line">{{ strtoupper($reportMeta['series'] ?? '') }}</div>
    </div>

    <!-- Logo + Institution + Department -->
    <div class="letterhead">
        @php
            $logoRelative = $institutionSettings['institution.logo'] ?? null;
            $logoPath = $logoRelative ? public_path('storage/' . ltrim($logoRelative, '/')) : null;
        @endphp
        @if($logoPath && file_exists($logoPath))
            <div class="logo-section">
                <img src="{{ $logoPath }}" alt="Institution Logo">
            </div>
        @endif
        <div class="institution-info">
            <div class="institution-name">
                {{ $institutionSettings['institution.name'] ?? config('app.name', 'Technical Training Institute') }}
            </div>
            @if(!empty($reportMeta['department_name']))
                <div class="department-name">
                    {{ strtoupper($reportMeta['department_name']) }} DEPARTMENT
                </div>
            @endif
        </div>
    </div>

    <!-- Main title -->
    <div class="report-title">
        PRACTICAL ASSESSMENT
    </div>

    <div class="sub-title">
        OBSERVATION CHECKLIST
    </div>

    <!-- Candidate / Assessor / Venue / Date – in a table, bold, capitals -->
    <table class="candidate-table">
        <tr>
            <td class="candidate-label">{{ strtoupper($headerData['candidate_label'] ?? 'CANDIDATE\'S NAME & REGISTRATION CODE') }}:</td>
            <td class="candidate-value">{{ strtoupper($submission->student->name ?? '') }} @if($submission->student->admission_number)({{ strtoupper($submission->student->admission_number) }})@endif</td>
        </tr>
        <tr>
            <td class="candidate-label">{{ strtoupper($headerData['assessor_label'] ?? 'ASSESSOR\'S NAME & REGISTRATION CODE') }}:</td>
            <td class="candidate-value">{{ strtoupper($assignment->trainer->name ?? '') }}</td>
        </tr>
        <tr>
            <td class="candidate-label">{{ strtoupper($headerData['venue_label'] ?? 'VENUE OF ASSESSMENT') }}:</td>
            <td class="candidate-value"></td>
        </tr>
        <tr>
            <td class="candidate-label">{{ strtoupper($headerData['date_label'] ?? 'DATE OF ASSESSMENT') }}:</td>
            <td class="candidate-value">{{ strtoupper($headerData['date'] ?? now()->format('Y-m-d')) }}</td>
        </tr>
    </table>

    <!-- Main Table -->
    <table>
        <thead>
            <tr>
                <th class="item-description">Items to be Evaluated: Kindly award marks as appropriate. Give a brief comment on your observation.</th>
                <th class="marks-available">Marks Available</th>
                <th class="marks-obtained">Marks Obtained</th>
                <th class="comments">Comments</th>
            </tr>
        </thead>
        <tbody>
            @php
                $currentSection = null;
                $sectionTotal = 0;
            @endphp
            @foreach($sections as $item)
                @php
                    $rowId = $item['row_identifier'] ?? null;
                    $mark = $rowId && isset($marksByRow[$rowId]) ? $marksByRow[$rowId] : null;
                    $marksObtained = $mark ? (float) $mark->marks_obtained : 0;
                @endphp
                
                @if($item['section'] && $item['section'] !== $currentSection)
                    @if($currentSection !== null)
                        <!-- Section Subtotal -->
                        <tr class="section-header">
                            <td colspan="2" class="text-right"><strong>Subtotal ({{ $currentSection }}):</strong></td>
                            <td class="text-center"><strong>{{ number_format($sectionTotal, 2) }}</strong></td>
                            <td></td>
                        </tr>
                    @endif
                    @php
                        $currentSection = $item['section'];
                        $sectionTotal = 0;
                    @endphp
                    <tr class="section-header">
                        <td colspan="4"><strong>{{ $currentSection }}</strong></td>
                    </tr>
                @endif
                
                <tr>
                    <td class="item-description">{{ $item['item_description'] }}</td>
                    <td class="marks-available text-center">{{ number_format($item['marks_available'], 2) }}</td>
                    <td class="marks-obtained text-center">{{ number_format($marksObtained, 2) }}</td>
                    <td class="comments">{{ $mark->comments ?? '' }}</td>
                </tr>
                
                @php
                    $sectionTotal += $marksObtained;
                @endphp
            @endforeach
            
            @if($currentSection !== null)
                <!-- Final Section Subtotal -->
                <tr class="section-header">
                    <td colspan="2" class="text-right"><strong>Subtotal ({{ $currentSection }}):</strong></td>
                    <td class="text-center"><strong>{{ number_format($sectionTotal, 2) }}</strong></td>
                    <td></td>
                </tr>
            @endif
            
            <!-- Total Row -->
            <tr class="total-row">
                <td colspan="2" class="text-right"><strong>TOTAL:</strong></td>
                <td class="text-center"><strong>{{ number_format($overallTotal, 2) }}</strong></td>
                <td></td>
            </tr>
        </tbody>
    </table>

    <div class="footer">
        <p>Page 1 of 1</p>
    </div>
</body>
</html>

