@extends('layouts.trainer')

@section('title', 'Mark Submission')

@php
use Illuminate\Support\Facades\Storage;
@endphp

@section('content')
<div class="max-w-4xl mx-auto">
    <!-- Header -->
    <div class="mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Mark Submission</h1>
                <p class="mt-1 text-sm text-gray-500">{{ $assignment->title }}</p>
            </div>
            <a href="{{ route('trainer.assignments.show', $assignment) }}" 
               class="inline-flex items-center px-4 py-2 bg-gray-200 text-gray-700 text-sm font-medium rounded-md hover:bg-gray-300">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                </svg>
                Back to Assignment
            </a>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Content -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Student Information -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Student Information</h3>
                <dl class="grid grid-cols-2 gap-4">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Name</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ $submission->student->name ?? 'N/A' }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Admission Number</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ $submission->student->admission_number ?? 'N/A' }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Email</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ $submission->student->email ?? 'N/A' }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Submitted At</dt>
                        <dd class="mt-1 text-sm text-gray-900">
                            {{ $submission->submitted_at ? $submission->submitted_at->format('M d, Y H:i') : 'Not submitted' }}
                        </dd>
                    </div>
                </dl>
            </div>

            <!-- Submission Content -->
            @if($submission->feedback)
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Student Feedback/Notes</h3>
                    <div class="text-gray-900 whitespace-pre-wrap">{{ $submission->feedback }}</div>
                </div>
            @endif

            <!-- Attachments -->
            @if($submission->attachments && count($submission->attachments) > 0)
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Submitted Files</h3>
                    <div class="space-y-2">
                        @foreach($submission->attachments as $index => $attachment)
                            <a href="{{ Storage::disk('public')->url($attachment) }}" 
                               target="_blank"
                               class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50">
                                <svg class="w-5 h-5 text-gray-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                </svg>
                                <span class="text-sm text-gray-900">{{ basename($attachment) }}</span>
                            </a>
                        @endforeach
                    </div>
                </div>
            @endif

            <!-- Marking Form -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Marking</h3>
                <form action="{{ route('trainer.assignments.submissions.mark', ['assignment' => $assignment->id, 'submission' => $submission->id]) }}" method="POST">
                    @csrf
                    <div class="space-y-4">
                        <div>
                            <label for="marks" class="block text-sm font-medium text-gray-700 mb-1">
                                Marks <span class="text-red-500">*</span>
                                <span class="text-gray-500 text-xs">(Out of {{ $assignment->total_marks ?? 'N/A' }})</span>
                            </label>
                            <input type="number" 
                                   name="marks" 
                                   id="marks" 
                                   value="{{ old('marks', $submission->marks) }}"
                                   min="0" 
                                   max="{{ $assignment->total_marks ?? 100 }}"
                                   step="0.01"
                                   required
                                   class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 @error('marks') border-red-300 @enderror">
                            @error('marks')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label for="trainer_feedback" class="block text-sm font-medium text-gray-700 mb-1">
                                Feedback/Comments
                            </label>
                            <textarea name="trainer_feedback" 
                                      id="trainer_feedback" 
                                      rows="6"
                                      class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 @error('trainer_feedback') border-red-300 @enderror">{{ old('trainer_feedback', $submission->trainer_feedback) }}</textarea>
                            @error('trainer_feedback')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                            <p class="mt-1 text-xs text-gray-500">Provide feedback to help the student improve.</p>
                        </div>

                        <div class="flex items-center justify-end gap-3 pt-4 border-t">
                            <a href="{{ route('trainer.assignments.show', $assignment) }}" 
                               class="px-4 py-2 bg-gray-200 text-gray-700 rounded-md hover:bg-gray-300">
                                Cancel
                            </a>
                            <button type="submit" 
                                    class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700">
                                Save Marks
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Assignment Info -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Assignment Details</h3>
                <dl class="space-y-3">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Type</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ $assignment->getTypeLabel() }}</dd>
                    </div>
                    @if($assignment->total_marks)
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Total Marks</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $assignment->total_marks }}</dd>
                        </div>
                    @endif
                    @if($assignment->due_date)
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Due Date</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $assignment->due_date->format('M d, Y H:i') }}</dd>
                        </div>
                    @endif
                </dl>
            </div>

            <!-- Current Marks -->
            @if($submission->marks !== null)
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Current Marks</h3>
                    <div class="text-center">
                        <div class="text-3xl font-bold text-blue-600">
                            {{ number_format($submission->marks, 2) }}
                        </div>
                        <div class="text-sm text-gray-500 mt-1">
                            out of {{ $assignment->total_marks ?? 'N/A' }}
                        </div>
                        @if($assignment->total_marks)
                            <div class="text-sm text-gray-500 mt-2">
                                {{ number_format(($submission->marks / $assignment->total_marks) * 100, 1) }}%
                            </div>
                        @endif
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

