@extends('layouts.trainer')

@section('title', 'View Assignment')

@section('content')
<div class="max-w-7xl mx-auto">
    <!-- Header -->
    <div class="mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">{{ $assignment->title }}</h1>
                <p class="mt-1 text-sm text-gray-500">Unit: {{ $assignment->unit->name }} ({{ $assignment->unit->code }})</p>
            </div>
            <div class="flex gap-3">
                <a href="{{ route('trainer.assignments.edit', $assignment) }}" 
                   class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-md hover:bg-blue-700">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                    </svg>
                    Edit
                </a>
                <a href="{{ route('trainer.units.show', $assignment->unit) }}" 
                   class="inline-flex items-center px-4 py-2 bg-gray-200 text-gray-700 text-sm font-medium rounded-md hover:bg-gray-300">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                    </svg>
                    Back to Unit
                </a>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Content -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Assignment Details -->
            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex items-center gap-3 mb-4">
                    <span class="px-3 py-1 text-sm font-medium rounded {{ $assignment->getStatusBadgeClasses() }}">
                        {{ $assignment->getTypeLabel() }}
                    </span>
                    @if($assignment->is_published)
                        <span class="px-3 py-1 text-sm font-medium rounded bg-green-100 text-green-800">Published</span>
                    @else
                        <span class="px-3 py-1 text-sm font-medium rounded bg-gray-100 text-gray-800">Draft</span>
                    @endif
                </div>

                @if($assignment->description)
                    <div class="mb-4">
                        <h3 class="text-sm font-medium text-gray-700 mb-2">Description</h3>
                        <p class="text-gray-900">{{ $assignment->description }}</p>
                    </div>
                @endif

                @if($assignment->instructions)
                    <div class="mb-4">
                        <h3 class="text-sm font-medium text-gray-700 mb-2">Instructions</h3>
                        <div class="text-gray-900 whitespace-pre-wrap">{{ $assignment->instructions }}</div>
                    </div>
                @endif

                <!-- Regular Attachments -->
                @if($assignment->type !== 'practical' && $assignment->attachments && count($assignment->attachments) > 0)
                    <div class="mb-4">
                        <h3 class="text-sm font-medium text-gray-700 mb-2">Attachments</h3>
                        <div class="space-y-2">
                            @foreach($assignment->attachments as $index => $attachment)
                                <a href="{{ route('trainer.assignments.attachment.download', ['assignment' => $assignment->id, 'index' => $index]) }}" 
                                   class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50">
                                    <svg class="w-5 h-5 text-gray-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                    </svg>
                                    <span class="text-sm text-gray-900">{{ basename($attachment) }}</span>
                                </a>
                            @endforeach
                        </div>
                    </div>
                @endif

                <!-- Practical Tools -->
                @if($assignment->type === 'practical')
                    @if($assignment->candidate_tool && count($assignment->candidate_tool) > 0)
                        <div class="mb-4">
                            <h3 class="text-sm font-medium text-gray-700 mb-2">Candidate Tool</h3>
                            <div class="space-y-2">
                                @foreach($assignment->candidate_tool as $index => $tool)
                                    <a href="{{ route('trainer.assignments.attachment.download', ['assignment' => $assignment->id, 'index' => $index, 'toolType' => 'candidate']) }}" 
                                       class="flex items-center p-3 border border-blue-200 rounded-lg hover:bg-blue-50">
                                        <svg class="w-5 h-5 text-blue-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                        </svg>
                                        <span class="text-sm text-gray-900">{{ basename($tool) }}</span>
                                    </a>
                                @endforeach
                            </div>
                        </div>
                    @endif

                    @if($assignment->assessor_tool && count($assignment->assessor_tool) > 0)
                        <div class="mb-4">
                            <div class="flex items-center justify-between mb-2">
                                <h3 class="text-sm font-medium text-gray-700">Assessor Tool</h3>
                                <a href="{{ route('trainer.assessor-tool.create-structure', $assignment) }}" 
                                   class="text-xs text-blue-600 hover:text-blue-800 font-medium">
                                    Manage Structure
                                </a>
                            </div>
                            <div class="space-y-2">
                                @foreach($assignment->assessor_tool as $index => $tool)
                                    <a href="{{ route('trainer.assignments.attachment.download', ['assignment' => $assignment->id, 'index' => $index, 'toolType' => 'assessor']) }}" 
                                       class="flex items-center p-3 border border-purple-200 rounded-lg hover:bg-purple-50">
                                        <svg class="w-5 h-5 text-purple-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                        </svg>
                                        <span class="text-sm text-gray-900">{{ basename($tool) }}</span>
                                    </a>
                                @endforeach
                            </div>
                        </div>
                    @endif
                @endif
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Assignment Info -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Assignment Details</h3>
                <dl class="space-y-3">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Type</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ $assignment->getTypeLabel() }}</dd>
                    </div>
                    @if($assignment->total_marks)
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Total Marks</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $assignment->total_marks }}</dd>
                        </div>
                    @endif
                    @if($assignment->start_date)
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Start Date</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $assignment->start_date->format('M d, Y H:i') }}</dd>
                        </div>
                    @endif
                    @if($assignment->due_date)
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Due Date</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $assignment->due_date->format('M d, Y H:i') }}</dd>
                        </div>
                    @endif
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Status</dt>
                        <dd class="mt-1">
                            @if($assignment->is_published)
                                <span class="px-2 py-1 text-xs font-medium rounded bg-green-100 text-green-800">Published</span>
                            @else
                                <span class="px-2 py-1 text-xs font-medium rounded bg-gray-100 text-gray-800">Draft</span>
                            @endif
                        </dd>
                    </div>
                </dl>
            </div>

            <!-- Statistics -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Submissions</h3>
                <dl class="space-y-3">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Total Submissions</dt>
                        <dd class="mt-1 text-2xl font-semibold text-gray-900">{{ $submissionsCount }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Submitted</dt>
                        <dd class="mt-1 text-lg text-gray-900">{{ $submittedCount }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Graded</dt>
                        <dd class="mt-1 text-lg text-gray-900">{{ $gradedCount }}</dd>
                    </div>
                </dl>
                @if($assignment->type === 'practical')
                    <div class="mt-4 pt-4 border-t border-gray-200 space-y-2">
                        <a href="{{ route('trainer.assessor-tool.marking', $assignment) }}" 
                           class="block w-full text-center px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 text-sm font-medium">
                            Mark Assessor Tool
                        </a>
                        <a href="{{ route('trainer.practical-marks.index', $assignment) }}" 
                           class="block w-full text-center px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700 text-sm font-medium">
                            View Compiled Marks
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Submissions List -->
    @if($assignment->type !== 'practical' && isset($submissions) && $submissions->count() > 0)
        <div class="mt-6 bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200">
                <h2 class="text-lg font-semibold text-gray-900">Student Submissions</h2>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Student</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Admission No</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Submitted</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Marks</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($submissions as $submission)
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900">{{ $submission->student->name ?? 'N/A' }}</div>
                                    <div class="text-sm text-gray-500">{{ $submission->student->email ?? 'N/A' }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    {{ $submission->student->admission_number ?? 'N/A' }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $submission->submitted_at ? $submission->submitted_at->format('M d, Y H:i') : 'Not submitted' }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-2 py-1 text-xs rounded-full {{ $submission->getStatusBadgeClasses() }}">
                                        {{ ucfirst($submission->status) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    @if($submission->marks !== null)
                                        <span class="font-medium">{{ number_format($submission->marks, 2) }} / {{ $assignment->total_marks ?? 'N/A' }}</span>
                                    @else
                                        <span class="text-gray-400">Not graded</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                    <a href="{{ route('trainer.assignments.submissions.show', ['assignment' => $assignment->id, 'submission' => $submission->id]) }}" 
                                       class="text-blue-600 hover:text-blue-900">
                                        @if($submission->marks === null)
                                            Mark
                                        @else
                                            View/Edit
                                        @endif
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @elseif($assignment->type !== 'practical')
        <div class="mt-6 bg-white rounded-lg shadow p-8 text-center">
            <p class="text-sm text-gray-500">No submissions yet.</p>
        </div>
    @endif
        </div>
    </div>
</div>
@endsection

