<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Unit Marks Summary Report - {{ $unit->name }}</title>
    <style>
        @media print {
            @page {
                size: A4 landscape;
                margin: 15mm;
            }
            body {
                margin: 0;
            }
            .no-print {
                display: none !important;
            }
            button {
                display: none !important;
            }
            .page-break { 
                page-break-after: always; 
            }
        }
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Times New Roman', serif;
            font-size: 11pt;
            line-height: 1.4;
            color: #000;
            background: #fff;
            padding: 20px;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        h1, h2, h3 {
            margin: 5px 0;
        }
        .letterhead {
            border-bottom: 2px solid #000;
            padding-bottom: 8px;
            margin-bottom: 8px;
        }
        .letterhead-content {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 4px;
        }
        .logo-section {
            flex-shrink: 0;
        }
        .logo-section img {
            max-height: 80px;
            max-width: 120px;
            object-fit: contain;
        }
        .institution-info {
            width: 100%;
            text-align: center;
        }
        .institution-name {
            font-size: 18pt;
            font-weight: bold;
            text-transform: uppercase;
            margin-bottom: 2px;
            letter-spacing: 1px;
            text-align: center;
        }
        .department-name {
            font-size: 12pt;
            font-weight: bold;
            margin: 0 0 4px 0;
            text-transform: uppercase;
            text-align: center;
        }
        .institution-details {
            font-size: 8pt;
            color: #333;
            line-height: 1.4;
            text-align: center;
        }
        .report-title {
            text-align: center;
            font-size: 16pt;
            font-weight: bold;
            text-transform: uppercase;
            margin: 10px 0 8px;
            letter-spacing: 1px;
        }
        .metadata-section {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px 24px;
            margin-bottom: 12px;
            font-size: 9pt;
        }
        .metadata-column {
            padding: 0;
        }
        .metadata-item {
            display: flex;
            margin-bottom: 2px;
            line-height: 1.3;
        }
        .metadata-label {
            font-weight: bold;
            min-width: 120px;
            flex-shrink: 0;
            text-transform: uppercase;
            font-size: 8pt;
        }
        .metadata-value {
            flex: 1;
            font-size: 9pt;
        }
        .section-title {
            font-weight: bold;
            text-transform: uppercase;
            margin: 0 0 3px 0;
            padding: 0;
            font-size: 9pt;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }
        /* Table with full grid borders */
        table.report-table {
            border: 1px solid #000;
            margin: 10px auto;
            page-break-inside: auto;
        }
        table.report-table th,
        table.report-table td {
            border: 1px solid #000;
            padding: 6px 8px;
            text-align: center;
            vertical-align: middle;
        }
        td.number {
            text-align: center;
        }
        table.report-table thead th {
            font-weight: bold;
            text-align: center;
            background-color: #f5f5f5;
            font-size: 10pt;
            text-transform: uppercase;
        }
        .group-header {
            background-color: #c0c0c0 !important;
            font-weight: bold;
            font-size: 9pt;
        }
        .student-name-col {
            text-align: left;
            padding-left: 8px;
            min-width: 150px;
        }
        .admission-col {
            text-align: center;
            min-width: 100px;
        }
        .marks-col {
            text-align: center;
            min-width: 60px;
        }
        .percentage-col {
            text-align: center;
            min-width: 50px;
        }
        .category-average {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        .total-col {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        tbody tr {
            page-break-inside: avoid;
        }
        tbody tr:nth-child(even) {
            background-color: #f7f7f7;
        }
        tbody tr {
            min-height: 35px;
        }
        .signature-row {
            display: flex;
            justify-content: space-between;
            gap: 40px;
            margin-top: 40px;
            padding-top: 40px;
        }
        .content-wrapper {
            flex: 1;
            display: flex;
            flex-direction: column;
        }
        .signature-row div {
            width: 45%;
            font-size: 10pt;
        }
        .signature-row b {
            text-transform: uppercase;
        }
        .signature-row .signature-meta {
            margin-top: 8px;
        }
        .signature-row .signature-line-text {
            margin-top: 16px;
            font-size: 9pt;
        }
        .footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #000;
            text-align: center;
            font-size: 9px;
            color: #666;
        }
        .footer-warning {
            font-weight: bold;
            color: #000;
            margin-bottom: 5px;
            font-size: 9px;
        }
    </style>
</head>
<body>
    <div class="no-print" style="margin-bottom: 20px; text-align: right;">
        <button class="no-print" onclick="window.print()" style="padding: 10px 20px; background: #3b82f6; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 14px;">
            Print
        </button>
        <button class="no-print" onclick="window.close()" style="padding: 10px 20px; background: #6b7280; color: white; border: none; border-radius: 5px; cursor: pointer; margin-left: 10px; font-size: 14px;">
            Close
        </button>
    </div>

    <div class="content-wrapper">
        <!-- Letterhead -->
        <div class="letterhead">
            <div class="letterhead-content">
                @if(isset($institutionSettings['institution.logo']) && $institutionSettings['institution.logo'])
                    <div class="logo-section">
                        <img src="{{ asset('storage/' . $institutionSettings['institution.logo']) }}" alt="Institution Logo">
                    </div>
                @endif
                <div class="institution-info">
                    <div class="institution-name">
                        {{ $institutionSettings['institution.name'] ?? config('app.name', 'Technical and Vocational Education Training Institution') }}
                    </div>
                    <div class="department-name">
                        Department of {{ $unit->department->name ?? 'Computing' }}
                    </div>
                    @if(isset($institutionSettings['institution.address']) && $institutionSettings['institution.address'])
                        <div class="institution-details">
                            {{ $institutionSettings['institution.address'] }}
                            @if(isset($institutionSettings['institution.phone']) && $institutionSettings['institution.phone'])
                                | Tel: {{ $institutionSettings['institution.phone'] }}
                            @endif
                            @if(isset($institutionSettings['institution.email']) && $institutionSettings['institution.email'])
                                | Email: {{ $institutionSettings['institution.email'] }}
                            @endif
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">
            UNIT MARKS SUMMARY REPORT
        </div>

        <!-- Metadata: compact, no extra borders -->
        <div class="metadata-section">
            <div class="metadata-column">
                <div class="section-title">Unit Information</div>
                <div class="metadata-item"><span class="metadata-label">Department:</span><span class="metadata-value">{{ $unit->department->name ?? 'N/A' }}</span></div>
                <div class="metadata-item"><span class="metadata-label">Unit Name:</span><span class="metadata-value">{{ $unit->name }}</span></div>
                <div class="metadata-item"><span class="metadata-label">Unit Code:</span><span class="metadata-value">{{ $unit->code ?? 'N/A' }}</span></div>
            </div>
            <div class="metadata-column">
                <div class="section-title">Report Information</div>
                <div class="metadata-item"><span class="metadata-label">Academic Term:</span><span class="metadata-value">{{ $activeTerm->name ?? 'N/A' }}</span></div>
                @if(isset($selectedClass) && $selectedClass)
                    <div class="metadata-item"><span class="metadata-label">Class:</span><span class="metadata-value">{{ $selectedClass->name }}@if($selectedClass->code) ({{ $selectedClass->code }})@endif</span></div>
                @endif
                <div class="metadata-item"><span class="metadata-label">Total Students:</span><span class="metadata-value">{{ $students->count() }}</span></div>
                <div class="metadata-item"><span class="metadata-label">Total Assessments:</span><span class="metadata-value">{{ count($assignments) }}</span></div>
                <div class="metadata-item"><span class="metadata-label">Report Date:</span><span class="metadata-value">{{ now()->format('d M Y, h:i A') }}</span></div>
            </div>
        </div>

        @if(count($assignments) > 0 && $students->count() > 0)
        @php
            // Grouped assignments by category
            $practicals = $groupedAssignments['practical'] ?? [];
            $theories = $groupedAssignments['theory'] ?? [];
            $projects = $groupedAssignments['project'] ?? [];

            $practicalCount = count($practicals);
            $theoryCount = count($theories);
            $projectCount = count($projects);
        @endphp

        @if($practicalCount > 0 || $theoryCount > 0 || $projectCount > 0)
        <table class="report-table" style="border: 1px solid #000;">
            <thead>
                <tr>
                    <th rowspan="2" style="width: 30px;">#</th>
                    <th rowspan="2" class="student-name-col">NAME</th>
                    <th rowspan="2" class="admission-col">ADMIN</th>
                    @for($i = 1; $i <= $practicalCount; $i++)
                        <th colspan="2" class="group-header">PRACTICAL {{ $i }}</th>
                    @endfor
                    @if($theoryCount > 0)
                        <th colspan="{{ $theoryCount }}" class="group-header" style="border-left: 1px solid #000;">THEORY</th>
                    @endif
                    @if($projectCount > 0)
                        <th colspan="{{ $projectCount }}" class="group-header" style="border-left: 1px solid #000;">PROJECTS</th>
                    @endif
                    <th colspan="3" class="group-header" style="border-left: 1px solid #000;">AVERAGE (P / O / E)</th>
                </tr>
                <tr>
                    @for($i = 1; $i <= $practicalCount; $i++)
                        <th class="marks-col">P{{ $i }}</th>
                        <th class="marks-col">O{{ $i }}</th>
                    @endfor
                    @for($i = 1; $i <= $theoryCount; $i++)
                        <th class="marks-col" @if($i === 1) style="border-left: 1px solid #000;" @endif>T{{ $i }}</th>
                    @endfor
                    @for($i = 1; $i <= $projectCount; $i++)
                        <th class="marks-col" @if($i === 1 && $theoryCount === 0) style="border-left: 1px solid #000;" @endif>PR{{ $i }}</th>
                    @endfor
                    <th class="marks-col" style="border-left: 1px solid #000;">Pav</th>
                    <th class="marks-col">Oav</th>
                    <th class="marks-col">Eav</th>
                </tr>
            </thead>
            <tbody>
                @foreach($students as $index => $student)
                    @php
                        $theoryPercents = [];
                        $projectPercents = [];
                    @endphp
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td class="student-name-col">{{ $student->name }}</td>
                        <td class="admission-col">{{ $student->admission_number ?? '' }}</td>

                        {{-- Practical / Oral columns --}}
                        @for($i = 1; $i <= $practicalCount; $i++)
                            @php
                                $pDisplay = '—';
                                $oDisplay = '—';
                                $entry = $practicalUnitPercents[$student->id][$i-1] ?? null;

                                if ($entry) {
                                    $pPercent = $entry['P'] ?? null;
                                    $oPercent = $entry['O'] ?? null;

                                    if (!is_null($pPercent)) {
                                        $pDisplay = number_format($pPercent, 0);
                                    }
                                    if (!is_null($oPercent)) {
                                        $oDisplay = number_format($oPercent, 0);
                                    }
                                }
                            @endphp
                            <td class="marks-col">{{ $pDisplay }}</td>
                            <td class="marks-col">{{ $oDisplay }}</td>
                        @endfor

                        {{-- Exam (theory) columns --}}
                        @for($i = 1; $i <= $theoryCount; $i++)
                            @php
                                $tDisplay = '—';
                                if(isset($theories[$i-1])) {
                                    $a = $theories[$i-1];
                                    $data = $marksData[$student->id][$a->id] ?? null;
                                    $status = $data['status'] ?? 'not_marked';
                                    $percent = $data['percentage'] ?? null;
                                    if ($status === 'absent') {
                                        $tDisplay = 'AB';
                                    } elseif ($percent !== null) {
                                        $tDisplay = number_format($percent, 0);
                                        $theoryPercents[] = $percent;
                                    }
                                }
                            @endphp
                            <td class="marks-col" @if($i === 1) style="border-left: 1px solid #000;" @endif>{{ $tDisplay }}</td>
                        @endfor

                        {{-- Project columns --}}
                        @for($i = 1; $i <= $projectCount; $i++)
                            @php
                                $prDisplay = '—';
                                if(isset($projects[$i-1])) {
                                    $a = $projects[$i-1];
                                    $data = $marksData[$student->id][$a->id] ?? null;
                                    $status = $data['status'] ?? 'not_marked';
                                    $percent = $data['percentage'] ?? null;
                                    if ($status === 'absent') {
                                        $prDisplay = 'AB';
                                    } elseif ($percent !== null) {
                                        $prDisplay = number_format($percent, 0);
                                        $projectPercents[] = $percent;
                                    }
                                }
                            @endphp
                            <td class="marks-col" @if($i === 1 && $theoryCount === 0) style="border-left: 1px solid #000;" @endif>{{ $prDisplay }}</td>
                        @endfor

                        @php
                            $pAvg = $practicalUnitAverages[$student->id]['Pav'] ?? null;
                            $oAvg = $practicalUnitAverages[$student->id]['Oav'] ?? null;
                            $eAvg = count($theoryPercents) > 0 ? array_sum($theoryPercents) / count($theoryPercents) : null;
                        @endphp
                        <td class="marks-col" style="border-left: 1px solid #000;">
                            @if($pAvg !== null)
                                {{ number_format($pAvg, 0) }}
                            @else
                                —
                            @endif
                        </td>
                        <td class="marks-col">
                            @if($oAvg !== null)
                                {{ number_format($oAvg, 0) }}
                            @else
                                —
                            @endif
                        </td>
                        <td class="marks-col">
                            @if($eAvg !== null)
                                {{ number_format($eAvg, 0) }}
                            @else
                                —
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
        @else
            <div style="text-align: center; padding: 40px; color: #666;">
                <p>No practical/oral assessments found for this unit.</p>
            </div>
        @endif
        @else
            <div style="text-align: center; padding: 40px; color: #666;">
                <p>No data available for this unit.</p>
            </div>
        @endif
    </div>

    <!-- Signatures -->
    <div class="signature-row">
        <div>
            <b>Trainer / Assessor</b>
            <div class="signature-meta">
                Name: {{ $trainer->name ?? '_____________________' }}
            </div>
            <div class="signature-line-text">
                Signature: _____________ &nbsp;&nbsp;&nbsp; Date: _______
            </div>
        </div>
        <div>
            <b>Head of Department / Verifier</b>
            <div class="signature-meta">
                Name: _____________________
            </div>
            <div class="signature-line-text">
                Signature: _____________ &nbsp;&nbsp;&nbsp; Date: _______
            </div>
        </div>
    </div>

    <!-- Footer -->
    <div class="footer">
        <div class="footer-warning">
            SYSTEM GENERATED REPORT – NO ALTERATIONS ALLOWED
        </div>
        <div>
            Generated on {{ now()->format('d M Y, h:i A') }} | {{ $institutionSettings['institution.footer_text'] ?? config('app.name', 'e-PoE System') }}
        </div>
    </div>
</body>
</html>
