@extends('layouts.trainer')

@section('title', 'Notification Details')

@section('content')
    <div class="mb-6">
        <a href="{{ route('trainer.messages.index') }}" class="text-blue-600 hover:text-blue-900">
            ← Back to Messages
        </a>
    </div>

    <div class="bg-white shadow rounded-lg p-6">
        <h2 class="text-xl font-semibold text-gray-900 mb-4">{{ $notification->data['title'] ?? 'Notification' }}</h2>
        <div class="prose max-w-none">
            <p class="text-gray-900">{{ $notification->data['message'] ?? '' }}</p>
        </div>
        <div class="mt-4 pt-4 border-t">
            <p class="text-sm text-gray-500">Received: {{ $notification->created_at->format('M d, Y H:i') }}</p>
        </div>
    </div>
@endsection

