@extends('layouts.trainer')

@section('title', 'Review Portfolio Evidence Task')

@section('content')
    <div class="mb-6">
        <a href="{{ route('trainer.portfolio-evidence.index') }}" class="text-indigo-600 hover:text-indigo-900 flex items-center">
            <svg class="h-5 w-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
            </svg>
            Back to Tasks
        </a>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Content -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Task Information -->
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">Task Information</h3>
                </div>
                <div class="px-6 py-4">
                    <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Student</dt>
                            <dd class="mt-1 text-sm text-gray-900 font-medium">{{ $task->student->name }}</dd>
                            <dd class="text-xs text-gray-500">{{ $task->student->email }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Unit</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                <div class="font-medium">{{ $task->unit->name }}</div>
                                @if($task->unit->code)
                                    <div class="text-xs text-gray-500">{{ $task->unit->code }}</div>
                                @endif
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Task Name</dt>
                            <dd class="mt-1 text-sm text-gray-900 font-medium">{{ $task->task_name }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Status</dt>
                            <dd class="mt-1">
                                <span class="px-3 py-1 text-sm font-semibold rounded-full {{ $task->getStatusBadgeClasses() }}">
                                    {{ $task->getStatusLabel() }}
                                </span>
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Number of Files</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $evidenceFiles->count() }} file(s)</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Submitted At</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $task->submitted_at->format('M d, Y h:i A') }}</dd>
                        </div>
                        @if($task->reviewed_at)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Reviewed At</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $task->reviewed_at->format('M d, Y h:i A') }}</dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Reviewed By</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $task->reviewer->name ?? 'N/A' }}</dd>
                            </div>
                        @endif
                    </dl>
                    @if($task->trainer_comment)
                        <div class="mt-4 pt-4 border-t border-gray-200">
                            <dt class="text-sm font-medium text-gray-500 mb-1">Trainer Comment</dt>
                            <dd class="text-sm text-gray-900 bg-gray-50 p-3 rounded">{{ $task->trainer_comment }}</dd>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Evidence Files Gallery -->
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">
                        Evidence Files ({{ $evidenceFiles->count() }})
                    </h3>
                </div>
                <div class="px-6 py-4 space-y-6">
                    @foreach($evidenceFiles as $index => $evidence)
                        <div class="border border-gray-200 rounded-lg p-4 {{ $loop->first ? 'bg-indigo-50 border-indigo-300' : '' }}">
                            <div class="flex items-center justify-between mb-3">
                                <div class="flex items-center gap-2">
                                    <span class="px-2 py-1 text-xs font-semibold rounded-full 
                                        @if($evidence->isVideo()) bg-red-100 text-red-800
                                        @elseif($evidence->isImage()) bg-green-100 text-green-800
                                        @elseif($evidence->isAudio()) bg-purple-100 text-purple-800
                                        @else bg-blue-100 text-blue-800
                                        @endif">
                                        {{ ucfirst($evidence->evidence_type) }}
                                    </span>
                                    <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $evidence->getStatusBadgeClasses() }}">
                                        {{ $evidence->getStatusLabel() }}
                                    </span>
                                </div>
                                <div class="text-xs text-gray-500">
                                    {{ $evidence->uploaded_at->format('M d, Y h:i A') }}
                                </div>
                            </div>
                            
                            @if($evidence->isVideo())
                                <video controls class="w-full rounded-lg" style="max-height: 400px;">
                                    <source src="{{ Storage::url($evidence->file_path) }}" type="{{ $evidence->mime_type }}">
                                    Your browser does not support the video tag.
                                </video>
                            @elseif($evidence->isImage())
                                <img src="{{ Storage::url($evidence->file_path) }}" alt="{{ $evidence->task_name }}" class="w-full rounded-lg" style="max-height: 400px; object-fit: contain;">
                            @elseif($evidence->isAudio())
                                <audio controls class="w-full">
                                    <source src="{{ Storage::url($evidence->file_path) }}" type="{{ $evidence->mime_type }}">
                                    Your browser does not support the audio tag.
                                </audio>
                            @else
                                <div class="text-center py-8 bg-gray-50 rounded-lg">
                                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                    </svg>
                                    <p class="mt-2 text-sm text-gray-500">Document file</p>
                                </div>
                            @endif
                            
                            <div class="mt-4 flex items-center justify-between">
                                <div>
                                    <p class="text-sm font-medium text-gray-900">{{ $evidence->original_name }}</p>
                                    <p class="text-xs text-gray-500">{{ $evidence->file_size_human ?? number_format($evidence->file_size / 1024, 2) . ' KB' }}</p>
                                </div>
                                <a href="{{ route('trainer.portfolio-evidence.download', $evidence) }}" class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 text-sm font-medium">
                                    Download
                                </a>
                            </div>
                            
                            @if($evidence->notes)
                                <div class="mt-3 pt-3 border-t border-gray-200">
                                    <p class="text-xs font-medium text-gray-500 mb-1">Student Notes:</p>
                                    <p class="text-sm text-gray-700 bg-gray-50 p-2 rounded">{{ $evidence->notes }}</p>
                                </div>
                            @endif
                        </div>
                    @endforeach
                </div>
            </div>

            <!-- Comments -->
            @if($allComments->count() > 0)
                <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <h3 class="text-lg font-semibold text-gray-900">Comments ({{ $allComments->count() }})</h3>
                    </div>
                    <div class="px-6 py-4 space-y-4">
                        @foreach($allComments as $comment)
                            <div class="border-l-4 border-indigo-500 pl-4 py-2">
                                <div class="flex justify-between items-start mb-2">
                                    <div>
                                        <p class="font-medium text-gray-900">{{ $comment->user->name ?? 'Unknown' }}</p>
                                        <p class="text-xs text-gray-500">{{ $comment->created_at->format('M d, Y h:i A') }}</p>
                                    </div>
                                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-indigo-100 text-indigo-800">
                                        {{ ucfirst($comment->role) }}
                                    </span>
                                </div>
                                <p class="text-sm text-gray-700">{{ $comment->comment }}</p>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Update Status -->
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">Review Task</h3>
                </div>
                <div class="px-6 py-4">
                    <form action="{{ route('trainer.portfolio-evidence.update-status', $task) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="space-y-4">
                            <div>
                                <label for="status" class="block text-sm font-medium text-gray-700 mb-2">Status</label>
                                <select name="status" id="status" required class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    <option value="under_review" {{ $task->status === 'under_review' ? 'selected' : '' }}>Under Review</option>
                                    <option value="accepted" {{ $task->status === 'accepted' ? 'selected' : '' }}>Accepted</option>
                                    <option value="rejected" {{ $task->status === 'rejected' ? 'selected' : '' }}>Rejected</option>
                                    <option value="needs_correction" {{ $task->status === 'needs_correction' ? 'selected' : '' }}>Needs Correction</option>
                                </select>
                                <p class="mt-1 text-xs text-gray-500">This will update all files in this task</p>
                            </div>
                            <div>
                                <label for="comment" class="block text-sm font-medium text-gray-700 mb-2">Comment (Optional)</label>
                                <textarea name="comment" id="comment" rows="4" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" placeholder="Add your feedback for this task...">{{ $task->trainer_comment }}</textarea>
                                <p class="mt-1 text-xs text-gray-500">This comment will apply to all files in the task</p>
                            </div>
                            <button type="submit" class="w-full px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 text-sm font-medium">
                                Update Task Status
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
