<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Unit Summary Marks – {{ $validationRequest->unit->name }}</title>
    <style>
        @media print {
            .no-print { display: none !important; }
            body { margin: 0; }
        }
        body { font-family: Arial, sans-serif; font-size: 11pt; padding: 20px; }
        .letterhead { border-bottom: 2px solid #000; padding-bottom: 8px; margin-bottom: 12px; }
        .institution-name { font-size: 16pt; font-weight: bold; text-align: center; }
        .report-title { font-size: 14pt; font-weight: bold; text-align: center; margin: 12px 0; }
        .meta { font-size: 10pt; margin-bottom: 12px; }
        table { width: 100%; border-collapse: collapse; font-size: 10pt; }
        th, td { border: 1px solid #000; padding: 6px 8px; }
        th { background: #f0f0f0; font-weight: bold; }
        .text-left { text-align: left; }
        .text-center { text-align: center; }
        .total-col { font-weight: bold; background: #f5f5f5; }
    </style>
</head>
<body>
    <div class="no-print" style="margin-bottom: 16px;">
        <button type="button" onclick="window.print()" style="padding: 8px 16px; background: #4f46e5; color: white; border: none; border-radius: 6px; cursor: pointer;">Print / Save as PDF</button>
        <a href="{{ route('validator.validation-requests.show', ['class' => $validationRequest->class_id, 'unit' => $validationRequest->unit_id]) }}" style="margin-left: 8px; padding: 8px 16px; background: #e5e7eb; color: #374151; text-decoration: none; border-radius: 6px;">Back to Validation</a>
    </div>

    <div class="letterhead">
        <div class="institution-name">{{ $institutionSettings['institution.name'] ?? config('app.name') }}</div>
    </div>

    <h1 class="report-title">Unit Summary Marks – Validator Preview</h1>

    <div class="meta">
        <strong>Unit:</strong> {{ $validationRequest->unit->name }} ({{ $validationRequest->unit->code }})<br>
        <strong>Class:</strong> {{ $validationRequest->schoolClass->name }} ({{ $validationRequest->schoolClass->code }})<br>
        <strong>Term:</strong> {{ $activeTerm->name }}<br>
        <strong>Submitted by:</strong> {{ $validationRequest->submitter->name ?? '—' }} on {{ $validationRequest->submitted_at->format('M d, Y H:i') }}
    </div>

    <table>
        <thead>
            <tr>
                <th class="text-left">#</th>
                <th class="text-left">Student</th>
                <th class="text-center">Admission No</th>
                @foreach($assignments as $a)
                    <th class="text-center">{{ Str::limit($a->title, 15) }}<br><span style="font-size: 8pt;">({{ ucfirst($a->type) }})</span></th>
                @endforeach
                <th class="text-center total-col">Total %</th>
            </tr>
        </thead>
        <tbody>
            @foreach($students as $idx => $student)
                @php $data = $marksData[$student->id] ?? null; @endphp
                <tr>
                    <td class="text-center">{{ $idx + 1 }}</td>
                    <td class="text-left">{{ $student->name }}</td>
                    <td class="text-center">{{ $student->admission_number ?? '—' }}</td>
                    @foreach($assignments as $assignment)
                        @php
                            $cell = $data['marks'][$assignment->id] ?? null;
                            $mark = $cell['marks'] ?? null;
                            $status = $cell['status'] ?? null;
                        @endphp
                        <td class="text-center">
                            @if($mark !== null)
                                {{ number_format($mark, 1) }}{{ $assignment->total_marks ? '/' . $assignment->total_marks : '' }}
                                @if($status === 'absent') <span style="font-size: 8pt;">(Absent)</span> @endif
                            @else
                                —
                            @endif
                        </td>
                    @endforeach
                    <td class="text-center total-col">{{ $data ? number_format($data['percentage'], 1) . '%' : '—' }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
