<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Consolidated Class Marks - <?php echo e($class->name); ?></title>
    <style>
        @media print {
            .no-print { display: none; }
            body { margin: 0; padding: 0; }
            .page-break { page-break-after: always; }
            @page {
                size: A4 landscape;
                margin: 10mm;
            }
        }
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Times New Roman', serif;
            font-size: 10pt;
            line-height: 1.4;
            color: #000;
            background: #fff;
            padding: 20px;
        }
        .letterhead {
            border-bottom: 3px solid #000;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        .letterhead-content {
            display: flex;
            align-items: flex-start;
            gap: 20px;
        }
        .logo-section {
            flex-shrink: 0;
        }
        .logo-section img {
            max-height: 80px;
            max-width: 120px;
            object-fit: contain;
        }
        .institution-info {
            flex: 1;
        }
        .institution-name {
            font-size: 16pt;
            font-weight: bold;
            text-transform: uppercase;
            margin-bottom: 5px;
            letter-spacing: 1px;
        }
        .department-name {
            font-size: 12pt;
            font-weight: bold;
            margin-bottom: 8px;
            text-transform: uppercase;
        }
        .institution-details {
            font-size: 9pt;
            color: #333;
            line-height: 1.6;
        }
        .report-title {
            text-align: center;
            font-size: 14pt;
            font-weight: bold;
            text-transform: uppercase;
            margin: 20px 0;
            padding: 10px;
            background-color: #f5f5f5;
            border: 2px solid #000;
        }
        .metadata-section {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
            margin-bottom: 20px;
            padding: 15px;
            background-color: #fafafa;
            border: 1px solid #ddd;
        }
        .metadata-item {
            display: flex;
            margin-bottom: 8px;
        }
        .metadata-label {
            font-weight: bold;
            min-width: 120px;
            text-transform: uppercase;
            font-size: 9pt;
        }
        .metadata-value {
            flex: 1;
            font-size: 10pt;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            font-size: 9pt;
            page-break-inside: auto;
        }
        th, td {
            border: 1px solid #000;
            padding: 6px 4px;
            text-align: center;
            vertical-align: middle;
        }
        th {
            background-color: #e0e0e0;
            font-weight: bold;
            font-size: 8pt;
            text-transform: uppercase;
        }
        .student-name-col {
            text-align: left;
            padding-left: 8px;
            min-width: 150px;
        }
        .admission-col {
            text-align: center;
            min-width: 100px;
        }
        .unit-col {
            text-align: center;
            min-width: 80px;
        }
        tbody tr {
            page-break-inside: avoid;
        }
        tbody tr:nth-child(even) {
            background-color: #fafafa;
        }
        .footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #000;
            text-align: center;
            font-size: 8pt;
            color: #666;
        }
        .footer-warning {
            font-weight: bold;
            color: #000;
            margin-bottom: 5px;
        }
    </style>
</head>
<body>
    <div class="no-print" style="margin-bottom: 20px; text-align: right;">
        <button onclick="window.print()" style="padding: 10px 20px; background: #3b82f6; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 14px;">
            Print
        </button>
        <button onclick="window.close()" style="padding: 10px 20px; background: #6b7280; color: white; border: none; border-radius: 5px; cursor: pointer; margin-left: 10px; font-size: 14px;">
            Close
        </button>
    </div>

    <!-- Letterhead -->
    <div class="letterhead">
        <div class="letterhead-content">
            <?php if(isset($institutionSettings['institution.logo']) && $institutionSettings['institution.logo']): ?>
                <div class="logo-section">
                    <img src="<?php echo e(asset('storage/' . $institutionSettings['institution.logo'])); ?>" alt="Institution Logo">
                </div>
            <?php endif; ?>
            <div class="institution-info">
                <div class="institution-name">
                    <?php echo e($institutionSettings['institution.name'] ?? config('app.name', 'Technical and Vocational Education Training Institution')); ?>

                </div>
                <div class="department-name">
                    <?php echo e($class->department->name ?? 'Department'); ?>

                </div>
                <?php if(isset($institutionSettings['institution.address']) && $institutionSettings['institution.address']): ?>
                    <div class="institution-details">
                        <?php echo e($institutionSettings['institution.address']); ?>

                        <?php if(isset($institutionSettings['institution.phone']) && $institutionSettings['institution.phone']): ?>
                            | Tel: <?php echo e($institutionSettings['institution.phone']); ?>

                        <?php endif; ?>
                        <?php if(isset($institutionSettings['institution.email']) && $institutionSettings['institution.email']): ?>
                            | Email: <?php echo e($institutionSettings['institution.email']); ?>

                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Report Title -->
    <div class="report-title">
        CONSOLIDATED CLASS MARKS REPORT
    </div>

    <!-- Metadata Section -->
    <div class="metadata-section">
        <div>
            <div class="metadata-item">
                <span class="metadata-label">Class Name:</span>
                <span class="metadata-value"><?php echo e($class->name); ?></span>
            </div>
            <div class="metadata-item">
                <span class="metadata-label">Class Code:</span>
                <span class="metadata-value"><?php echo e($class->code); ?></span>
            </div>
            <div class="metadata-item">
                <span class="metadata-label">Department:</span>
                <span class="metadata-value"><?php echo e($class->department->name ?? 'N/A'); ?></span>
            </div>
        </div>
        <div>
            <div class="metadata-item">
                <span class="metadata-label">Academic Term:</span>
                <span class="metadata-value"><?php echo e($activeTerm->name ?? 'N/A'); ?></span>
            </div>
            <div class="metadata-item">
                <span class="metadata-label">Level:</span>
                <span class="metadata-value"><?php echo e($class->level->name ?? 'N/A'); ?></span>
            </div>
            <div class="metadata-item">
                <span class="metadata-label">Total Students:</span>
                <span class="metadata-value"><?php echo e($students->count()); ?></span>
            </div>
            <div class="metadata-item">
                <span class="metadata-label">Total Units:</span>
                <span class="metadata-value"><?php echo e($units->count()); ?></span>
            </div>
            <div class="metadata-item">
                <span class="metadata-label">Report Date:</span>
                <span class="metadata-value"><?php echo e(now()->format('d M Y, h:i A')); ?></span>
            </div>
        </div>
    </div>

    <?php if($units->count() > 0 && $students->count() > 0): ?>
        <table>
            <thead>
                <tr>
                    <th style="width: 30px;">#</th>
                    <th class="student-name-col">NAME</th>
                    <th class="admission-col">ADMIN</th>
                    <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th class="unit-col"><?php echo e(strtoupper($unit->name)); ?></th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $studentMarks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($index + 1); ?></td>
                        <td class="student-name-col"><?php echo e($row['student']->name); ?></td>
                        <td class="admission-col"><?php echo e($row['student']->admission_number ?? 'N/A'); ?></td>
                        <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td class="unit-col">
                                <?php if(isset($row['units'][$unit->id]) && $row['units'][$unit->id]['average'] !== null): ?>
                                    <?php echo e(number_format($row['units'][$unit->id]['average'], 2)); ?>

                                <?php else: ?>
                                    —
                                <?php endif; ?>
                            </td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    <?php else: ?>
        <div style="text-align: center; padding: 40px; color: #666;">
            <p>No data available for this class.</p>
        </div>
    <?php endif; ?>

    <!-- Footer -->
    <div class="footer">
        <div class="footer-warning">
            SYSTEM GENERATED REPORT – NO ALTERATIONS ALLOWED
        </div>
        <div>
            Generated on <?php echo e(now()->format('d M Y, h:i A')); ?> | <?php echo e($institutionSettings['institution.footer_text'] ?? config('app.name', 'e-PoE System')); ?>

        </div>
    </div>
</body>
</html>

<?php /**PATH D:\poe\resources\views/hod/marks/print-class.blade.php ENDPATH**/ ?>