<?php $__env->startSection('title', isset($evidence) ? 'Practical Evidence Details' : 'Submission Details'); ?>
<?php $__env->startSection('page-title', isset($evidence) ? 'Practical Evidence Details' : 'Submission Details'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-4 sm:mb-6">
        <a href="<?php echo e(route('student.submissions.index')); ?>" class="text-indigo-600 hover:text-indigo-900 flex items-center touch-manipulation">
            <svg class="h-5 w-5 mr-1 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
            </svg>
            Back to Portfolio Evidence
        </a>
    </div>

    <?php if(isset($evidence)): ?>
        <!-- Practical Evidence View -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 sm:gap-6">
            <!-- Main Content -->
            <div class="lg:col-span-2 space-y-4 sm:space-y-6">
                <!-- Evidence Info -->
                <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                    <div class="px-4 sm:px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <h3 class="text-base sm:text-lg font-semibold text-gray-900">Practical Evidence Information</h3>
                    </div>
                    <div class="px-4 sm:px-6 py-4">
                        <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Unit</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    <div class="font-medium"><?php echo e($evidence->unit->name); ?></div>
                                    <?php if($evidence->unit->code): ?>
                                        <div class="text-xs text-gray-500"><?php echo e($evidence->unit->code); ?></div>
                                    <?php endif; ?>
                                </dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Class</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    <div class="font-medium"><?php echo e($evidence->schoolClass->name); ?></div>
                                    <?php if($evidence->schoolClass->code): ?>
                                        <div class="text-xs text-gray-500"><?php echo e($evidence->schoolClass->code); ?></div>
                                    <?php endif; ?>
                                </dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Task Name</dt>
                                <dd class="mt-1 text-sm text-gray-900 font-medium"><?php echo e($evidence->task_name); ?></dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Evidence Type</dt>
                                <dd class="mt-1">
                                    <span class="px-2 py-1 text-xs font-semibold rounded-full 
                                        <?php if($evidence->isVideo()): ?> bg-red-100 text-red-800
                                        <?php elseif($evidence->isImage()): ?> bg-green-100 text-green-800
                                        <?php elseif($evidence->isAudio()): ?> bg-purple-100 text-purple-800
                                        <?php else: ?> bg-blue-100 text-blue-800
                                        <?php endif; ?>">
                                        <?php echo e(ucfirst($evidence->evidence_type)); ?>

                                    </span>
                                </dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Status</dt>
                                <dd class="mt-1">
                                    <?php
                                        $statusValues = $allTaskEvidence->pluck('status')->unique()->values();
                                        $statusLabel = $statusValues->count() === 1 ? $evidence->getStatusLabel() : 'Mixed';
                                        $statusClasses = $statusValues->count() === 1 
                                            ? $evidence->getStatusBadgeClasses() 
                                            : 'bg-yellow-100 text-yellow-800';
                                    ?>
                                    <span class="px-3 py-1 text-sm font-semibold rounded-full <?php echo e($statusClasses); ?>">
                                        <?php echo e($statusLabel); ?>

                                    </span>
                                    <?php if($allTaskEvidence->count() > 1): ?>
                                        <p class="text-xs text-gray-500 mt-1">
                                            <?php echo e($allTaskEvidence->count()); ?> files
                                        </p>
                                    <?php endif; ?>
                                </dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Uploaded At</dt>
                                <dd class="mt-1 text-sm text-gray-900"><?php echo e($evidence->uploaded_at->format('M d, Y h:i A')); ?></dd>
                            </div>
                        </dl>
                        <?php if($evidence->notes): ?>
                            <div class="mt-4 pt-4 border-t border-gray-200">
                                <dt class="text-sm font-medium text-gray-500 mb-1">Notes</dt>
                                <dd class="text-sm text-gray-900 bg-gray-50 p-3 rounded"><?php echo e($evidence->notes); ?></dd>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Media Preview - All files for this task -->
                <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <h3 class="text-lg font-semibold text-gray-900">
                            Media Evidence 
                            <?php if($allTaskEvidence->count() > 1): ?>
                                <span class="ml-2 text-sm font-normal text-gray-600">(<?php echo e($allTaskEvidence->count()); ?> files)</span>
                            <?php endif; ?>
                        </h3>
                    </div>
                    <div class="px-6 py-4 space-y-6">
                        <?php $__currentLoopData = $allTaskEvidence; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $taskEvidence): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="border border-gray-200 rounded-lg p-4 <?php echo e($loop->first ? 'bg-indigo-50 border-indigo-300' : ''); ?>">
                                <div class="flex items-center justify-between mb-3">
                                    <div class="flex items-center gap-2">
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full 
                                            <?php if($taskEvidence->isVideo()): ?> bg-red-100 text-red-800
                                            <?php elseif($taskEvidence->isImage()): ?> bg-green-100 text-green-800
                                            <?php elseif($taskEvidence->isAudio()): ?> bg-purple-100 text-purple-800
                                            <?php else: ?> bg-blue-100 text-blue-800
                                            <?php endif; ?>">
                                            <?php echo e(ucfirst($taskEvidence->evidence_type)); ?>

                                        </span>
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full <?php echo e($taskEvidence->getStatusBadgeClasses()); ?>">
                                            <?php echo e($taskEvidence->getStatusLabel()); ?>

                                        </span>
                                        <?php if($loop->first): ?>
                                            <span class="px-2 py-1 text-xs font-semibold rounded-full bg-indigo-100 text-indigo-800">
                                                Current
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="text-xs text-gray-500">
                                        <?php echo e($taskEvidence->uploaded_at->format('M d, Y h:i A')); ?>

                                    </div>
                                </div>
                                
                                <?php if($taskEvidence->isVideo()): ?>
                                    <video controls class="w-full rounded-lg" style="max-height: 400px;">
                                        <source src="<?php echo e(Storage::url($taskEvidence->file_path)); ?>" type="<?php echo e($taskEvidence->mime_type); ?>">
                                        Your browser does not support the video tag.
                                    </video>
                                <?php elseif($taskEvidence->isImage()): ?>
                                    <img src="<?php echo e(Storage::url($taskEvidence->file_path)); ?>" alt="<?php echo e($taskEvidence->task_name); ?>" class="w-full rounded-lg" style="max-height: 400px; object-fit: contain;">
                                <?php elseif($taskEvidence->isAudio()): ?>
                                    <audio controls class="w-full">
                                        <source src="<?php echo e(Storage::url($taskEvidence->file_path)); ?>" type="<?php echo e($taskEvidence->mime_type); ?>">
                                        Your browser does not support the audio tag.
                                    </audio>
                                <?php else: ?>
                                    <?php
                                        $fileUrl = Storage::url($taskEvidence->file_path);
                                        $isPdf = strtolower(pathinfo($taskEvidence->file_path, PATHINFO_EXTENSION)) === 'pdf';
                                    ?>
                                    <?php if($isPdf): ?>
                                        <iframe src="<?php echo e($fileUrl); ?>#toolbar=1" class="w-full rounded border border-gray-200 bg-white" style="height: 400px;" title="PDF preview"></iframe>
                                    <?php endif; ?>
                                <?php endif; ?>
                                
                                <div class="mt-4 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3">
                                    <div>
                                        <p class="text-sm font-medium text-gray-900"><?php echo e($taskEvidence->original_name); ?></p>
                                        <p class="text-xs text-gray-500"><?php echo e($taskEvidence->file_size_human ?? number_format($taskEvidence->file_size / 1024, 2) . ' KB'); ?></p>
                                    </div>
                                    <div class="flex flex-wrap gap-2">
                                        <a href="<?php echo e(Storage::url($taskEvidence->file_path)); ?>" target="_blank" rel="noopener noreferrer" class="inline-flex items-center justify-center px-4 py-2.5 min-h-[44px] bg-indigo-600 text-white rounded-md hover:bg-indigo-700 text-sm font-medium touch-manipulation">
                                            <svg class="w-4 h-4 mr-1.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path></svg>
                                            Preview
                                        </a>
                                        <a href="<?php echo e(Storage::url($taskEvidence->file_path)); ?>" download class="inline-flex items-center justify-center px-4 py-2.5 min-h-[44px] border border-gray-300 bg-white text-gray-700 rounded-md hover:bg-gray-50 text-sm font-medium touch-manipulation">
                                            <svg class="w-4 h-4 mr-1.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path></svg>
                                            Download
                                        </a>
                                    </div>
                                </div>
                                
                                <?php if($taskEvidence->notes && $taskEvidence->notes !== $evidence->notes): ?>
                                    <div class="mt-3 pt-3 border-t border-gray-200">
                                        <p class="text-xs font-medium text-gray-500 mb-1">Notes for this file:</p>
                                        <p class="text-sm text-gray-700 bg-gray-50 p-2 rounded"><?php echo e($taskEvidence->notes); ?></p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <!-- Comments - Show comments from all files in this task -->
                <?php
                    $allComments = $allTaskEvidence->flatMap->comments->sortBy('created_at');
                ?>
                <?php if($allComments->count() > 0): ?>
                    <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                        <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                            <h3 class="text-lg font-semibold text-gray-900">Comments (<?php echo e($allComments->count()); ?>)</h3>
                        </div>
                        <div class="px-6 py-4 space-y-4">
                            <?php $__currentLoopData = $allComments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="border-l-4 border-indigo-500 pl-4 py-2">
                                    <div class="flex justify-between items-start mb-2">
                                        <div>
                                            <p class="font-medium text-gray-900"><?php echo e($comment->user->name ?? 'Unknown'); ?></p>
                                            <p class="text-xs text-gray-500"><?php echo e($comment->created_at->format('M d, Y h:i A')); ?></p>
                                        </div>
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full bg-indigo-100 text-indigo-800">
                                            <?php echo e(ucfirst($comment->role)); ?>

                                        </span>
                                    </div>
                                    <p class="text-sm text-gray-700"><?php echo e($comment->comment); ?></p>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Sidebar -->
            <div class="space-y-4 sm:space-y-6">
                <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                    <div class="px-4 sm:px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <h3 class="text-base sm:text-lg font-semibold text-gray-900">File Information</h3>
                    </div>
                    <div class="px-4 sm:px-6 py-4 space-y-3">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">File Name</dt>
                            <dd class="mt-1 text-sm text-gray-900"><?php echo e($evidence->original_name); ?></dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">File Size</dt>
                            <dd class="mt-1 text-sm text-gray-900"><?php echo e($evidence->file_size_human); ?></dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">MIME Type</dt>
                            <dd class="mt-1 text-sm text-gray-900"><?php echo e($evidence->mime_type); ?></dd>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        <!-- POE Submission View (Backward Compatibility) -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Main Content -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Submission Info -->
                <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <h3 class="text-lg font-semibold text-gray-900">Submission Information</h3>
                    </div>
                    <div class="px-6 py-4">
                        <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Unit</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    <div class="font-medium"><?php echo e($submission->unit->name); ?></div>
                                    <?php if($submission->unit->code): ?>
                                        <div class="text-xs text-gray-500"><?php echo e($submission->unit->code); ?></div>
                                    <?php endif; ?>
                                </dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Class</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    <div class="font-medium"><?php echo e($submission->schoolClass->name); ?></div>
                                    <?php if($submission->schoolClass->code): ?>
                                        <div class="text-xs text-gray-500"><?php echo e($submission->schoolClass->code); ?></div>
                                    <?php endif; ?>
                                </dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Term</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    <?php echo e($submission->schoolClass->term->name); ?>

                                    <?php if($submission->schoolClass->term->status === 'active'): ?>
                                        <span class="ml-2 px-2 py-0.5 text-xs rounded-full bg-green-100 text-green-800">Active</span>
                                    <?php endif; ?>
                                </dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Status</dt>
                                <dd class="mt-1">
                                    <span class="px-3 py-1 text-sm font-semibold rounded-full <?php echo e($submission->getStatusBadgeClasses()); ?>">
                                        <?php echo e($submission->getStatusLabel()); ?>

                                    </span>
                                </dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Version</dt>
                                <dd class="mt-1 text-sm text-gray-900">v<?php echo e($submission->version); ?></dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Submitted At</dt>
                                <dd class="mt-1 text-sm text-gray-900">
                                    <?php if($submission->submitted_at): ?>
                                        <?php echo e($submission->submitted_at->format('M d, Y h:i A')); ?>

                                    <?php else: ?>
                                        <span class="text-gray-400">Not submitted</span>
                                    <?php endif; ?>
                                </dd>
                            </div>
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Created At</dt>
                                <dd class="mt-1 text-sm text-gray-900"><?php echo e($submission->created_at->format('M d, Y h:i A')); ?></dd>
                            </div>
                        </dl>
                        <?php if($submission->notes): ?>
                            <div class="mt-4 pt-4 border-t border-gray-200">
                                <dt class="text-sm font-medium text-gray-500 mb-1">Notes</dt>
                                <dd class="text-sm text-gray-900 bg-gray-50 p-3 rounded"><?php echo e($submission->notes); ?></dd>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

            <!-- Evidence Files -->
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-4 sm:px-6 py-4 border-b border-gray-200 bg-gray-50 flex flex-col sm:flex-row sm:justify-between sm:items-center gap-2">
                    <h3 class="text-base sm:text-lg font-semibold text-gray-900">Evidence Files (<?php echo e($submission->evidence->count()); ?>)</h3>
                </div>
                <div class="px-4 sm:px-6 py-4">
                    <?php $__empty_1 = true; $__currentLoopData = $submission->evidence; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $evidence): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="flex items-center justify-between p-4 border border-gray-200 rounded-lg mb-3 hover:bg-gray-50">
                            <div class="flex items-center space-x-4">
                                <div class="flex-shrink-0">
                                    <?php if($evidence->file_type === 'image'): ?>
                                        <svg class="h-10 w-10 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                        </svg>
                                    <?php elseif($evidence->file_type === 'video'): ?>
                                        <svg class="h-10 w-10 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z"></path>
                                        </svg>
                                    <?php else: ?>
                                        <svg class="h-10 w-10 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                        </svg>
                                    <?php endif; ?>
                                </div>
                                <div class="flex-1 min-w-0">
                                    <p class="text-sm font-medium text-gray-900 truncate"><?php echo e($evidence->file_name); ?></p>
                                    <p class="text-xs text-gray-500">
                                        <?php echo e(ucfirst($evidence->file_type)); ?> • <?php echo e(number_format($evidence->file_size / 1024, 2)); ?> KB
                                    </p>
                                </div>
                            </div>
                            <div class="flex items-center space-x-2">
                                <a href="<?php echo e(route('student.submissions.evidence.download', $evidence)); ?>" 
                                   class="inline-flex items-center justify-center px-3 py-2 min-h-[44px] sm:min-h-0 sm:py-1.5 text-sm bg-indigo-600 text-white rounded hover:bg-indigo-700 touch-manipulation">
                                    Download
                                </a>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <p class="text-gray-500 text-center py-8">No evidence files uploaded yet</p>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Reviews -->
            <?php if($submission->reviews->count() > 0): ?>
                <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <h3 class="text-lg font-semibold text-gray-900">Reviews (<?php echo e($submission->reviews->count()); ?>)</h3>
                    </div>
                    <div class="px-6 py-4 space-y-4">
                        <?php $__currentLoopData = $submission->reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="border-l-4 border-indigo-500 pl-4 py-2">
                                <div class="flex justify-between items-start mb-2">
                                    <div>
                                        <p class="font-medium text-gray-900"><?php echo e($review->reviewer->name ?? 'Unknown'); ?></p>
                                        <p class="text-xs text-gray-500"><?php echo e($review->reviewed_at ? $review->reviewed_at->format('M d, Y h:i A') : 'Not reviewed'); ?></p>
                                    </div>
                                    <?php if($review->marks): ?>
                                        <span class="px-2 py-1 text-xs font-semibold bg-green-100 text-green-800 rounded">
                                            <?php echo e($review->marks); ?> marks
                                        </span>
                                    <?php endif; ?>
                                </div>
                                <?php if($review->feedback): ?>
                                    <p class="text-sm text-gray-700"><?php echo e($review->feedback); ?></p>
                                <?php endif; ?>
                                <span class="inline-block mt-2 px-2 py-1 text-xs rounded-full
                                    <?php if($review->status === 'approved'): ?> bg-green-100 text-green-800
                                    <?php elseif($review->status === 'rejected'): ?> bg-red-100 text-red-800
                                    <?php else: ?> bg-yellow-100 text-yellow-800
                                    <?php endif; ?>">
                                    <?php echo e(ucfirst($review->status)); ?>

                                </span>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Validation -->
            <?php if($submission->validation): ?>
                <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <h3 class="text-lg font-semibold text-gray-900">Validation</h3>
                    </div>
                    <div class="px-6 py-4">
                        <div class="flex justify-between items-start mb-2">
                            <div>
                                <p class="font-medium text-gray-900"><?php echo e($submission->validation->validator->name ?? 'Unknown'); ?></p>
                                <p class="text-xs text-gray-500"><?php echo e($submission->validation->validated_at ? $submission->validation->validated_at->format('M d, Y h:i A') : 'Not validated'); ?></p>
                            </div>
                            <span class="px-3 py-1 text-sm font-semibold rounded-full
                                <?php if($submission->validation->status === 'approved'): ?> bg-green-100 text-green-800
                                <?php elseif($submission->validation->status === 'rejected'): ?> bg-red-100 text-red-800
                                <?php else: ?> bg-yellow-100 text-yellow-800
                                <?php endif; ?>">
                                <?php echo e(ucfirst($submission->validation->status)); ?>

                            </span>
                        </div>
                        <?php if($submission->validation->comments): ?>
                            <p class="text-sm text-gray-700 mt-2"><?php echo e($submission->validation->comments); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Actions -->
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">Actions</h3>
                </div>
                <div class="px-6 py-4 space-y-2">
                    <?php if($submission->status === 'draft'): ?>
                        <a href="<?php echo e(route('student.submissions.edit', $submission)); ?>" class="block w-full px-4 py-2.5 min-h-[44px] bg-yellow-600 text-white rounded-md hover:bg-yellow-700 text-center touch-manipulation flex items-center justify-center">
                            Edit Submission
                        </a>
                        <form action="<?php echo e(route('student.submissions.submit', $submission)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to submit this for review? You will not be able to edit it after submission.');">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="w-full px-4 py-2.5 min-h-[44px] bg-indigo-600 text-white rounded-md hover:bg-indigo-700 touch-manipulation">
                                Submit for Review
                            </button>
                        </form>
                        <form action="<?php echo e(route('student.submissions.destroy', $submission)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to delete this submission? This action cannot be undone.');">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="w-full px-4 py-2.5 min-h-[44px] bg-red-600 text-white rounded-md hover:bg-red-700 touch-manipulation">
                                Delete Submission
                            </button>
                        </form>
                    <?php else: ?>
                        <p class="text-sm text-gray-500 text-center py-2">
                            This submission has been submitted and cannot be edited.
                        </p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.student', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/student/submissions/show.blade.php ENDPATH**/ ?>