

<?php $__env->startSection('title', 'Messages'); ?>
<?php $__env->startSection('page-title', 'Messages'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <h1 class="text-2xl font-bold text-gray-900 mb-2">Messages</h1>
        <p class="text-gray-600">View your notifications and direct messages</p>
    </div>

    <!-- Messages List -->
    <?php if($messages->count() > 0): ?>
        <div class="bg-white rounded-xl shadow-md overflow-hidden">
            <div class="px-6 py-4 bg-gray-50 border-b border-gray-200">
                <h2 class="text-lg font-semibold text-gray-900">All Messages</h2>
            </div>
            <div class="divide-y divide-gray-200">
                <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('hod.messages.show', $message)); ?>" 
                       class="block px-6 py-4 hover:bg-purple-50 transition-colors <?php echo e(!$message->is_read && $message->receiver_id === auth()->id() ? 'bg-blue-50' : ''); ?>">
                        <div class="flex items-start justify-between">
                            <div class="flex-1">
                                <div class="flex items-center gap-3 mb-2">
                                    <div class="h-10 w-10 rounded-full bg-purple-100 flex items-center justify-center">
                                        <span class="text-purple-600 font-semibold text-sm">
                                            <?php echo e(substr($message->sender_id === auth()->id() ? $message->receiver->name : $message->sender->name, 0, 1)); ?>

                                        </span>
                                    </div>
                                    <div>
                                        <h3 class="text-sm font-semibold text-gray-900">
                                            <?php echo e($message->sender_id === auth()->id() ? 'To: ' . $message->receiver->name : 'From: ' . $message->sender->name); ?>

                                        </h3>
                                        <p class="text-xs text-gray-500"><?php echo e($message->created_at->diffForHumans()); ?></p>
                                    </div>
                                </div>
                                <p class="text-sm text-gray-700 line-clamp-2"><?php echo e($message->subject ?? 'No subject'); ?></p>
                                <?php if($message->message): ?>
                                    <p class="text-sm text-gray-600 mt-1 line-clamp-1"><?php echo e(Str::limit($message->message, 100)); ?></p>
                                <?php endif; ?>
                            </div>
                            <?php if(!$message->is_read && $message->receiver_id === auth()->id()): ?>
                                <span class="ml-4 bg-red-500 text-white text-xs font-semibold px-2 py-1 rounded-full">New</span>
                            <?php endif; ?>
                        </div>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="px-6 py-4 bg-gray-50 border-t border-gray-200">
                <?php echo e($messages->links()); ?>

            </div>
        </div>
    <?php else: ?>
        <div class="bg-white rounded-xl shadow-md p-12 text-center">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900">No messages</h3>
            <p class="mt-1 text-sm text-gray-500">You don't have any messages yet.</p>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.hod', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/hod/messages/index.blade.php ENDPATH**/ ?>