<?php $__env->startSection('title', 'Departmental Units'); ?>
<?php $__env->startSection('page-title', 'Departmental Units'); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-6 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
    <div>
        <h1 class="text-2xl font-bold text-gray-900">Departmental Units</h1>
        <p class="mt-1 text-sm text-gray-600">View all units in your department</p>
    </div>
    <a href="<?php echo e(route('hod.units.create')); ?>" class="inline-flex items-center px-4 py-2 bg-purple-600 text-white rounded-md hover:bg-purple-700 font-medium transition-colors">
        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
        </svg>
        Create Unit
    </a>
</div>

<?php if($activeTerm): ?>
    <div class="mb-6 p-4 bg-purple-50 border border-purple-200 rounded-lg">
        <p class="text-sm text-purple-800"><strong>Active Term:</strong> <?php echo e($activeTerm->name); ?></p>
    </div>
<?php endif; ?>

<!-- Filters -->
<div class="mb-6 bg-white rounded-xl shadow-md p-6">
    <form method="GET" class="grid grid-cols-1 md:grid-cols-5 gap-4">
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Class</label>
            <select name="class" class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                <option value="">All Classes</option>
                <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($class->id); ?>" <?php echo e(request('class') == $class->id ? 'selected' : ''); ?>><?php echo e($class->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Level</label>
            <select name="level" class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                <option value="">All Levels</option>
                <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($level->id); ?>" <?php echo e(request('level') == $level->id ? 'selected' : ''); ?>><?php echo e($level->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Trainer</label>
            <select name="trainer" class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                <option value="">All Trainers</option>
                <?php $__currentLoopData = $trainers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trainer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($trainer->id); ?>" <?php echo e(request('trainer') == $trainer->id ? 'selected' : ''); ?>><?php echo e($trainer->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Unit</label>
            <select name="unit" class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                <option value="">All Units</option>
                <?php $__currentLoopData = $allUnits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unitOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($unitOption->id); ?>" <?php echo e(request('unit') == $unitOption->id ? 'selected' : ''); ?>><?php echo e($unitOption->name); ?> (<?php echo e($unitOption->code); ?>)</option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="flex items-end gap-2">
            <button type="submit" class="flex-1 bg-purple-600 text-white px-4 py-2 rounded-lg hover:bg-purple-700 transition-colors font-medium">
                Filter
            </button>
            <?php if(request()->hasAny(['class', 'level', 'trainer', 'unit'])): ?>
                <a href="<?php echo e(route('hod.units.departmental')); ?>" class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition-colors font-medium">
                    Clear
                </a>
            <?php endif; ?>
        </div>
    </form>
</div>

<?php if($units->count() > 0): ?>
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bg-white rounded-xl shadow-md hover:shadow-xl transition-shadow border-l-4 <?php echo e($unit->is_allocated_to_hod ? 'border-purple-500' : 'border-gray-300'); ?>">
                <div class="p-6">
                    <div class="flex items-start justify-between mb-4">
                        <div class="flex-1">
                            <a href="<?php echo e(route('hod.units.show', ['unit' => $unit, 'context' => 'departmental'])); ?>" class="block">
                                <h3 class="text-lg font-semibold text-gray-900 hover:text-purple-600 transition-colors"><?php echo e($unit->name); ?></h3>
                            </a>
                            <?php if($unit->code): ?>
                                <p class="text-sm text-gray-500 mt-1"><?php echo e($unit->code); ?></p>
                            <?php endif; ?>
                            <?php if($unit->department): ?>
                                <p class="text-xs text-gray-400 mt-1"><?php echo e($unit->department->name); ?></p>
                            <?php endif; ?>
                            <?php if($unit->is_allocated_to_hod): ?>
                                <span class="inline-block mt-2 px-2 py-1 text-xs font-semibold rounded-full bg-purple-100 text-purple-800">
                                    Allocated to You
                                </span>
                            <?php else: ?>
                                <span class="inline-block mt-2 px-2 py-1 text-xs font-semibold rounded-full bg-gray-100 text-gray-600">
                                    Not Allocated
                                </span>
                            <?php endif; ?>
                        </div>
                        <a href="<?php echo e(route('hod.units.show', ['unit' => $unit, 'context' => 'departmental'])); ?>" class="text-purple-600 hover:text-purple-800">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                            </svg>
                        </a>
                    </div>
                    
                    <div class="space-y-2 text-sm">
                        <div class="flex items-center text-gray-600">
                            <svg class="w-4 h-4 mr-2 text-purple-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                            </svg>
                            <?php echo e($unit->classes_count ?? 0); ?> Classes
                        </div>
                        <div class="flex items-center text-gray-600">
                            <svg class="w-4 h-4 mr-2 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                            </svg>
                            <?php echo e($unit->assignments_count ?? 0); ?> Assignments
                        </div>
                        <div class="flex items-center text-gray-600">
                            <svg class="w-4 h-4 mr-2 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                            <?php echo e($unit->submissions_count ?? 0); ?> Submissions
                        </div>
                        <div class="flex items-center text-gray-600">
                            <svg class="w-4 h-4 mr-2 text-amber-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                            </svg>
                            <?php echo e($unit->trainers_count ?? 0); ?> Trainers
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php else: ?>
    <div class="bg-white rounded-xl shadow-md p-12 text-center">
        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
        </svg>
        <h3 class="mt-2 text-sm font-medium text-gray-900">No units found</h3>
        <?php if(request()->hasAny(['class', 'level', 'trainer', 'unit'])): ?>
            <p class="mt-1 text-sm text-gray-500">No units match the selected filters. Try adjusting your filter criteria.</p>
            <div class="mt-6">
                <a href="<?php echo e(route('hod.units.departmental')); ?>" class="inline-flex items-center px-4 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50 font-medium transition-colors">
                    Clear Filters
                </a>
            </div>
        <?php else: ?>
            <p class="mt-1 text-sm text-gray-500">There are no units in your department yet.</p>
            <div class="mt-6">
                <a href="<?php echo e(route('hod.units.create')); ?>" class="inline-flex items-center px-4 py-2 bg-purple-600 text-white rounded-md hover:bg-purple-700 font-medium transition-colors">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                    </svg>
                    Create First Unit
                </a>
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.hod', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/hod/units/departmental.blade.php ENDPATH**/ ?>