<?php $__env->startSection('title', $unit->name); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-900"><?php echo e($unit->name); ?></h1>
                <?php if($unit->code): ?>
                    <p class="text-sm text-gray-600 mt-1">Code: <?php echo e($unit->code); ?></p>
                <?php endif; ?>
                <?php if($unit->department): ?>
                    <p class="text-sm text-gray-600"><?php echo e($unit->department->name); ?></p>
                <?php endif; ?>
            </div>
            <button onclick="document.getElementById('assignmentModal').classList.remove('hidden')" class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-md hover:bg-blue-700">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                </svg>
                Create Assignment
            </button>
        </div>
    </div>

    <?php if($activeTerm): ?>
        <div class="mb-6 p-4 bg-blue-50 border border-blue-200 rounded-lg">
            <p class="text-sm text-blue-800"><strong>Active Term:</strong> <?php echo e($activeTerm->name); ?></p>
        </div>
    <?php endif; ?>

    <!-- Tabs -->
    <div class="mb-6 border-b border-gray-200">
        <nav class="-mb-px flex space-x-8">
            <button onclick="showTab('assignments')" id="tab-assignments" class="tab-button border-b-2 border-blue-500 py-4 px-1 text-sm font-medium text-blue-600">
                Assignments
            </button>
            <button onclick="showTab('students')" id="tab-students" class="tab-button border-b-2 border-transparent py-4 px-1 text-sm font-medium text-gray-500 hover:text-gray-700 hover:border-gray-300">
                Students
            </button>
            <button onclick="showTab('submissions')" id="tab-submissions" class="tab-button border-b-2 border-transparent py-4 px-1 text-sm font-medium text-gray-500 hover:text-gray-700 hover:border-gray-300">
                Submissions
            </button>
        </nav>
    </div>

    <!-- Assignments Tab -->
    <div id="content-assignments" class="tab-content">
        <div class="bg-white rounded-lg shadow">
            <div class="p-6">
                <div class="flex items-center justify-between mb-4">
                    <h2 class="text-lg font-semibold text-gray-900">Assignments & Exams</h2>
                </div>
                
                <?php if($assignments->count() > 0): ?>
                    <div class="space-y-4">
                    <?php $__currentLoopData = $assignments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="border border-gray-200 rounded-lg p-4 hover:bg-gray-50">
                                <div class="flex items-start justify-between">
                                    <div class="flex-1">
                                        <div class="flex items-center gap-2 mb-2">
                                            <h3 class="font-semibold text-gray-900"><?php echo e($assignment->title); ?></h3>
                                            <span class="px-2 py-1 text-xs font-medium rounded <?php echo e($assignment->getStatusBadgeClasses()); ?>">
                                                <?php echo e($assignment->getTypeLabel()); ?>

                                            </span>
                                            <?php if($assignment->is_published): ?>
                                                <span class="px-2 py-1 text-xs font-medium rounded bg-green-100 text-green-800">Published</span>
                                            <?php else: ?>
                                                <span class="px-2 py-1 text-xs font-medium rounded bg-gray-100 text-gray-800">Draft</span>
                                            <?php endif; ?>
                                        </div>
                                        <?php if($assignment->description): ?>
                                            <p class="text-sm text-gray-600 mb-2"><?php echo e(Str::limit($assignment->description, 150)); ?></p>
                                        <?php endif; ?>
                                        <div class="flex flex-wrap gap-4 text-sm text-gray-500 mb-2">
                                            <?php if($assignment->total_marks): ?>
                                                <span>Marks: <?php echo e($assignment->total_marks); ?></span>
                                            <?php endif; ?>
                                            <?php if($assignment->due_date): ?>
                                                <span>Due: <?php echo e($assignment->due_date->format('M d, Y')); ?></span>
                                            <?php endif; ?>
                                            <?php if($assignment->start_date): ?>
                                                <span>Starts: <?php echo e($assignment->start_date->format('M d, Y')); ?></span>
                                            <?php endif; ?>
                                        </div>
                                        <?php if($assignment->type === 'practical'): ?>
                                            <div class="mt-2 flex flex-wrap gap-2 text-xs">
                                                <?php if($assignment->candidate_tool && count($assignment->candidate_tool) > 0): ?>
                                                    <span class="px-2 py-1 bg-blue-100 text-blue-800 rounded">
                                                        Candidate Tool: <?php echo e(count($assignment->candidate_tool)); ?> file(s)
                                                    </span>
                                                <?php endif; ?>
                                                <?php if($assignment->assessor_tool && count($assignment->assessor_tool) > 0): ?>
                                                    <span class="px-2 py-1 bg-purple-100 text-purple-800 rounded">
                                                        Assessor Tool: <?php echo e(count($assignment->assessor_tool)); ?> file(s)
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="flex gap-2 ml-4">
                                        <!-- View Button -->
                                        <a href="<?php echo e(route('trainer.assignments.show', $assignment)); ?>" 
                                           class="inline-flex items-center px-3 py-1.5 text-sm font-medium text-blue-700 bg-blue-50 rounded-md hover:bg-blue-100 transition-colors"
                                           title="View Assignment">
                                            <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                            </svg>
                                            View
                                        </a>
                                        
                                        <!-- Edit Button -->
                                        <a href="<?php echo e(route('trainer.assignments.edit', $assignment)); ?>" 
                                           class="inline-flex items-center px-3 py-1.5 text-sm font-medium text-gray-700 bg-gray-50 rounded-md hover:bg-gray-100 transition-colors"
                                           title="Edit Assignment">
                                            <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                            </svg>
                                            Edit
                                        </a>
                                        
                                        <!-- Delete Button -->
                                        <form action="<?php echo e(route('trainer.assignments.destroy', $assignment)); ?>" 
                                              method="POST" 
                                              onsubmit="return confirm('Are you sure you want to delete this assignment?');"
                                              class="inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" 
                                                    class="inline-flex items-center px-3 py-1.5 text-sm font-medium text-red-700 bg-red-50 rounded-md hover:bg-red-100 transition-colors"
                                                    title="Delete Assignment">
                                                <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                                </svg>
                                                Delete
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="mt-4">
                        <?php echo e($assignments->links()); ?>

                    </div>
                <?php else: ?>
                    <div class="text-center py-8">
                        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                        </svg>
                        <h3 class="mt-2 text-sm font-medium text-gray-900">No assignments yet</h3>
                        <p class="mt-1 text-sm text-gray-500">Create your first assignment or exam.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Students Tab -->
    <div id="content-students" class="tab-content hidden">
        <div class="bg-white rounded-lg shadow">
            <div class="p-6">
                <h2 class="text-lg font-semibold text-gray-900 mb-4">Students</h2>
                <?php if($students->count() > 0): ?>
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Name</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Email</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Class</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="px-4 py-3 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo e($student->name); ?></td>
                                        <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-500"><?php echo e($student->email); ?></td>
                                        <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-500">
                                            <?php $__currentLoopData = $student->enrollments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enrollment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($enrollment->schoolClass): ?>
                                                    <?php echo e($enrollment->schoolClass->name); ?><?php if(!$loop->last): ?>, <?php endif; ?>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <p class="text-sm text-gray-500">No students enrolled in this unit.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Submissions Tab -->
    <div id="content-submissions" class="tab-content hidden">
        <div class="bg-white rounded-lg shadow">
            <div class="p-6">
                <h2 class="text-lg font-semibold text-gray-900 mb-4">Submissions</h2>
                <?php if($submissions->count() > 0): ?>
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Student</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Class</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Submitted</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                <?php $__currentLoopData = $submissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $submission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="px-4 py-3 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo e($submission->student->name); ?></td>
                                        <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-500"><?php echo e($submission->schoolClass->name); ?></td>
                                        <td class="px-4 py-3 whitespace-nowrap">
                                            <span class="px-2 py-1 text-xs font-semibold rounded-full <?php echo e($submission->getStatusBadgeClasses()); ?>">
                                                <?php echo e($submission->getStatusLabel()); ?>

                                            </span>
                                        </td>
                                        <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-500">
                                            <?php echo e($submission->submitted_at ? $submission->submitted_at->format('M d, Y') : '-'); ?>

                                        </td>
                                        <td class="px-4 py-3 whitespace-nowrap text-sm">
                                            <a href="<?php echo e(route('trainer.submissions.show', $submission)); ?>" class="text-blue-600 hover:text-blue-800">View</a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-4">
                        <?php echo e($submissions->links()); ?>

                    </div>
                <?php else: ?>
                    <p class="text-sm text-gray-500">No submissions yet.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Assignment Creation Modal -->
    <div id="assignmentModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
        <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-3/4 lg:w-1/2 shadow-lg rounded-md bg-white">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-semibold text-gray-900">Create Assignment/Exam</h3>
                <button onclick="document.getElementById('assignmentModal').classList.add('hidden')" class="text-gray-400 hover:text-gray-600">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </button>
            </div>
            
            <form id="assignmentForm" action="<?php echo e(route('trainer.assignments.store', $unit)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Title *</label>
                        <input type="text" name="title" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Type *</label>
                        <select name="type" id="assignment_type" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" onchange="togglePracticalFields()">
                            <option value="assignment">Assignment</option>
                            <option value="exam">Exam</option>
                            <option value="practical">Practical</option>
                            <option value="project">Project</option>
                        </select>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Class *</label>
                        <select name="class_id" required class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            <option value="">Select a class</option>
                            <?php $__currentLoopData = $assignedClasses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($class->id); ?>"><?php echo e($class->name); ?> (<?php echo e($class->code); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <p class="mt-1 text-xs text-gray-500">Select the class this assignment is for</p>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Description</label>
                        <textarea name="description" rows="3" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"></textarea>
                    </div>
                    
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Total Marks</label>
                            <input type="number" name="total_marks" min="0" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Due Date</label>
                            <input type="datetime-local" name="due_date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        </div>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Start Date</label>
                        <input type="datetime-local" name="start_date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Instructions</label>
                        <textarea name="instructions" rows="4" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"></textarea>
                    </div>
                    
                    <!-- Regular Attachments (for non-practical assignments) -->
                    <div id="regular_attachments">
                        <label class="block text-sm font-medium text-gray-700">Attachments</label>
                        <input type="file" name="attachments[]" multiple class="mt-1 block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                        <p class="mt-1 text-xs text-gray-500">You can select multiple files (max 10MB each)</p>
                    </div>

                    <!-- Practical Tools (only for practical assignments) -->
                    <div id="practical_tools" class="hidden space-y-4">
                        <div class="p-4 bg-blue-50 border border-blue-200 rounded-lg">
                            <p class="text-sm font-medium text-blue-900 mb-3">Practical Assessment Tools</p>
                            <p class="text-xs text-blue-700 mb-4">For practical assessments, you must upload both the Candidate Tool (for students) and Assessor Tool (marking guide).</p>
                            
                            <div class="space-y-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Candidate Tool <span class="text-red-500">*</span>
                                    </label>
                                    <div class="bg-white p-3 border border-gray-300 rounded-lg">
                                        <input type="file" name="candidate_tool[]" id="candidate_tool_input" multiple class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100" disabled>
                                        <p class="mt-2 text-xs text-gray-600">
                                            <strong>Purpose:</strong> Questions and procedures for students<br>
                                            <strong>Visibility:</strong> Students can access from start date<br>
                                            <strong>Max size:</strong> 10MB per file
                                        </p>
                                    </div>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2">
                                        Assessor Tool <span class="text-red-500">*</span>
                                    </label>
                                    <div class="bg-white p-3 border border-gray-300 rounded-lg">
                                        <input type="file" name="assessor_tool[]" id="assessor_tool_input" multiple class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-purple-50 file:text-purple-700 hover:file:bg-purple-100" disabled>
                                        <p class="mt-2 text-xs text-gray-600">
                                            <strong>Purpose:</strong> Marking guide used to award marks<br>
                                            <strong>Visibility:</strong> Hidden from students until marks are awarded<br>
                                            <strong>Max size:</strong> 10MB per file
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="flex items-center">
                        <input type="checkbox" name="is_published" value="1" id="is_published" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                        <label for="is_published" class="ml-2 block text-sm text-gray-900">Publish immediately (visible to students)</label>
                    </div>
                </div>
                
                <div class="mt-6 flex justify-end gap-3">
                    <button type="button" onclick="document.getElementById('assignmentModal').classList.add('hidden')" class="px-4 py-2 bg-gray-200 text-gray-800 rounded-md hover:bg-gray-300">
                        Cancel
                    </button>
                    <button type="submit" id="createAssignmentBtn" class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700">
                        Create Assignment
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        function showTab(tabName) {
            // Hide all tab contents
            document.querySelectorAll('.tab-content').forEach(content => {
                content.classList.add('hidden');
            });
            
            // Remove active class from all tabs
            document.querySelectorAll('.tab-button').forEach(button => {
                button.classList.remove('border-blue-500', 'text-blue-600');
                button.classList.add('border-transparent', 'text-gray-500');
            });
            
            // Show selected tab content
            document.getElementById('content-' + tabName).classList.remove('hidden');
            
            // Add active class to selected tab
            const activeTab = document.getElementById('tab-' + tabName);
            activeTab.classList.remove('border-transparent', 'text-gray-500');
            activeTab.classList.add('border-blue-500', 'text-blue-600');
        }

        function togglePracticalFields() {
            const assignmentType = document.getElementById('assignment_type').value;
            const regularAttachments = document.getElementById('regular_attachments');
            const practicalTools = document.getElementById('practical_tools');
            
            // Get all file inputs
            const candidateToolInputs = document.querySelectorAll('input[name="candidate_tool[]"]');
            const assessorToolInputs = document.querySelectorAll('input[name="assessor_tool[]"]');
            
            if (assignmentType === 'practical') {
                regularAttachments.classList.add('hidden');
                practicalTools.classList.remove('hidden');
                // Make practical tool fields required and visible
                candidateToolInputs.forEach(input => {
                    input.setAttribute('required', 'required');
                    input.removeAttribute('disabled');
                    input.style.display = 'block';
                });
                assessorToolInputs.forEach(input => {
                    input.setAttribute('required', 'required');
                    input.removeAttribute('disabled');
                    input.style.display = 'block';
                });
            } else {
                regularAttachments.classList.remove('hidden');
                practicalTools.classList.add('hidden');
                // Remove required attribute and disable fields for non-practical types
                candidateToolInputs.forEach(input => {
                    input.removeAttribute('required');
                    input.setAttribute('disabled', 'disabled');
                    input.value = ''; // Clear the value
                });
                assessorToolInputs.forEach(input => {
                    input.removeAttribute('required');
                    input.setAttribute('disabled', 'disabled');
                    input.value = ''; // Clear the value
                });
            }
        }

        // Initialize on page load
        document.addEventListener('DOMContentLoaded', function() {
            togglePracticalFields();
        });
        
        // Handle form submission
        document.getElementById('assignmentForm')?.addEventListener('submit', function(e) {
            const assignmentType = document.getElementById('assignment_type').value;
            const candidateToolInput = document.getElementById('candidate_tool_input');
            const assessorToolInput = document.getElementById('assessor_tool_input');
            
            // For non-practical types, remove required and disable fields BEFORE validation
            if (assignmentType !== 'practical') {
                // Remove required attributes to prevent browser validation errors
                const allCandidateInputs = document.querySelectorAll('input[name="candidate_tool[]"]');
                const allAssessorInputs = document.querySelectorAll('input[name="assessor_tool[]"]');
                
                allCandidateInputs.forEach(input => {
                    input.removeAttribute('required');
                    input.setAttribute('disabled', 'disabled');
                    input.value = '';
                });
                
                allAssessorInputs.forEach(input => {
                    input.removeAttribute('required');
                    input.setAttribute('disabled', 'disabled');
                    input.value = '';
                });
            }
            
            // For practical assignments, validate that tools are provided
            if (assignmentType === 'practical') {
                if (!candidateToolInput || !candidateToolInput.files || candidateToolInput.files.length === 0) {
                    e.preventDefault();
                    alert('Please upload at least one Candidate Tool file for practical assessments.');
                    candidateToolInput?.focus();
                    return false;
                }
                if (!assessorToolInput || !assessorToolInput.files || assessorToolInput.files.length === 0) {
                    e.preventDefault();
                    alert('Please upload at least one Assessor Tool file for practical assessments.');
                    assessorToolInput?.focus();
                    return false;
                }
            }
            
            // Show loading state
            const submitBtn = document.getElementById('createAssignmentBtn');
            if (submitBtn) {
                submitBtn.disabled = true;
                submitBtn.innerHTML = '<span class="inline-block animate-spin mr-2">⏳</span>Creating...';
            }
            
            return true;
        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.trainer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/trainer/units/show.blade.php ENDPATH**/ ?>