<?php $__env->startSection('title', 'Practical Evidence Details'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-6">
        <a href="<?php echo e(route('trainer.practical-evidence.index', $practicalEvidence->unit)); ?>" class="text-indigo-600 hover:text-indigo-900 flex items-center">
            <svg class="h-5 w-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
            </svg>
            Back to Evidence List
        </a>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Content -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Evidence Info -->
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">Evidence Information</h3>
                </div>
                <div class="px-6 py-4">
                    <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Student</dt>
                            <dd class="mt-1 text-sm text-gray-900 font-medium"><?php echo e($practicalEvidence->student->name); ?></dd>
                            <dd class="text-xs text-gray-500"><?php echo e($practicalEvidence->student->email); ?></dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Unit</dt>
                            <dd class="mt-1 text-sm text-gray-900"><?php echo e($practicalEvidence->unit->name); ?></dd>
                            <?php if($practicalEvidence->unit->code): ?>
                                <dd class="text-xs text-gray-500"><?php echo e($practicalEvidence->unit->code); ?></dd>
                            <?php endif; ?>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Task Name</dt>
                            <dd class="mt-1 text-sm text-gray-900 font-medium"><?php echo e($practicalEvidence->task_name); ?></dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Evidence Type</dt>
                            <dd class="mt-1">
                                <span class="px-2 py-1 text-xs font-semibold rounded-full 
                                    <?php if($practicalEvidence->isVideo()): ?> bg-red-100 text-red-800
                                    <?php elseif($practicalEvidence->isImage()): ?> bg-green-100 text-green-800
                                    <?php elseif($practicalEvidence->isAudio()): ?> bg-purple-100 text-purple-800
                                    <?php else: ?> bg-blue-100 text-blue-800
                                    <?php endif; ?>">
                                    <?php echo e(ucfirst($practicalEvidence->evidence_type)); ?>

                                </span>
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Status</dt>
                            <dd class="mt-1">
                                <span class="px-3 py-1 text-sm font-semibold rounded-full <?php echo e($practicalEvidence->getStatusBadgeClasses()); ?>">
                                    <?php echo e($practicalEvidence->getStatusLabel()); ?>

                                </span>
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Uploaded At</dt>
                            <dd class="mt-1 text-sm text-gray-900"><?php echo e($practicalEvidence->uploaded_at->format('M d, Y h:i A')); ?></dd>
                        </div>
                    </dl>
                    <?php if($practicalEvidence->notes): ?>
                        <div class="mt-4 pt-4 border-t border-gray-200">
                            <dt class="text-sm font-medium text-gray-500 mb-1">Student Notes</dt>
                            <dd class="text-sm text-gray-900 bg-gray-50 p-3 rounded"><?php echo e($practicalEvidence->notes); ?></dd>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Media Preview -->
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">Media Evidence</h3>
                </div>
                <div class="px-6 py-4">
                    <?php if($practicalEvidence->isVideo()): ?>
                        <video controls class="w-full rounded-lg" style="max-height: 500px;">
                            <source src="<?php echo e(Storage::url($practicalEvidence->file_path)); ?>" type="<?php echo e($practicalEvidence->mime_type); ?>">
                            Your browser does not support the video tag.
                        </video>
                    <?php elseif($practicalEvidence->isImage()): ?>
                        <img src="<?php echo e(Storage::url($practicalEvidence->file_path)); ?>" alt="<?php echo e($practicalEvidence->task_name); ?>" class="w-full rounded-lg" style="max-height: 500px; object-fit: contain;">
                    <?php elseif($practicalEvidence->isAudio()): ?>
                        <audio controls class="w-full">
                            <source src="<?php echo e(Storage::url($practicalEvidence->file_path)); ?>" type="<?php echo e($practicalEvidence->mime_type); ?>">
                            Your browser does not support the audio tag.
                        </audio>
                    <?php else: ?>
                        <div class="text-center py-8">
                            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                            </svg>
                            <p class="mt-2 text-sm text-gray-500">Document file</p>
                        </div>
                    <?php endif; ?>
                    <div class="mt-4 flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-gray-900"><?php echo e($practicalEvidence->original_name); ?></p>
                            <p class="text-xs text-gray-500"><?php echo e($practicalEvidence->file_size_human); ?></p>
                        </div>
                        <a href="<?php echo e(route('trainer.practical-evidence.download', $practicalEvidence)); ?>" class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 text-sm font-medium">
                            Download
                        </a>
                    </div>
                </div>
            </div>

            <!-- Comments -->
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">Comments (<?php echo e($practicalEvidence->comments->count()); ?>)</h3>
                </div>
                <div class="px-6 py-4 space-y-4">
                    <?php $__empty_1 = true; $__currentLoopData = $practicalEvidence->comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="border-l-4 border-indigo-500 pl-4 py-2">
                            <div class="flex justify-between items-start mb-2">
                                <div>
                                    <p class="font-medium text-gray-900"><?php echo e($comment->user->name ?? 'Unknown'); ?></p>
                                    <p class="text-xs text-gray-500"><?php echo e($comment->created_at->format('M d, Y h:i A')); ?></p>
                                </div>
                                <span class="px-2 py-1 text-xs font-semibold rounded-full bg-indigo-100 text-indigo-800">
                                    <?php echo e(ucfirst($comment->role)); ?>

                                </span>
                            </div>
                            <p class="text-sm text-gray-700"><?php echo e($comment->comment); ?></p>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <p class="text-sm text-gray-500 text-center py-4">No comments yet</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Status Update -->
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">Update Status</h3>
                </div>
                <div class="px-6 py-4">
                    <form action="<?php echo e(route('trainer.practical-evidence.update-status', $practicalEvidence)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="space-y-4">
                            <div>
                                <label for="status" class="block text-sm font-medium text-gray-700 mb-2">Status</label>
                                <select name="status" id="status" required class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    <option value="reviewed" <?php echo e($practicalEvidence->status === 'reviewed' ? 'selected' : ''); ?>>Reviewed</option>
                                    <option value="accepted" <?php echo e($practicalEvidence->status === 'accepted' ? 'selected' : ''); ?>>Accepted</option>
                                    <option value="rejected" <?php echo e($practicalEvidence->status === 'rejected' ? 'selected' : ''); ?>>Rejected</option>
                                </select>
                            </div>
                            <div>
                                <label for="comment" class="block text-sm font-medium text-gray-700 mb-2">Comment (Optional)</label>
                                <textarea name="comment" id="comment" rows="3" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" placeholder="Add a comment..."></textarea>
                            </div>
                            <button type="submit" class="w-full px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 text-sm font-medium">
                                Update Status
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Add Comment -->
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">Add Comment</h3>
                </div>
                <div class="px-6 py-4">
                    <form action="<?php echo e(route('trainer.practical-evidence.comment', $practicalEvidence)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="space-y-4">
                            <div>
                                <textarea name="comment" rows="3" required class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" placeholder="Enter your comment..."></textarea>
                            </div>
                            <button type="submit" class="w-full px-4 py-2 bg-gray-600 text-white rounded-md hover:bg-gray-700 text-sm font-medium">
                                Add Comment
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.trainer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/trainer/practical-evidence/show.blade.php ENDPATH**/ ?>