<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps(['active' => '', 'sidebarOpen' => 'sidebarOpen']) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps(['active' => '', 'sidebarOpen' => 'sidebarOpen']); ?>
<?php foreach (array_filter((['active' => '', 'sidebarOpen' => 'sidebarOpen']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<?php
    $userManagementOpen = request()->routeIs('admin.users.*');
?>

<!-- Mobile Sidebar -->
<div x-data="{ open: <?php echo e($userManagementOpen ? 'true' : 'false'); ?> }"
     x-show="$store.sidebarOpen"
     x-cloak
     @click.away="$store.sidebarOpen = false"
     x-transition:enter="transition ease-out duration-300 transform"
     x-transition:enter-start="-translate-x-full"
     x-transition:enter-end="translate-x-0"
     x-transition:leave="transition ease-in duration-300 transform"
     x-transition:leave-start="translate-x-0"
     x-transition:leave-end="-translate-x-full"
     class="fixed inset-y-0 left-0 z-50 w-64 md:hidden">
    <div class="flex flex-col h-full bg-indigo-800 border-r border-indigo-900">
        <div class="flex items-center justify-between flex-shrink-0 px-4 pt-5 pb-4 border-b border-indigo-700">
            <a href="<?php echo e(route('admin.dashboard')); ?>" class="text-2xl font-bold text-white hover:text-indigo-200">EPOE System</a>
            <button @click="$store.sidebarOpen = false" class="text-indigo-200 hover:text-white focus:outline-none">
                <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
        <div class="flex-1 flex flex-col overflow-hidden">
            <nav class="flex-1 px-2 space-y-1 py-4">
                <?php echo $__env->make('components.partials.admin-sidebar-nav', ['isMobile' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </nav>
        </div>
    </div>
</div>

<!-- Desktop Sidebar -->
<div class="hidden md:flex md:flex-shrink-0">
    <div class="flex flex-col w-64">
        <div class="flex flex-col flex-grow pt-5 bg-indigo-800 border-r border-indigo-900">
            <div class="flex items-center flex-shrink-0 px-4 mb-8">
                <a href="<?php echo e(route('admin.dashboard')); ?>" class="text-2xl font-bold text-white hover:text-indigo-200">EPOE System</a>
            </div>
            <div class="flex-1 flex flex-col overflow-hidden">
                <nav class="flex-1 px-2 space-y-1">
                    <?php echo $__env->make('components.partials.admin-sidebar-nav', ['isMobile' => false], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </nav>
            </div>
        </div>
    </div>
</div>
<?php /**PATH D:\poe\resources\views/components/admin-sidebar.blade.php ENDPATH**/ ?>